/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricDetailVariableUpdateQueryTest {
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String VARIABLE_NAME = "myVar";
    protected static final String TENANT_NULL_VAR = "tenantNullVar";
    protected static final String TENANT_ONE_VAR = "tenant1Var";
    protected static final String TENANT_TWO_VAR = "tenant2Var";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();
        this.testRule.deployForTenant(TENANT_NULL, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_ONE, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_TWO, oneTaskProcess);
        ProcessInstance processInstanceNull = this.startProcessInstanceForTenant(TENANT_NULL, TENANT_NULL_VAR);
        ProcessInstance processInstanceOne = this.startProcessInstanceForTenant(TENANT_ONE, TENANT_ONE_VAR);
        ProcessInstance processInstanceTwo = this.startProcessInstanceForTenant(TENANT_TWO, TENANT_TWO_VAR);
        this.completeUserTask(processInstanceNull, "tenantNullVar_updated");
        this.completeUserTask(processInstanceOne, "tenant1Var_updated");
        this.completeUserTask(processInstanceTwo, "tenant2Var_updated");
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
    }

    @Test
    public void shouldQueryFilterWithoutTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricDetailQuery queryTenantOne = this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{TENANT_ONE});
        HistoricDetailQuery queryTenantTwo = this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)queryTenantOne.count()).isEqualTo(2L);
        Assertions.assertThat((long)queryTenantTwo.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicDetails.size()).isEqualTo(6);
        TestOrderingUtil.verifySorting(historicDetails, TestOrderingUtil.historicDetailByTenantId());
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicDetails.size()).isEqualTo(6);
        TestOrderingUtil.verifySorting(historicDetails, TestOrderingUtil.inverted(TestOrderingUtil.historicDetailByTenantId()));
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant, String var) {
        return ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").setVariable(VARIABLE_NAME, (Object)var)).processDefinitionTenantId(tenant).execute();
    }

    protected void completeUserTask(ProcessInstance processInstance, String varValue) {
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)task).isNotNull();
        HashMap<String, String> updatedVariables = new HashMap<String, String>();
        updatedVariables.put(VARIABLE_NAME, varValue);
        this.taskService.complete(task.getId(), updatedVariables);
    }
}

