/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.entitymanager.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperationType;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.comparator.DbBulkOperationComparator;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.comparator.DbEntityOperationComparator;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.comparator.EntityTypeComparatorForInserts;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.comparator.EntityTypeComparatorForModifications;

public class DbOperationManager {
    public static Comparator<Class<?>> INSERT_TYPE_COMPARATOR = new EntityTypeComparatorForInserts();
    public static Comparator<Class<?>> MODIFICATION_TYPE_COMPARATOR = new EntityTypeComparatorForModifications();
    public static Comparator<DbEntityOperation> INSERT_OPERATION_COMPARATOR = new DbEntityOperationComparator();
    public static Comparator<DbEntityOperation> MODIFICATION_OPERATION_COMPARATOR = new DbEntityOperationComparator();
    public static Comparator<DbBulkOperation> BULK_OPERATION_COMPARATOR = new DbBulkOperationComparator();
    public SortedMap<Class<?>, SortedSet<DbEntityOperation>> inserts = new TreeMap(INSERT_TYPE_COMPARATOR);
    public SortedMap<Class<?>, SortedSet<DbEntityOperation>> updates = new TreeMap(MODIFICATION_TYPE_COMPARATOR);
    public SortedMap<Class<?>, SortedSet<DbEntityOperation>> deletes = new TreeMap(MODIFICATION_TYPE_COMPARATOR);
    public SortedMap<Class<?>, SortedSet<DbBulkOperation>> bulkOperations = new TreeMap(MODIFICATION_TYPE_COMPARATOR);
    public LinkedHashSet<DbBulkOperation> bulkOperationsInsertionOrder = new LinkedHashSet();

    public boolean addOperation(DbEntityOperation newOperation) {
        if (newOperation.getOperationType() == DbOperationType.INSERT) {
            return this.getInsertsForType(newOperation.getEntityType(), true).add(newOperation);
        }
        if (newOperation.getOperationType() == DbOperationType.DELETE) {
            return this.getDeletesByType(newOperation.getEntityType(), true).add(newOperation);
        }
        return this.getUpdatesByType(newOperation.getEntityType(), true).add(newOperation);
    }

    protected SortedSet<DbEntityOperation> getDeletesByType(Class<? extends DbEntity> type, boolean create) {
        TreeSet<DbEntityOperation> deletesByType = (TreeSet<DbEntityOperation>)this.deletes.get(type);
        if (deletesByType == null && create) {
            deletesByType = new TreeSet<DbEntityOperation>(MODIFICATION_OPERATION_COMPARATOR);
            this.deletes.put(type, deletesByType);
        }
        return deletesByType;
    }

    protected SortedSet<DbEntityOperation> getUpdatesByType(Class<? extends DbEntity> type, boolean create) {
        TreeSet<DbEntityOperation> updatesByType = (TreeSet<DbEntityOperation>)this.updates.get(type);
        if (updatesByType == null && create) {
            updatesByType = new TreeSet<DbEntityOperation>(MODIFICATION_OPERATION_COMPARATOR);
            this.updates.put(type, updatesByType);
        }
        return updatesByType;
    }

    protected SortedSet<DbEntityOperation> getInsertsForType(Class<? extends DbEntity> type, boolean create) {
        TreeSet<DbEntityOperation> insertsByType = (TreeSet<DbEntityOperation>)this.inserts.get(type);
        if (insertsByType == null && create) {
            insertsByType = new TreeSet<DbEntityOperation>(INSERT_OPERATION_COMPARATOR);
            this.inserts.put(type, insertsByType);
        }
        return insertsByType;
    }

    public boolean addOperation(DbBulkOperation newOperation) {
        TreeSet<DbBulkOperation> bulksByType = (TreeSet<DbBulkOperation>)this.bulkOperations.get(newOperation.getEntityType());
        if (bulksByType == null) {
            bulksByType = new TreeSet<DbBulkOperation>(BULK_OPERATION_COMPARATOR);
            this.bulkOperations.put(newOperation.getEntityType(), bulksByType);
        }
        return bulksByType.add(newOperation);
    }

    public boolean addOperationPreserveOrder(DbBulkOperation newOperation) {
        return this.bulkOperationsInsertionOrder.add(newOperation);
    }

    public List<DbOperation> calculateFlush() {
        ArrayList<DbOperation> flush = new ArrayList<DbOperation>();
        this.addSortedInserts(flush);
        this.addSortedModifications(flush);
        this.determineDependencies(flush);
        return flush;
    }

    protected void addSortedInserts(List<DbOperation> flush) {
        for (Map.Entry<Class<?>, SortedSet<DbEntityOperation>> operationsForType : this.inserts.entrySet()) {
            if (HasDbReferences.class.isAssignableFrom(operationsForType.getKey())) {
                flush.addAll(this.sortByReferences(operationsForType.getValue()));
                continue;
            }
            flush.addAll((Collection<DbOperation>)operationsForType.getValue());
        }
    }

    protected void addSortedModifications(List<DbOperation> flush) {
        TreeSet modifiedEntityTypes = new TreeSet(MODIFICATION_TYPE_COMPARATOR);
        modifiedEntityTypes.addAll(this.updates.keySet());
        modifiedEntityTypes.addAll(this.deletes.keySet());
        modifiedEntityTypes.addAll(this.bulkOperations.keySet());
        for (Class clazz : modifiedEntityTypes) {
            this.addSortedModificationsForType(clazz, (SortedSet)this.updates.get(clazz), flush);
            this.addSortedModificationsForType(clazz, (SortedSet)this.deletes.get(clazz), flush);
            SortedSet bulkOperationsForType = (SortedSet)this.bulkOperations.get(clazz);
            if (bulkOperationsForType == null) continue;
            flush.addAll(bulkOperationsForType);
        }
        if (this.bulkOperationsInsertionOrder != null) {
            flush.addAll(this.bulkOperationsInsertionOrder);
        }
    }

    protected void addSortedModificationsForType(Class<?> type, SortedSet<DbEntityOperation> preSortedOperations, List<DbOperation> flush) {
        if (preSortedOperations != null) {
            if (HasDbReferences.class.isAssignableFrom(type)) {
                flush.addAll(this.sortByReferences(preSortedOperations));
            } else {
                flush.addAll(preSortedOperations);
            }
        }
    }

    protected List<DbEntityOperation> sortByReferences(SortedSet<DbEntityOperation> preSorted) {
        ArrayList<DbEntityOperation> opList = new ArrayList<DbEntityOperation>(preSorted);
        for (int i = 0; i < opList.size(); ++i) {
            DbEntityOperation currentOperation = (DbEntityOperation)opList.get(i);
            DbEntity currentEntity = currentOperation.getEntity();
            Set<String> currentReferences = currentOperation.getFlushRelevantEntityReferences();
            int moveTo = i;
            for (int k = i + 1; k < opList.size(); ++k) {
                DbEntityOperation otherOperation = (DbEntityOperation)opList.get(k);
                DbEntity otherEntity = otherOperation.getEntity();
                Set<String> otherReferences = otherOperation.getFlushRelevantEntityReferences();
                if (currentOperation.getOperationType() == DbOperationType.INSERT) {
                    if (currentReferences == null || !currentReferences.contains(otherEntity.getId())) continue;
                    moveTo = k;
                    break;
                }
                if (otherReferences == null || !otherReferences.contains(currentEntity.getId())) continue;
                moveTo = k;
            }
            if (moveTo <= i) continue;
            opList.remove(i);
            opList.add(moveTo, currentOperation);
            --i;
        }
        return opList;
    }

    protected void determineDependencies(List<DbOperation> flush) {
        TreeSet defaultValue = new TreeSet();
        for (DbOperation operation : flush) {
            Map<String, Class> dependentEntities;
            DbEntity entity;
            if (!(operation instanceof DbEntityOperation) || !((entity = ((DbEntityOperation)operation).getEntity()) instanceof HasDbReferences) || (dependentEntities = ((HasDbReferences)((Object)entity)).getDependentEntities()) == null) continue;
            dependentEntities.forEach((id, type) -> this.deletes.getOrDefault(type, defaultValue).forEach(o -> {
                if (id.equals(o.getEntity().getId())) {
                    o.setDependency(operation);
                }
            }));
        }
    }
}

