/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.BatchStatistics;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchStatisticsQueryAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestBaseRule authRule = new AuthorizationTestBaseRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    protected MigrationPlan migrationPlan;
    protected Batch batch1;
    protected Batch batch2;
    protected Batch batch3;

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("user", "group");
    }

    @Before
    public void deployProcessesAndCreateMigrationPlan() {
        ProcessInstance pi = this.createMigrationPlan();
        this.batch1 = this.engineRule.getRuntimeService().newMigration(this.migrationPlan).processInstanceIds(Arrays.asList(pi.getId())).executeAsync();
        Job seedJob = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        this.engineRule.getManagementService().executeJob(seedJob.getId());
        this.batch2 = this.engineRule.getRuntimeService().newMigration(this.migrationPlan).processInstanceIds(Arrays.asList(pi.getId())).executeAsync();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @After
    public void deleteBatches() {
        this.engineRule.getManagementService().deleteBatch(this.batch1.getId(), true);
        this.engineRule.getManagementService().deleteBatch(this.batch2.getId(), true);
        if (this.batch3 != null) {
            this.engineRule.getManagementService().deleteBatch(this.batch3.getId(), true);
        }
    }

    @Test
    public void testQueryList() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, this.batch1.getId(), "user", new Permission[]{Permissions.READ});
        this.authRule.enableAuthorization("user");
        List batches = this.engineRule.getManagementService().createBatchStatisticsQuery().list();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertEquals((Object)this.batch1.getId(), (Object)((BatchStatistics)batches.get(0)).getId());
        Assert.assertEquals((long)1L, (long)((BatchStatistics)batches.get(0)).getJobsCreated());
        Assert.assertEquals((long)1L, (long)((BatchStatistics)batches.get(0)).getRemainingJobs());
        Assert.assertEquals((long)1L, (long)((BatchStatistics)batches.get(0)).getTotalJobs());
    }

    @Test
    public void testQueryCount() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, this.batch1.getId(), "user", new Permission[]{Permissions.READ});
        this.authRule.enableAuthorization("user");
        long count = this.engineRule.getManagementService().createBatchStatisticsQuery().count();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testQueryNoAuthorizations() {
        this.authRule.enableAuthorization("user");
        long count = this.engineRule.getManagementService().createBatchStatisticsQuery().count();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testQueryListAccessAll() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, "*", "user", new Permission[]{Permissions.READ});
        this.authRule.enableAuthorization("user");
        List batches = this.engineRule.getManagementService().createBatchStatisticsQuery().list();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)2L, (long)batches.size());
    }

    @Test
    public void testQueryListMultiple() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, "*", "user", new Permission[]{Permissions.READ});
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, this.batch1.getId(), "user", new Permission[]{Permissions.READ});
        this.authRule.enableAuthorization("user");
        List batches = this.engineRule.getManagementService().createBatchStatisticsQuery().list();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)2L, (long)batches.size());
    }

    @Test
    public void testBatchStatisticsAndCreateUserId() {
        ProcessInstance pi = this.createMigrationPlan();
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE});
        this.authRule.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE});
        this.authRule.enableAuthorization("userId");
        this.batch3 = this.engineRule.getRuntimeService().newMigration(this.migrationPlan).processInstanceIds(Arrays.asList(pi.getId())).executeAsync();
        this.authRule.disableAuthorization();
        BatchStatistics batchStatistics = (BatchStatistics)this.engineRule.getManagementService().createBatchStatisticsQuery().batchId(this.batch3.getId()).singleResult();
        Assert.assertEquals((Object)"userId", (Object)batchStatistics.getCreateUserId());
    }

    @Test
    public void shouldNotFindStatisticsWithRevokedReadPermissionOnBatch() {
        this.authRule.createGrantAuthorization((Resource)Resources.BATCH, "*", "*", new Permission[]{Permissions.READ});
        this.authRule.createRevokeAuthorization((Resource)Resources.BATCH, "*", "user", new Permission[]{Permissions.READ});
        this.authRule.enableAuthorization("user");
        List batches = this.engineRule.getManagementService().createBatchStatisticsQuery().list();
        this.authRule.disableAuthorization();
        Assert.assertEquals((long)0L, (long)batches.size());
    }

    protected ProcessInstance createMigrationPlan() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance pi = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        return pi;
    }
}

