/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch.creation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.api.authorization.batch.creation.BatchCreationAuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class SetJobRetriesBatchAuthorizationTest
extends BatchCreationAuthorizationTest {
    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_SET_JOB_RETRIES})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_SET_JOB_RETRIES})).succeeds());
    }

    @Test
    public void testBatchSetJobRetriesByJobs() {
        List<String> jobIds = this.setupFailedJobs();
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        this.managementService.setJobRetriesAsync(jobIds, 5);
        this.authRule.assertScenario(this.scenario);
    }

    @Test
    public void testBatchSetJobRetriesByProcesses() {
        this.setupFailedJobs();
        List<String> processInstanceIds = Collections.singletonList(this.processInstance.getId());
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        this.managementService.setJobRetriesAsync(processInstanceIds, (ProcessInstanceQuery)null, 5);
        this.authRule.assertScenario(this.scenario);
    }

    protected List<String> setupFailedJobs() {
        ArrayList<String> jobIds = new ArrayList<String>();
        DeploymentWithDefinitions deploy = this.testHelper.deploy("org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml");
        ProcessDefinition sourceDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deploy.getId()).singleResult();
        this.processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        List jobs = this.managementService.createJobQuery().processInstanceId(this.processInstance.getId()).list();
        for (Job job : jobs) {
            jobIds.add(job.getId());
        }
        return jobIds;
    }
}

