/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class ExternalTaskQueryByCreateTimeTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected ProcessEngine engine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected CaseService caseService;

    @Before
    public void setup() {
        this.engine = this.engineRule.getProcessEngine();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.caseService = this.engineRule.getCaseService();
        this.deployProcessesWithExternalTasks();
    }

    @After
    public void tearDown() {
        ClockUtil.reset();
    }

    @Test
    public void shouldHaveNonNullCreateTime() {
        this.runtimeService.startProcessInstanceByKey("process1");
        List result = this.engineRule.getExternalTaskService().createExternalTaskQuery().list();
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((Date)((ExternalTask)result.get(0)).getCreateTime()).isNotNull();
    }

    @Test
    public void shouldProduceEventWithCreateTimeValue() {
        this.runtimeService.startProcessInstanceByKey("process1");
        ExternalTask extTask = (ExternalTask)this.engineRule.getExternalTaskService().createExternalTaskQuery().singleResult();
        List result = this.historyService.createHistoricExternalTaskLogQuery().list();
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        Date historyEventTimestamp = ((HistoricExternalTaskLog)result.get(0)).getTimestamp();
        Assertions.assertThat((Date)extTask.getCreateTime()).isEqualTo((Object)historyEventTimestamp);
    }

    @Test
    public void shouldReturnTasksInDescOrder() {
        this.startProcessInstanceAfter("process1", 1L);
        this.startProcessInstanceAfter("process2", 1L);
        List result = ((ExternalTaskQuery)this.engineRule.getExternalTaskService().createExternalTaskQuery().orderByCreateTime().desc()).list();
        Assertions.assertThat((int)result.size()).isEqualTo(2);
        ExternalTask extTask1 = (ExternalTask)result.get(0);
        ExternalTask extTask2 = (ExternalTask)result.get(1);
        Assertions.assertThat((Date)extTask2.getCreateTime()).isBefore(extTask1.getCreateTime());
    }

    @Test
    public void shouldReturnTasksInAscOrder() {
        this.startProcessInstanceAfter("process1", 1L);
        this.startProcessInstanceAfter("process2", 1L);
        List result = ((ExternalTaskQuery)this.engineRule.getExternalTaskService().createExternalTaskQuery().orderByCreateTime().asc()).list();
        Assertions.assertThat((int)result.size()).isEqualTo(2);
        ExternalTask extTask1 = (ExternalTask)result.get(0);
        ExternalTask extTask2 = (ExternalTask)result.get(1);
        Assertions.assertThat((Date)extTask1.getCreateTime()).isBefore(extTask2.getCreateTime());
    }

    @Test
    public void shouldReturnTasksInCreateTimeAscOrderOnPriorityEquality() {
        this.startProcessInstanceAfter("process1", 1L);
        this.startProcessInstanceAfter("process2", 1L);
        this.startProcessInstanceAfter("process3", 1L);
        this.startProcessInstanceAfter("process4", 1L);
        List result = ((ExternalTaskQuery)((ExternalTaskQuery)this.engineRule.getExternalTaskService().createExternalTaskQuery().orderByPriority().desc()).orderByCreateTime().asc()).list();
        Assertions.assertThat((int)result.size()).isEqualTo(4);
        Assertions.assertThat((String)((ExternalTask)result.get(0)).getActivityId()).isEqualTo((Object)"task1");
        Assertions.assertThat((String)((ExternalTask)result.get(1)).getActivityId()).isEqualTo((Object)"task2");
        Assertions.assertThat((String)((ExternalTask)result.get(2)).getActivityId()).isEqualTo((Object)"task3");
        Assertions.assertThat((String)((ExternalTask)result.get(3)).getActivityId()).isEqualTo((Object)"task4");
    }

    @Test
    public void shouldReturnTasksInCreateTimeDescOrderOnPriorityEquality() {
        this.startProcessInstanceAfter("process1", 1L);
        this.startProcessInstanceAfter("process2", 1L);
        this.startProcessInstanceAfter("process3", 1L);
        this.startProcessInstanceAfter("process4", 1L);
        List result = ((ExternalTaskQuery)((ExternalTaskQuery)this.engineRule.getExternalTaskService().createExternalTaskQuery().orderByPriority().desc()).orderByCreateTime().desc()).list();
        Assertions.assertThat((int)result.size()).isEqualTo(4);
        Assertions.assertThat((String)((ExternalTask)result.get(0)).getActivityId()).isEqualTo((Object)"task1");
        Assertions.assertThat((String)((ExternalTask)result.get(1)).getActivityId()).isEqualTo((Object)"task2");
        Assertions.assertThat((String)((ExternalTask)result.get(2)).getActivityId()).isEqualTo((Object)"task4");
        Assertions.assertThat((String)((ExternalTask)result.get(3)).getActivityId()).isEqualTo((Object)"task3");
    }

    @Test
    public void shouldReturnTasksInPriorityAscOnCreateTimeEquality() {
        Date now = ClockTestUtil.setClockToDateWithoutMilliseconds();
        this.startProcessInstanceWithDate("process1", now);
        this.startProcessInstanceWithDate("process2", now);
        this.startProcessInstanceAfter("process3", 1L);
        this.startProcessInstanceAfter("process4", 1L);
        List result = ((ExternalTaskQuery)((ExternalTaskQuery)this.engineRule.getExternalTaskService().createExternalTaskQuery().orderByCreateTime().asc()).orderByPriority().asc()).list();
        Assertions.assertThat((int)result.size()).isEqualTo(4);
        Assertions.assertThat((String)((ExternalTask)result.get(0)).getActivityId()).isEqualTo((Object)"task2");
        Assertions.assertThat((String)((ExternalTask)result.get(1)).getActivityId()).isEqualTo((Object)"task1");
        Assertions.assertThat((String)((ExternalTask)result.get(2)).getActivityId()).isEqualTo((Object)"task3");
        Assertions.assertThat((String)((ExternalTask)result.get(3)).getActivityId()).isEqualTo((Object)"task4");
    }

    @Test
    public void shouldReturnTasksInPriorityDescOnCreateTimeEquality() {
        Date now = ClockTestUtil.setClockToDateWithoutMilliseconds();
        this.startProcessInstanceWithDate("process1", now);
        this.startProcessInstanceWithDate("process2", now);
        this.startProcessInstanceAfter("process3", 1L);
        this.startProcessInstanceAfter("process4", 1L);
        List result = ((ExternalTaskQuery)((ExternalTaskQuery)this.engineRule.getExternalTaskService().createExternalTaskQuery().orderByCreateTime().asc()).orderByPriority().desc()).list();
        Assertions.assertThat((int)result.size()).isEqualTo(4);
        Assertions.assertThat((String)((ExternalTask)result.get(0)).getActivityId()).isEqualTo((Object)"task1");
        Assertions.assertThat((String)((ExternalTask)result.get(1)).getActivityId()).isEqualTo((Object)"task2");
        Assertions.assertThat((String)((ExternalTask)result.get(2)).getActivityId()).isEqualTo((Object)"task3");
        Assertions.assertThat((String)((ExternalTask)result.get(3)).getActivityId()).isEqualTo((Object)"task4");
    }

    private void deployProcessesWithExternalTasks() {
        BpmnModelInstance process1 = this.createProcessWithTask("process1", "task1", "topic1", "4");
        BpmnModelInstance process2 = this.createProcessWithTask("process2", "task2", "topic2", "3");
        BpmnModelInstance process3 = this.createProcessWithTask("process3", "task3", "topic3", "0");
        BpmnModelInstance process4 = this.createProcessWithTask("process4", "task4", "topic4", "0");
        this.testHelper.deploy(process1, process2, process3, process4);
    }

    private void startProcessInstanceWithDate(String processKey, Date fixedDate) {
        ClockUtil.setCurrentTime((Date)fixedDate);
        this.runtimeService.startProcessInstanceByKey(processKey);
    }

    private void startProcessInstanceAfter(String processKey, long minutes) {
        ClockTestUtil.incrementClock(minutes * 60000L);
        this.runtimeService.startProcessInstanceByKey(processKey);
    }

    private BpmnModelInstance createProcessWithTask(String processId, String taskId, String topic, String priority) {
        return ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask(taskId).camundaExternalTask(topic)).camundaTaskPriority(priority)).endEvent().done();
    }
}

