/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="activity")
public class MultiTenancyHistoricProcessInstanceQueryTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().endEvent().done();
        this.testRule.deploy(oneTaskProcess);
        this.testRule.deployForTenant(TENANT_ONE, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_TWO, oneTaskProcess);
        this.startProcessInstance();
        this.startProcessInstanceForTenant(TENANT_ONE);
        this.startProcessInstanceForTenant(TENANT_TWO);
    }

    @Test
    public void shouldQueryNoTenantIdSet() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldQueryByWithoutTenantId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicProcessInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicProcessInstances.size()).isEqualTo(2);
        Assertions.assertThat((String)((HistoricProcessInstance)historicProcessInstances.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((HistoricProcessInstance)historicProcessInstances.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicProcessInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicProcessInstances.size()).isEqualTo(2);
        Assertions.assertThat((String)((HistoricProcessInstance)historicProcessInstances.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((HistoricProcessInstance)historicProcessInstances.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant) {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(tenant).execute();
    }

    protected ProcessInstance startProcessInstance() {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().execute();
    }
}

