/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.resources;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ResourceTypes;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RuntimeByteArrayTest {
    protected static final String WORKER_ID = "aWorkerId";
    protected static final long LOCK_TIME = 10000L;
    protected static final String TOPIC_NAME = "externalTaskTopic";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected RepositoryService repositoryService;
    protected ExternalTaskService externalTaskService;
    protected String id;

    @Before
    public void initServices() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @After
    public void tearDown() {
        if (this.id != null) {
            this.taskService.deleteTask(this.id, true);
        }
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Test
    public void testVariableBinaryForFileValues() {
        BpmnModelInstance instance = this.createProcess();
        this.testRule.deploy(instance);
        FileValue fileValue = this.createFile();
        this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValueTyped("fileVar", (TypedValue)fileValue));
        String byteArrayValueId = ((VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().singleResult()).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayValueId));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testVariableBinary() {
        byte[] binaryContent = "some binary content".getBytes();
        HashMap<String, byte[]> variables = new HashMap<String, byte[]>();
        variables.put("binaryVariable", binaryContent);
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.id = task.getId();
        this.taskService.setVariablesLocal(this.id, variables);
        String byteArrayValueId = ((VariableInstanceEntity)this.runtimeService.createVariableInstanceQuery().singleResult()).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayValueId));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testBatchBinary() {
        this.helper.migrateProcessInstancesAsync(15);
        String byteArrayValueId = ((BatchEntity)this.managementService.createBatchQuery().singleResult()).getConfiguration();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayValueId));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testExceptionStacktraceBinary() {
        BpmnModelInstance instance = this.createFailingProcess();
        this.testRule.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("Process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(job.getExceptionByteArrayId()));
        this.checkBinary(byteArrayEntity);
    }

    @Test
    public void testExternalTaskStacktraceBinary() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        try {
            throw new RuntimeSqlException("test cause");
        }
        catch (RuntimeException e) {
            String exceptionStackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            String errorMessage = e.getMessage();
            Assert.assertNotNull((Object)exceptionStackTrace);
            this.externalTaskService.handleFailure(task.getId(), WORKER_ID, errorMessage, exceptionStackTrace, 5, 3000L);
            ExternalTaskEntity externalTask = (ExternalTaskEntity)this.externalTaskService.createExternalTaskQuery().singleResult();
            ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.configuration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(externalTask.getErrorDetailsByteArrayId()));
            this.checkBinary(byteArrayEntity);
            return;
        }
    }

    protected void checkBinary(ByteArrayEntity byteArrayEntity) {
        Assert.assertNotNull((Object)byteArrayEntity);
        Assert.assertNotNull((Object)byteArrayEntity.getCreateTime());
        Assert.assertEquals((Object)ResourceTypes.RUNTIME.getValue(), (Object)byteArrayEntity.getType());
    }

    protected FileValue createFile() {
        String fileName = "text.txt";
        String encoding = "crazy-encoding";
        String mimeType = "martini/dry";
        FileValue fileValue = (FileValue)Variables.fileValue((String)fileName).file("ABC".getBytes()).encoding(encoding).mimeType(mimeType).create();
        return fileValue;
    }

    protected BpmnModelInstance createProcess() {
        return Bpmn.createExecutableProcess((String)"Process").startEvent().userTask("user").endEvent().done();
    }

    protected BpmnModelInstance createFailingProcess() {
        return ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask("failing").camundaAsyncAfter()).camundaAsyncBefore()).camundaClass(FailingDelegate.class)).endEvent().done();
    }

    protected Date nowPlus(long millis) {
        return new Date(ClockUtil.getCurrentTime().getTime() + millis);
    }
}

