/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SubTaskDataTest {
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void init() {
        this.repositoryService = this.rule.getRepositoryService();
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
    }

    @Test
    @Deployment
    public void testSubTaskData() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subTaskTest");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue");
        Assert.assertEquals((Object)"testValue", (Object)this.runtimeService.getVariable(task.getExecutionId(), "testVariable"));
        Task subTask = this.taskService.newTask("123456789");
        subTask.setParentTaskId(task.getId());
        subTask.setName("Test Subtask");
        this.taskService.saveTask(subTask);
        this.taskService.setVariable(subTask.getId(), "testVariable", (Object)"newTestValue");
        Assert.assertEquals((Object)"newTestValue", (Object)this.runtimeService.getVariable(task.getExecutionId(), "testVariable"));
    }
}

