/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import java.util.Map;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.camunda.bpm.engine.test.bpmn.event.conditional.LoopDelegate;
import org.camunda.bpm.engine.test.bpmn.event.conditional.SetVariableDelegate;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Test;

public class EventSubProcessStartConditionalEventTest
extends AbstractConditionalEventTestCase {
    @Test
    @Deployment
    public void testTrueCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testFalseCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Before Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @Deployment
    public void testVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testVariableCondition.bpmn20.xml"})
    public void testVariableConditionAndStartingWithVar() {
        VariableMap vars = Variables.createVariables();
        vars.put("variable", 1);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testVariableCondition.bpmn20.xml"})
    public void testWrongVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Before Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testNonInterruptingVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment
    public void testSubProcessVariableCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.setVariableLocal(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Before Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnTaskCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnExecutionCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.runtimeService.setVariableLocal(task.getExecutionId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Before Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    protected void deployConditionalEventSubProcess(BpmnModelInstance model, boolean isInterrupting) {
        this.deployConditionalEventSubProcess(model, "conditionalEventProcess", isInterrupting);
    }

    @Override
    protected void deployConditionalEventSubProcess(BpmnModelInstance model, String parentId, boolean isInterrupting) {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(model).addSubProcessTo(parentId).id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent().interrupting(isInterrupting)).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).conditionalEventDefinitionDone().userTask("taskAfterCond").name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }

    @Test
    public void testSetVariableInDelegate() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask().camundaClass(SetVariableDelegate.class.getName())).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingSetVariableInDelegate() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask().camundaClass(SetVariableDelegate.class.getName())).userTask().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInDelegateWithSynchronousEvent() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask().camundaClass(SetVariableDelegate.class.getName())).endEvent().done();
        modelInstance = ((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(true)).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).conditionalEventDefinitionDone().endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)0L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Test
    public void testNonInterruptingSetVariableInDelegateWithSynchronousEvent() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask().camundaClass(SetVariableDelegate.class.getName())).userTask().endEvent().done();
        modelInstance = ((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(false)).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).conditionalEventDefinitionDone().endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInInputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaInputParameter("variable", "1")).camundaExpression("${true}")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterServiceTask", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInInputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaInputParameter("variable", "1")).camundaExpression("${true}")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterServiceTask", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInExpression() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInExpression() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).serviceTask("taskWithCondition").camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInInputMappingOfSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).subProcess("subProcess").camundaInputParameter("variable", "1")).embeddedSubProcess().startEvent("startSubProcess").userTask().name("taskInSubProcess")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInInputMappingOfSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask().name("Before Condition")).subProcess("subProcess").camundaInputParameter("variable", "1")).embeddedSubProcess().startEvent().userTask().name("taskInSubProcess")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInOutputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).camundaOutputParameter("variable", "1")).userTask().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInOutputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).camundaOutputParameter("variable", "1")).userTask().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInOutputMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOutputParameter("variable", "1")).userTask().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInOutputMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOutputParameter("variable", "1")).userTask().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInOutMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOut("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInOutMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOut("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.count());
    }

    @Test
    public void testSetVariableInInMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaIn("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterOutputMapping", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInInMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaIn("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterOutputMapping", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterServiceTask", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).callActivity("taskWithCondition").calledElement("delegatedProcess")).userTask().name("afterServiceTask")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"afterServiceTask", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableInSubProcessInDelegatedCode() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).subProcess("subProcess").embeddedSubProcess().startEvent().serviceTask().camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInSubProcessInDelegatedCode() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).subProcess("subProcess").embeddedSubProcess().startEvent().serviceTask().camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testSetVariableInSubProcessInDelegatedCodeConditionOnPI() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).subProcess("subProcess").embeddedSubProcess().startEvent().serviceTask().camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInSubProcessInDelegatedCodeConditionOnPI() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).subProcess("subProcess").embeddedSubProcess().startEvent().serviceTask().camundaExpression("${execution.setVariable(\"variable\", 1)}")).userTask().name("afterServiceTask")).endEvent().subProcessDone().endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testSubProcessVariableCondition.bpmn20.xml"})
    public void testSubProcessSetVariableOnProcessInstanceCondition() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSuspendedProcess() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        this.runtimeService.suspendProcessInstanceById(procInst.getId());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        Assert.assertTrue((boolean)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).isSuspended());
        try {
            this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
            Assert.fail((String)"Should fail!");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(procInst.getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
    }

    @Test
    public void testNonInterruptingConditionalSuspendedProcess() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        this.runtimeService.suspendProcessInstanceById(procInst.getId());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        Assert.assertTrue((boolean)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).isSuspended());
        try {
            this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
            Assert.fail((String)"Should fail!");
        }
        catch (SuspendedEntityInteractionException suspendedEntityInteractionException) {
            // empty catch block
        }
        this.runtimeService.activateProcessInstanceById(procInst.getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
    }

    @Test
    public void testNonInterruptingSetMultipleVariables() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").name("Task with condition")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Task task = (Task)taskQuery.singleResult();
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"variable", (Object)1);
        variables.put((Object)"variable1", (Object)1);
        this.runtimeService.setVariables(task.getExecutionId(), (Map)variables);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)3L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment
    public void testLoop() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("Task_1").singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((Object)"Task_2", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getTaskDefinitionKey());
        Assert.assertEquals((Object)3, (Object)this.runtimeService.getVariable(processInstance.getId(), "variable"));
    }

    @Test
    public void testTriggerAnotherEventSubprocess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").name("Task with condition")).endEvent().done();
        modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(true)).conditionalEventDefinition().condition("${true}")).conditionalEventDefinitionDone().userTask("afterConditionId1").name("After Condition1")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"After Condition1", (Object)task.getName());
        this.runtimeService.setVariable(processInstance.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((Object)"After Condition1", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingTriggerAnotherEventSubprocess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").name("Task with condition")).endEvent().done();
        modelInstance = ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalEventProcess").id("eventSubProcess1")).triggerByEvent()).embeddedSubProcess().startEvent().interrupting(false)).conditionalEventDefinition().condition("${true}")).conditionalEventDefinitionDone().userTask("taskAfterCond1").name("After Condition1")).endEvent().done();
        this.deployConditionalEventSubProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Task task = (Task)taskQuery.taskName("After Condition1").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.setVariable(processInstance.getId(), "variable", (Object)1);
        task = (Task)this.taskService.createTaskQuery().taskName("After Condition").singleResult();
        Assert.assertNotNull((Object)task);
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)4L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment
    public void testNonInterruptingSetMultipleVariableInDelegate() {
        this.runtimeService.startProcessInstanceByKey("process");
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)5L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().taskDefinitionKey("Task_3").count());
    }

    @Test
    public void testSetVariableInTriggeredEventSubProcess() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").name("Task with condition")).serviceTask().camundaClass(SetVariableDelegate.class.getName())).endEvent().done();
        modelInstance = ((UserTaskBuilder)((ServiceTaskBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(true)).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).conditionalEventDefinitionDone().serviceTask().camundaClass(LoopDelegate.class.getName())).userTask().name("After Condition")).endEvent().done();
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"Task with condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/conditional/EventSubProcessStartConditionalEventTest.testVariableCondition.bpmn20.xml"})
    public void testVariableConditionWithHistory() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)Variables.createVariables().putValue("variable", (Object)1).putValue("donotloseme", (Object)"here"));
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("variable").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("donotloseme").count());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment
    public void testNonInterruptingVariableConditionWithHistory() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)Variables.createVariables().putValue("variable", (Object)1).putValue("donotloseme", (Object)"here"));
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().processInstanceId(procInst.getId()).list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("variable").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("donotloseme").count());
    }
}

