/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.escalation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EscalationEventParseInvalidProcessTest {
    private static final String PROCESS_DEFINITION_DIRECTORY = "org/camunda/bpm/engine/test/bpmn/event/escalation/";
    @Parameterized.Parameter(value=0)
    public String processDefinitionResource;
    @Parameterized.Parameter(value=1)
    public String expectedErrorMessage;
    @Parameterized.Parameter(value=2)
    public String[] bpmnElementIds;
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected RepositoryService repositoryService;

    @Parameterized.Parameters(name="{index}: process definition = {0}, expected error message = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"EscalationEventParseInvalidProcessTest.missingIdOnEscalation.bpmn20.xml", "escalation must have an id", new String[0]}, {"EscalationEventParseInvalidProcessTest.invalidAttachement.bpmn20.xml", "An escalation boundary event should only be attached to a subprocess, a call activity or an user task", new String[]{"escalationBoundaryEvent"}}, {"EscalationEventParseInvalidProcessTest.invalidEscalationRefOnBoundaryEvent.bpmn20.xml", "could not find escalation with id 'invalid-escalation'", new String[]{"escalationBoundaryEvent"}}, {"EscalationEventParseInvalidProcessTest.multipleEscalationBoundaryEventsWithSameEscalationCode.bpmn20.xml", "multiple escalation boundary events with the same escalationCode 'escalationCode' are not supported on same scope", new String[]{"escalationBoundaryEvent2"}}, {"EscalationEventParseInvalidProcessTest.multipleEscalationBoundaryEventsWithAndWithoutEscalationCode.bpmn20.xml", "The same scope can not contains an escalation boundary event without escalation code and another one with escalation code.", new String[]{"escalationBoundaryEvent2"}}, {"EscalationEventParseInvalidProcessTest.multipleEscalationBoundaryEventsWithoutEscalationCode.bpmn20.xml", "The same scope can not contains more than one escalation boundary event without escalation code.", new String[]{"escalationBoundaryEvent2"}}, {"EscalationEventParseInvalidProcessTest.missingEscalationCodeOnIntermediateThrowingEscalationEvent.bpmn20.xml", "throwing escalation event must have an 'escalationCode'", new String[]{"escalationThrowingEvent"}}, {"EscalationEventParseInvalidProcessTest.missingEscalationRefOnIntermediateThrowingEvent.bpmn20.xml", "escalationEventDefinition does not have required attribute 'escalationRef'", new String[]{"escalationThrowingEvent"}}, {"EscalationEventParseInvalidProcessTest.invalidEscalationRefOnIntermediateThrowingEvent.bpmn20.xml", "could not find escalation with id 'invalid-escalation'", new String[]{"escalationThrowingEvent"}}, {"EscalationEventParseInvalidProcessTest.missingEscalationCodeOnEscalationEndEvent.bpmn20.xml", "escalation end event must have an 'escalationCode'", new String[]{"theEnd"}}, {"EscalationEventParseInvalidProcessTest.missingEscalationRefOnEndEvent.bpmn20.xml", "escalationEventDefinition does not have required attribute 'escalationRef'", new String[]{"theEnd"}}, {"EscalationEventParseInvalidProcessTest.invalidEscalationRefOnEndEvent.bpmn20.xml", "could not find escalation with id 'invalid-escalation'", new String[]{"theEnd"}}, {"EscalationEventParseInvalidProcessTest.invalidEscalationRefOnEscalationEventSubprocess.bpmn20.xml", "could not find escalation with id 'invalid-escalation'", new String[]{"escalationStartEvent"}}, {"EscalationEventParseInvalidProcessTest.multipleInterruptingEscalationEventSubprocesses.bpmn20.xml", "multiple escalation event subprocesses with the same escalationCode 'escalationCode' are not supported on same scope", new String[]{"escalationStartEvent2"}}, {"EscalationEventParseInvalidProcessTest.multipleEscalationEventSubprocessWithSameEscalationCode.bpmn20.xml", "multiple escalation event subprocesses with the same escalationCode 'escalationCode' are not supported on same scope", new String[]{"escalationStartEvent2"}}, {"EscalationEventParseInvalidProcessTest.multipleEscalationEventSubprocessWithAndWithoutEscalationCode.bpmn20.xml", "The same scope can not contains an escalation event subprocess without escalation code and another one with escalation code.", new String[]{"escalationStartEvent2"}}, {"EscalationEventParseInvalidProcessTest.multipleEscalationEventSubprocessWithoutEscalationCode.bpmn20.xml", "The same scope can not contains more than one escalation event subprocess without escalation code.", new String[]{"escalationStartEvent2"}});
    }

    @Before
    public void initServices() {
        this.repositoryService = this.rule.getRepositoryService();
    }

    @Test
    public void testParseInvalidProcessDefinition() {
        try {
            String deploymentId = this.repositoryService.createDeployment().addClasspathResource(PROCESS_DEFINITION_DIRECTORY + this.processDefinitionResource).deploy().getId();
            this.repositoryService.deleteDeployment(deploymentId, true);
            Assert.fail((String)("exception expected: " + this.expectedErrorMessage));
        }
        catch (ParseException e) {
            this.assertExceptionMessageContainsText((Exception)((Object)e), this.expectedErrorMessage);
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            for (int i = 0; i < this.bpmnElementIds.length; ++i) {
                Assertions.assertThat((String)((Problem)errors.get(i)).getMainElementId()).isEqualTo((Object)this.bpmnElementIds[i]);
            }
        }
    }

    public void assertExceptionMessageContainsText(Exception e, String expectedMessage) {
        String actualMessage = e.getMessage();
        if (actualMessage == null || !actualMessage.contains(expectedMessage)) {
            throw new AssertionFailedError("expected presence of [" + expectedMessage + "], but was [" + actualMessage + "]");
        }
    }
}

