/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.form.deployment;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Arrays;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.CamundaFormDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.CamundaFormUtils;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CamundaFormDefinitionDeployerTest {
    protected static final String BPMN_USER_TASK_FORM_REF_DEPLOYMENT = "org/camunda/bpm/engine/test/form/deployment/CamundaFormDefinitionDeployerTest.shouldDeployProcessWithCamundaFormDefinitionBindingDeployment.bpmn";
    protected static final String BPMN_USER_TASK_FORM_REF_LATEST = "org/camunda/bpm/engine/test/form/deployment/CamundaFormDefinitionDeployerTest.shouldDeployProcessWithCamundaFormDefinitionBindingLatest.bpmn";
    protected static final String BPMN_USER_TASK_FORM_REF_VERSION = "org/camunda/bpm/engine/test/form/deployment/CamundaFormDefinitionDeployerTest.shouldDeployProcessWithCamundaFormDefinitionBindingVersion.bpmn";
    protected static final String SIMPLE_FORM = "org/camunda/bpm/engine/test/form/deployment/CamundaFormDefinitionDeployerTest.simple_form.form";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    RepositoryService repositoryService;
    ProcessEngineConfigurationImpl processEngineConfiguration;
    @Parameterized.Parameter(value=0)
    public String bpmnResource;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> params() {
        return Arrays.asList((Object)new String[]{BPMN_USER_TASK_FORM_REF_DEPLOYMENT, BPMN_USER_TASK_FORM_REF_LATEST, BPMN_USER_TASK_FORM_REF_VERSION});
    }

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void shouldDeployProcessWithCamundaFormDefinition() {
        String deploymentId = this.testRule.deploy(this.bpmnResource, SIMPLE_FORM).getId();
        long deploymentCount = this.repositoryService.createDeploymentQuery().count();
        Assertions.assertThat((long)deploymentCount).isEqualTo(1L);
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Assertions.assertThat(definitions).hasSize(1);
        Assertions.assertThat((String)definitions.get(0).getDeploymentId()).isEqualTo((Object)deploymentId);
    }
}

