/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.lang.invoke.CallSite;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricIncidentQueryTest {
    public static String PROCESS_DEFINITION_KEY = "oneFailingServiceTaskProcess";
    public static BpmnModelInstance FAILING_SERVICE_TASK_MODEL = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent("start").serviceTask("task").camundaAsyncBefore()).camundaClass(FailingDelegate.class.getName())).endEvent("end").done();
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testHistoricIncidentQueryCreateEndAfterBefore() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.testHelper.deploy(Bpmn.createExecutableProcess((String)"proc1").startEvent().userTask().endEvent().done());
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("proc1");
        Incident incident2 = this.runtimeService.createIncident("foo", instance2.getId(), "a");
        this.runtimeService.resolveIncident(incident2.getId());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        Assert.assertEquals((long)0L, (long)query.createTimeBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)2L, (long)query.createTimeBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)2L, (long)query.createTimeAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.createTimeAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)2L, (long)query.createTimeBefore(hourFromNow.getTime()).createTimeAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.endTimeBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)1L, (long)query.endTimeBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)query.endTimeAfter(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.endTimeAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)query.endTimeBefore(hourFromNow.getTime()).endTimeAfter(hourAgo.getTime()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByIncidentId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String incidentId = ((HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult()).getId();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().incidentId(incidentId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByInvalidIncidentId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.incidentId("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.incidentId("invalid").count());
        try {
            query.incidentId(null);
            Assert.fail((String)"It was possible to set a null value as incidentId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByIncidentType() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().incidentType("failedJob");
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidIncidentType() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.incidentType("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.incidentType("invalid").count());
        try {
            query.incidentType(null);
            Assert.fail((String)"It was possible to set a null value as incidentType.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByIncidentMessage() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().incidentMessage("exception0");
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidIncidentMessage() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.incidentMessage("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.incidentMessage("invalid").count());
        try {
            query.incidentMessage(null);
            Assert.fail((String)"It was possible to set a null value as incidentMessage.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByIncidentMessageLike() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.incidentMessageLike("exception").list().size());
        Assert.assertEquals((long)1L, (long)query.incidentMessageLike("exception%").list().size());
        Assert.assertEquals((long)1L, (long)query.incidentMessageLike("%xception%").list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByProcessDefinitionId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processDefinitionId(pi.getProcessDefinitionId());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidProcessDefinitionId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.processDefinitionId("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.processDefinitionId("invalid").count());
        try {
            query.processDefinitionId(null);
            Assert.fail((String)"It was possible to set a null value as processDefinitionId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByProcessDefinitionKey() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        this.testHelper.deploy(Bpmn.createExecutableProcess((String)"proc1").startEvent().userTask().endEvent().done());
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("proc1");
        Incident incident2 = this.runtimeService.createIncident("foo", instance2.getId(), "a");
        this.testHelper.deploy(Bpmn.createExecutableProcess((String)"proc2").startEvent().userTask().endEvent().done());
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("proc2");
        Incident incident3 = this.runtimeService.createIncident("foo", instance3.getId(), "b");
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        List incidents = ((HistoricIncidentQuery)query.processDefinitionKeyIn(new String[]{"proc1", "proc2"}).orderByConfiguration().asc()).list();
        Assertions.assertThat((List)incidents).hasSize(2);
        Assertions.assertThat((String)((HistoricIncident)incidents.get(0)).getId()).isEqualTo((Object)incident2.getId());
        Assertions.assertThat((String)((HistoricIncident)incidents.get(1)).getId()).isEqualTo((Object)incident3.getId());
        Assert.assertEquals((long)0L, (long)query.processDefinitionKey("proc").list().size());
        Assert.assertEquals((long)1L, (long)query.processDefinitionKey("proc1").list().size());
        Assert.assertEquals((long)1L, (long)query.processDefinitionKey("proc2").list().size());
    }

    @Test
    public void testQueryByInvalidProcessDefinitionKeys() {
        IncidentQuery incidentQuery = this.runtimeService.createIncidentQuery();
        Assertions.assertThatThrownBy(() -> incidentQuery.processDefinitionKeyIn((String[])null)).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    public void testQueryByOneInvalidProcessDefinitionKey() {
        IncidentQuery incidentQuery = this.runtimeService.createIncidentQuery();
        Assertions.assertThatThrownBy(() -> incidentQuery.processDefinitionKeyIn(new String[]{null})).isInstanceOf(ProcessEngineException.class);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByProcessInstanceId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().processInstanceId(pi.getId());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidProcessInstanceId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.processInstanceId("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.processInstanceId("invalid").count());
        try {
            query.processInstanceId(null);
            Assert.fail((String)"It was possible to set a null value as processInstanceId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByExecutionId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().executionId(pi.getId());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidExecutionId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.executionId("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.executionId("invalid").count());
        try {
            query.executionId(null);
            Assert.fail((String)"It was possible to set a null value as executionId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByActivityId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().activityId("theServiceTask");
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByInvalidActivityId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.activityId("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.activityId("invalid").count());
        try {
            query.activityId(null);
            Assert.fail((String)"It was possible to set a null value as activityId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByFailedActivityId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().failedActivityId("theServiceTask");
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByFailedInvalidActivityId() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.failedActivityId("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.failedActivityId("invalid").count());
        try {
            query.failedActivityId(null);
            Assert.fail((String)"It was possible to set a null value as failedActivityId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByCauseIncidentId() {
        this.startProcessInstance("process");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult()).getId();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstanceId).singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().causeIncidentId(incident.getId());
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidCauseIncidentId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.causeIncidentId("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.causeIncidentId("invalid").count());
        try {
            query.causeIncidentId(null);
            Assert.fail((String)"It was possible to set a null value as causeIncidentId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricIncidentQueryTest.testQueryByCauseIncidentId.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByRootCauseIncidentId() {
        this.startProcessInstance("process");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult()).getId();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstanceId).singleResult();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().rootCauseIncidentId(incident.getId());
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidRootCauseIncidentId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.rootCauseIncidentId("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.rootCauseIncidentId("invalid").count());
        try {
            query.rootCauseIncidentId(null);
            Assert.fail((String)"It was possible to set a null value as rootCauseIncidentId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByConfiguration() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String configuration = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().configuration(configuration);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidConfigurationId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.configuration("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.configuration("invalid").count());
        try {
            query.configuration(null);
            Assert.fail((String)"It was possible to set a null value as configuration.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByHistoryConfiguration() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Integer latestJobLogId = this.historyService.createHistoricJobLogQuery().list().stream().map(hjl -> Integer.parseInt(hjl.getId())).max(Integer::compare).get();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().historyConfiguration(latestJobLogId.toString());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByNotExistingHistoryConfiguration() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().historyConfiguration("-1");
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidHistoryConfigurationId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)0L, (long)query.historyConfiguration("invalid").list().size());
        Assert.assertEquals((long)0L, (long)query.historyConfiguration("invalid").count());
        try {
            query.historyConfiguration(null);
            Assert.fail((String)"It was possible to set a null value as history configuration.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByOpen() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().open();
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidOpen() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        try {
            query.open().open();
            Assert.fail((String)"It was possible to set a the open flag twice.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByResolved() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().resolved();
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidResolved() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        try {
            query.resolved().resolved();
            Assert.fail((String)"It was possible to set a the resolved flag twice.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryByDeleted() {
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().deleted();
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidDeleted() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        try {
            query.deleted().deleted();
            Assert.fail((String)"It was possible to set a the deleted flag twice.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByJobDefinitionId() {
        String processDefinitionId1 = this.testHelper.deployAndGetDefinition(FAILING_SERVICE_TASK_MODEL).getId();
        String processDefinitionId2 = this.testHelper.deployAndGetDefinition(FAILING_SERVICE_TASK_MODEL).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId1);
        this.runtimeService.startProcessInstanceById(processDefinitionId2);
        this.testHelper.executeAvailableJobs();
        String jobDefinitionId1 = ((Job)this.managementService.createJobQuery().processDefinitionId(processDefinitionId1).singleResult()).getJobDefinitionId();
        String jobDefinitionId2 = ((Job)this.managementService.createJobQuery().processDefinitionId(processDefinitionId2).singleResult()).getJobDefinitionId();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().jobDefinitionIdIn(new String[]{jobDefinitionId1, jobDefinitionId2});
        Assert.assertEquals((long)2L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.count());
        query = this.historyService.createHistoricIncidentQuery().jobDefinitionIdIn(new String[]{jobDefinitionId1});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        query = this.historyService.createHistoricIncidentQuery().jobDefinitionIdIn(new String[]{jobDefinitionId2});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByUnknownJobDefinitionId() {
        String processDefinitionId = this.testHelper.deployAndGetDefinition(FAILING_SERVICE_TASK_MODEL).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        this.testHelper.executeAvailableJobs();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().jobDefinitionIdIn(new String[]{"unknown"});
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    public void testQueryByNullJobDefinitionId() {
        try {
            this.historyService.createHistoricIncidentQuery().jobDefinitionIdIn(new String[]{null});
            Assert.fail((String)"Should fail");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"jobDefinitionIds contains null value"});
        }
    }

    @Test
    public void testQueryByNullJobDefinitionIds() {
        try {
            this.historyService.createHistoricIncidentQuery().jobDefinitionIdIn((String[])null);
            Assert.fail((String)"Should fail");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"jobDefinitionIds is null"});
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQueryPaging() {
        this.startProcessInstances(PROCESS_DEFINITION_KEY, 4);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertEquals((long)4L, (long)query.listPage(0, 4).size());
        Assert.assertEquals((long)1L, (long)query.listPage(2, 1).size());
        Assert.assertEquals((long)2L, (long)query.listPage(1, 2).size());
        Assert.assertEquals((long)3L, (long)query.listPage(1, 4).size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQuerySorting() {
        this.startProcessInstances(PROCESS_DEFINITION_KEY, 4);
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCreateTime().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByEndTime().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentType().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByExecutionId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByActivityId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessInstanceId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessDefinitionKey().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessDefinitionId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCauseIncidentId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByRootCauseIncidentId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByConfiguration().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentState().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCreateTime().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByEndTime().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentType().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByExecutionId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByActivityId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessDefinitionKey().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessInstanceId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByProcessDefinitionId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCauseIncidentId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByRootCauseIncidentId().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByConfiguration().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentState().desc()).list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void testQuerySortingByIncidentMessage() {
        this.startProcessInstances(PROCESS_DEFINITION_KEY, 4);
        List ascending = ((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentMessage().asc()).list();
        List descending = ((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByIncidentMessage().desc()).list();
        Assertions.assertThat((List)ascending).extracting("incidentMessage").containsExactly(new Object[]{"exception0", "exception1", "exception2", "exception3"});
        Assertions.assertThat((List)descending).extracting("incidentMessage").containsExactly(new Object[]{"exception3", "exception2", "exception1", "exception0"});
    }

    protected void startProcessInstance(String key) {
        this.startProcessInstances(key, 1);
    }

    protected void startProcessInstances(String key, int numberOfInstances) {
        for (int i = 0; i < numberOfInstances; ++i) {
            Map<String, CallSite> variables = Collections.singletonMap("message", "exception" + i);
            this.runtimeService.startProcessInstanceByKey(key, "" + i, variables);
        }
        this.testHelper.executeAvailableJobs();
    }
}

