/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.HistoricJobLogQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.RootElement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class PartitioningTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected CommandExecutor commandExecutor;
    protected final BpmnModelInstance PROCESS_WITH_USERTASK = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();

    @Before
    public void init() {
        this.commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Test
    public void shouldUpdateHistoricProcessInstance() {
        String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK).getId();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoricProcessInstanceEntity historicProcessInstanceEntity = (HistoricProcessInstanceEntity)PartitioningTest.this.historyService.createHistoricProcessInstanceQuery().singleResult();
                commandContext.getDbEntityManager().delete((DbEntity)historicProcessInstanceEntity);
                return null;
            }
        });
        MatcherAssert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.runtimeService.deleteProcessInstance(processInstanceId, "aDeleteReason");
        MatcherAssert.assertThat((Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()), (Matcher)CoreMatchers.nullValue());
        this.cleanUp(processInstanceId);
    }

    @Test
    public void shouldUpdateHistoricTaskInstance() {
        this.deployAndStartProcess(this.PROCESS_WITH_USERTASK).getId();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoricTaskInstanceEntity historicTaskInstanceEntity = (HistoricTaskInstanceEntity)PartitioningTest.this.historyService.createHistoricTaskInstanceQuery().singleResult();
                commandContext.getDbEntityManager().delete((DbEntity)historicTaskInstanceEntity);
                return null;
            }
        });
        MatcherAssert.assertThat((Object)((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()), (Matcher)CoreMatchers.nullValue());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        MatcherAssert.assertThat((Object)((Task)this.taskService.createTaskQuery().singleResult()), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldUpdateHistoricActivityInstance() {
        final String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK).getId();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByProcessInstanceIds(Collections.singletonList(processInstanceId));
                return null;
            }
        });
        MatcherAssert.assertThat((Object)this.historyService.createHistoricActivityInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        MatcherAssert.assertThat((Object)this.historyService.createHistoricActivityInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void shouldUpdateHistoricIncident() {
        final String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK).getId();
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().singleResult();
        String incidentId = this.engineRule.getRuntimeService().createIncident("foo", execution.getId(), execution.getActivityId(), "bar").getId();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getHistoricIncidentManager().deleteHistoricIncidentsByProcessInstanceIds(Collections.singletonList(processInstanceId));
                return null;
            }
        });
        MatcherAssert.assertThat((Object)this.historyService.createHistoricIncidentQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)this.runtimeService.createIncidentQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        this.runtimeService.resolveIncident(incidentId);
        MatcherAssert.assertThat((Object)this.runtimeService.createIncidentQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)this.historyService.createHistoricIncidentQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void shouldUpdateHistoricBatch() {
        String processInstanceId = this.deployAndStartProcess(this.PROCESS_WITH_USERTASK).getId();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        MatcherAssert.assertThat((Object)this.historyService.createHistoricBatchQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HistoricBatchEntity historicBatchEntity = (HistoricBatchEntity)PartitioningTest.this.historyService.createHistoricBatchQuery().singleResult();
                commandContext.getDbEntityManager().delete((DbEntity)historicBatchEntity);
                return null;
            }
        });
        MatcherAssert.assertThat((Object)this.historyService.createHistoricBatchQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        String seedJobDefinitionId = batch.getSeedJobDefinitionId();
        Job seedJob = (Job)this.managementService.createJobQuery().jobDefinitionId(seedJobDefinitionId).singleResult();
        this.managementService.executeJob(seedJob.getId());
        String batchJobDefinitionId = batch.getBatchJobDefinitionId();
        List batchJobs = this.managementService.createJobQuery().jobDefinitionId(batchJobDefinitionId).list();
        for (Job batchJob : batchJobs) {
            this.managementService.executeJob(batchJob.getId());
        }
        List monitorJobs = this.managementService.createJobQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).list();
        for (Job monitorJob : monitorJobs) {
            this.managementService.executeJob(monitorJob.getId());
        }
        MatcherAssert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)this.managementService.createBatchQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.cleanUp(processInstanceId);
    }

    protected ProcessInstance deployAndStartProcess(BpmnModelInstance bpmnModelInstance) {
        this.testHelper.deploy(bpmnModelInstance);
        String processDefinitionKey = ((RootElement)bpmnModelInstance.getDefinitions().getRootElements().iterator().next()).getId();
        return this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
    }

    protected void cleanUp(final String processInstanceId) {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByProcessInstanceIds(Collections.singletonList(processInstanceId));
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByProcessInstanceIds(Collections.singletonList(processInstanceId), true);
                List historicJobLogs = commandContext.getHistoricJobLogManager().findHistoricJobLogsByQueryCriteria(new HistoricJobLogQueryImpl(), new Page(0, 100));
                for (HistoricJobLog historicJobLog : historicJobLogs) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(historicJobLog.getJobId());
                }
                return null;
            }
        });
    }
}

