/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class AcquirableJobCacheTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ManagementService managementService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;

    @Before
    public void setup() {
        this.managementService = this.engineRule.getManagementService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    public void testFetchJobEntityWhenAcquirableJobIsCached() {
        this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        try {
            this.fetchJobAfterCachedAcquirableJob();
            Assert.fail((String)"expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(ProcessEngineException.class);
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Could not lookup entity of type"}).contains(new CharSequence[]{AcquirableJobEntity.class.getSimpleName()}).contains(new CharSequence[]{JobEntity.class.getSimpleName()});
        }
    }

    @Test
    public void testFetchTimerEntityWhenAcquirableJobIsCached() {
        BpmnModelInstance process = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"startTimer").startEvent().userTask("userTask").boundaryEvent().timerWithDate("2016-02-11T12:13:14Z")).done();
        this.testRule.deploy(process);
        this.runtimeService.startProcessInstanceByKey("startTimer");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        try {
            this.fetchTimerJobAfterCachedAcquirableJob(execution.getId());
            Assert.fail((String)"expected exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(ProcessEngineException.class);
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Could not lookup entity of type"}).contains(new CharSequence[]{TimerEntity.class.getSimpleName()}).contains(new CharSequence[]{AcquirableJobEntity.class.getSimpleName()});
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/metrics/asyncServiceTaskProcess.bpmn20.xml"})
    public void testFetchAcquirableJobWhenJobEntityIsCached() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncServiceTaskProcess");
        AcquirableJobEntity job = this.fetchAcquirableJobAfterCachedJob(processInstance.getId());
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat((String)job.getProcessInstanceId()).isEqualTo((Object)processInstance.getId());
    }

    @Test
    public void testFetchAcquirableJobWhenTimerEntityIsCached() {
        BpmnModelInstance process = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"timer").startEvent().userTask("userTask").boundaryEvent().timerWithDate("2016-02-11T12:13:14Z")).done();
        this.testRule.deploy(process);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("timer");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        AcquirableJobEntity job = this.fetchAcquirableJobAfterCachedTimerEntity(execution.getId());
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat((String)job.getProcessInstanceId()).isEqualTo((Object)processInstance.getId());
    }

    protected JobEntity fetchJobAfterCachedAcquirableJob() {
        return (JobEntity)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<JobEntity>(){

            public JobEntity execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                List acquirableJobs = jobManager.findNextJobsToExecute(new Page(0, 100));
                JobEntity job = jobManager.findJobById(((AcquirableJobEntity)acquirableJobs.get(0)).getId());
                return job;
            }
        });
    }

    protected TimerEntity fetchTimerJobAfterCachedAcquirableJob(final String executionId) {
        return (TimerEntity)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<TimerEntity>(){

            public TimerEntity execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                jobManager.findNextJobsToExecute(new Page(0, 100));
                List timerJobs = jobManager.findTimersByExecutionId(executionId);
                return (TimerEntity)timerJobs.get(0);
            }
        });
    }

    protected AcquirableJobEntity fetchAcquirableJobAfterCachedTimerEntity(final String executionId) {
        return (AcquirableJobEntity)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<AcquirableJobEntity>(){

            public AcquirableJobEntity execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                jobManager.findTimersByExecutionId(executionId);
                List acquirableJob = jobManager.findNextJobsToExecute(new Page(0, 100));
                return (AcquirableJobEntity)acquirableJob.get(0);
            }
        });
    }

    protected AcquirableJobEntity fetchAcquirableJobAfterCachedJob(final String processInstanceId) {
        return (AcquirableJobEntity)this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<AcquirableJobEntity>(){

            public AcquirableJobEntity execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                jobManager.findJobsByProcessInstanceId(processInstanceId);
                List acquirableJobs = jobManager.findNextJobsToExecute(new Page(0, 100));
                return (AcquirableJobEntity)acquirableJobs.get(0);
            }
        });
    }
}

