/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.pvm;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.test.standalone.pvm.activities.WaitState;
import org.junit.Assert;
import org.junit.Test;

public class PvmVariablesTest {
    @Test
    public void testVariables() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("a").initial().behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.setVariable("amount", (Object)500L);
        processInstance.setVariable("msg", (Object)"hello world");
        processInstance.start();
        Assert.assertEquals((Object)500L, (Object)processInstance.getVariable("amount"));
        Assert.assertEquals((Object)"hello world", (Object)processInstance.getVariable("msg"));
        PvmExecution activityInstance = processInstance.findExecution("a");
        Assert.assertEquals((Object)500L, (Object)activityInstance.getVariable("amount"));
        Assert.assertEquals((Object)"hello world", (Object)activityInstance.getVariable("msg"));
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("amount", 500L);
        expectedVariables.put("msg", "hello world");
        Assert.assertEquals(expectedVariables, (Object)activityInstance.getVariables());
        Assert.assertEquals(expectedVariables, (Object)processInstance.getVariables());
    }
}

