/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.application.ProcessApplicationExecutionException;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RedeploymentProcessApplicationTest {
    protected static final String DEPLOYMENT_NAME = "my-deployment";
    protected static final String BPMN_RESOURCE_1 = "org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml";
    protected static final String BPMN_RESOURCE_2 = "org/camunda/bpm/engine/test/api/repository/processTwo.bpmn20.xml";
    protected static final String CMMN_RESOURCE_1 = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String CMMN_RESOURCE_2 = "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn";
    protected static final String DMN_RESOURCE_1 = "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDmnDeployment.dmn11.xml";
    protected static final String DMN_RESOURCE_2 = "org/camunda/bpm/engine/test/dmn/deployment/dmnScore.dmn11.xml";
    protected static final String DRD_RESOURCE_1 = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String DRD_RESOURCE_2 = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected static RepositoryService repositoryService;
    protected static RuntimeService runtimeService;
    protected static CaseService caseService;
    protected static DecisionService decisionService;
    protected static ManagementService managementService;
    @Parameterized.Parameter(value=0)
    public String resource1;
    @Parameterized.Parameter(value=1)
    public String resource2;
    @Parameterized.Parameter(value=2)
    public String definitionKey1;
    @Parameterized.Parameter(value=3)
    public String definitionKey2;
    @Parameterized.Parameter(value=4)
    public TestProvider testProvider;
    public boolean enforceHistoryTimeToLive;
    public final List<Deployment> deploymentsToCleanup = new ArrayList<Deployment>();

    @Parameterized.Parameters(name="scenario {index}")
    public static Collection<Object[]> scenarios() {
        return Arrays.asList({BPMN_RESOURCE_1, BPMN_RESOURCE_2, "processOne", "processTwo", RedeploymentProcessApplicationTest.processDefinitionTestProvider()}, {CMMN_RESOURCE_1, CMMN_RESOURCE_2, "oneTaskCase", "twoTaskCase", RedeploymentProcessApplicationTest.caseDefinitionTestProvider()}, {DMN_RESOURCE_1, DMN_RESOURCE_2, "decision", "score-decision", RedeploymentProcessApplicationTest.decisionDefinitionTestProvider()}, {DRD_RESOURCE_1, DRD_RESOURCE_2, "score", "dish", RedeploymentProcessApplicationTest.decisionRequirementsDefinitionTestProvider()});
    }

    @Before
    public void init() throws Exception {
        repositoryService = this.engineRule.getRepositoryService();
        runtimeService = this.engineRule.getRuntimeService();
        caseService = this.engineRule.getCaseService();
        decisionService = this.engineRule.getDecisionService();
        managementService = this.engineRule.getManagementService();
        this.enforceHistoryTimeToLive = this.engineRule.getProcessEngineConfiguration().isEnforceHistoryTimeToLive();
    }

    @After
    public void tearDown() {
        this.engineRule.getProcessEngineConfiguration().setEnforceHistoryTimeToLive(this.enforceHistoryTimeToLive);
        if (!this.deploymentsToCleanup.isEmpty()) {
            this.deleteDeployments(this.deploymentsToCleanup);
        }
    }

    @Test
    public void definitionOnePreviousDeploymentWithPA() {
        MyEmbeddedProcessApplication application = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = repositoryService.createDeployment(application.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Deployment deployment2 = repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Assert.assertEquals((long)2L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey1));
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey1);
        Assert.assertTrue((boolean)application.isCalled());
        this.deploymentsToCleanup.addAll(Arrays.asList(deployment1, deployment2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void redeploymentShouldFailOnNullHTTLAndEnforceHistoryTimeToLiveTrue() {
        block9: {
            Deployment deployment2;
            block8: {
                ProcessApplicationDeployment deployment1 = null;
                deployment2 = null;
                try {
                    MyEmbeddedProcessApplication application = new MyEmbeddedProcessApplication();
                    this.engineRule.getProcessEngineConfiguration().setEnforceHistoryTimeToLive(false);
                    deployment1 = repositoryService.createDeployment(application.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
                    this.engineRule.getProcessEngineConfiguration().setEnforceHistoryTimeToLive(true);
                    deployment2 = repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
                    Assert.fail((String)"The second deployment should have thrown an exception due to mandatory enforcement of historyTimeToLive");
                    if (deployment1 == null) break block8;
                    this.deploymentsToCleanup.add((Deployment)deployment1);
                }
                catch (Exception e) {
                    ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).withFailMessage("Deployment2 should throw ProcessEngineException due to mandatory historyTimeToLive", new Object[0])).isInstanceOf(ProcessEngineException.class);
                    break block9;
                }
                finally {
                    if (deployment1 != null) {
                        this.deploymentsToCleanup.add((Deployment)deployment1);
                    }
                    if (deployment2 != null) {
                        this.deploymentsToCleanup.add(deployment2);
                    }
                }
            }
            if (deployment2 != null) {
                this.deploymentsToCleanup.add(deployment2);
            }
        }
    }

    @Test
    public void definitionTwoPreviousDeploymentWithPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Deployment deployment3 = repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Assert.assertEquals((long)3L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey1));
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey1);
        Assert.assertFalse((boolean)application1.isCalled());
        Assert.assertTrue((boolean)application2.isCalled());
        this.deploymentsToCleanup.addAll(Arrays.asList(deployment1, deployment2, deployment3));
    }

    @Test
    public void definitionTwoPreviousDeploymentFirstDeploymentWithPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Deployment deployment2 = repositoryService.createDeployment().name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Deployment deployment3 = repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Assert.assertEquals((long)3L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey1));
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey1);
        Assert.assertTrue((boolean)application1.isCalled());
        this.deploymentsToCleanup.addAll(Arrays.asList(deployment1, deployment2, deployment3));
    }

    @Test
    public void definitionTwoPreviousDeploymentDeleteSecondDeployment() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Deployment deployment3 = repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Assert.assertEquals((long)3L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey1));
        this.deleteDeployments(new Deployment[]{deployment2});
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey1);
        Assert.assertTrue((boolean)application1.isCalled());
        Assert.assertFalse((boolean)application2.isCalled());
        this.deploymentsToCleanup.addAll(Arrays.asList(deployment1, deployment3));
    }

    @Test
    public void definitionTwoPreviousDeploymentUnregisterSecondPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Deployment deployment3 = repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Assert.assertEquals((long)3L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey1));
        managementService.unregisterProcessApplication(deployment2.getId(), true);
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey1);
        Assert.assertTrue((boolean)application1.isCalled());
        Assert.assertFalse((boolean)application2.isCalled());
        this.deploymentsToCleanup.addAll(Arrays.asList(deployment1, deployment2, deployment3));
    }

    @Test
    public void definitionTwoDifferentPreviousDeploymentsWithDifferentPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = repositoryService.createDeployment(application1.getReference()).name("my-deployment-1").addClasspathResource(this.resource1).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = repositoryService.createDeployment(application2.getReference()).name("my-deployment-2").addClasspathResource(this.resource2).deploy();
        Deployment deployment3 = repositoryService.createDeployment().name("my-deployment-3").addDeploymentResources(deployment1.getId()).addDeploymentResources(deployment2.getId()).deploy();
        Assert.assertEquals((long)2L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey1));
        Assert.assertEquals((long)2L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey2));
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey1);
        Assert.assertTrue((boolean)application1.isCalled());
        Assert.assertFalse((boolean)application2.isCalled());
        application1.setCalled(false);
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey2);
        Assert.assertFalse((boolean)application1.isCalled());
        Assert.assertTrue((boolean)application2.isCalled());
        this.deploymentsToCleanup.addAll(Arrays.asList(deployment1, deployment2, deployment3));
    }

    @Test
    public void definitionTwoPreviousDeploymentsWithDifferentPA() {
        MyEmbeddedProcessApplication application1 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment1 = repositoryService.createDeployment(application1.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).addClasspathResource(this.resource2).deploy();
        MyEmbeddedProcessApplication application2 = new MyEmbeddedProcessApplication();
        ProcessApplicationDeployment deployment2 = repositoryService.createDeployment(application2.getReference()).name(DEPLOYMENT_NAME).addClasspathResource(this.resource1).deploy();
        Deployment deployment3 = repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        Assert.assertEquals((long)3L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey1));
        Assert.assertEquals((long)2L, (long)this.testProvider.countDefinitionsByKey(this.definitionKey2));
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey1);
        Assert.assertFalse((boolean)application1.isCalled());
        Assert.assertTrue((boolean)application2.isCalled());
        application2.setCalled(false);
        this.testProvider.createInstanceByDefinitionKey(this.definitionKey2);
        Assert.assertTrue((boolean)application1.isCalled());
        Assert.assertFalse((boolean)application2.isCalled());
        this.deploymentsToCleanup.addAll(Arrays.asList(deployment1, deployment2, deployment3));
    }

    protected void deleteDeployments(List<Deployment> deployments) {
        Deployment[] array = new Deployment[deployments.size()];
        array = deployments.toArray(array);
        this.deleteDeployments(array);
    }

    protected void deleteDeployments(Deployment ... deployments) {
        for (Deployment deployment : deployments) {
            repositoryService.deleteDeployment(deployment.getId(), true);
            managementService.unregisterProcessApplication(deployment.getId(), false);
        }
    }

    protected static TestProvider processDefinitionTestProvider() {
        return new TestProvider(){

            @Override
            public long countDefinitionsByKey(String definitionKey) {
                return repositoryService.createProcessDefinitionQuery().processDefinitionKey(definitionKey).count();
            }

            @Override
            public void createInstanceByDefinitionKey(String definitionKey) {
                runtimeService.startProcessInstanceByKey(definitionKey, (Map)Variables.createVariables().putValue("a", (Object)1).putValue("b", (Object)1));
            }
        };
    }

    protected static TestProvider caseDefinitionTestProvider() {
        return new TestProvider(){

            @Override
            public long countDefinitionsByKey(String definitionKey) {
                return repositoryService.createCaseDefinitionQuery().caseDefinitionKey(definitionKey).count();
            }

            @Override
            public void createInstanceByDefinitionKey(String definitionKey) {
                caseService.createCaseInstanceByKey(definitionKey);
            }
        };
    }

    protected static TestProvider decisionDefinitionTestProvider() {
        return new TestProvider(){

            @Override
            public long countDefinitionsByKey(String definitionKey) {
                return repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(definitionKey).count();
            }

            @Override
            public void createInstanceByDefinitionKey(String definitionKey) {
                decisionService.evaluateDecisionTableByKey(definitionKey).variables((Map)Variables.createVariables().putValue("input", (Object)"john")).evaluate();
            }
        };
    }

    protected static TestProvider decisionRequirementsDefinitionTestProvider() {
        return new TestProvider(){

            @Override
            public long countDefinitionsByKey(String definitionKey) {
                return repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(definitionKey).count();
            }

            @Override
            public void createInstanceByDefinitionKey(String definitionKey) {
                decisionService.evaluateDecisionTableByKey(definitionKey + "-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend").putValue("input", (Object)"John")).evaluate();
            }
        };
    }

    protected static interface TestProvider {
        public long countDefinitionsByKey(String var1);

        public void createInstanceByDefinitionKey(String var1);
    }

    public class MyEmbeddedProcessApplication
    extends EmbeddedProcessApplication {
        protected ProcessApplicationReference reference;
        protected boolean called;

        public ProcessApplicationReference getReference() {
            if (this.reference == null) {
                this.reference = super.getReference();
            }
            return this.reference;
        }

        public <T> T execute(Callable<T> callable) throws ProcessApplicationExecutionException {
            this.called = true;
            return (T)super.execute(callable);
        }

        public boolean isCalled() {
            return this.called;
        }

        public void setCalled(boolean called) {
            this.called = called;
        }
    }
}

