/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.deployment.parser;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.impl.metadata.ProcessesXmlParser;
import org.camunda.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.camunda.bpm.application.impl.metadata.spi.ProcessesXml;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.camunda.bpm.engine.ProcessEngineException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessesXmlParserTest {
    private ProcessesXmlParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new ProcessesXmlParser();
    }

    protected URL getStreamUrl(String filename) {
        return ProcessesXmlParserTest.class.getResource(filename);
    }

    @Test
    public void testParseProcessesXmlOneEngine() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_one_engine.xml")).execute().getProcessesXml();
        Assert.assertNotNull((Object)processesXml);
        Assert.assertEquals((long)1L, (long)processesXml.getProcessEngines().size());
        Assert.assertEquals((long)0L, (long)processesXml.getProcessArchives().size());
        ProcessEngineXml engineXml = (ProcessEngineXml)processesXml.getProcessEngines().get(0);
        Assert.assertEquals((Object)"default", (Object)engineXml.getName());
        Assert.assertEquals((Object)"default", (Object)engineXml.getJobAcquisitionName());
        Assert.assertEquals((Object)"configuration", (Object)engineXml.getConfigurationClass());
        Assert.assertEquals((Object)"datasource", (Object)engineXml.getDatasource());
        Map properties = engineXml.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((long)2L, (long)properties.size());
        Assert.assertEquals((Object)"value1", properties.get("prop1"));
        Assert.assertEquals((Object)"value2", properties.get("prop2"));
    }

    @Test
    public void testParseProcessesXmlTwoEngines() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_two_engines.xml")).execute().getProcessesXml();
        Assert.assertNotNull((Object)processesXml);
        Assert.assertEquals((long)2L, (long)processesXml.getProcessEngines().size());
        Assert.assertEquals((long)0L, (long)processesXml.getProcessArchives().size());
        ProcessEngineXml engineXml1 = (ProcessEngineXml)processesXml.getProcessEngines().get(0);
        Assert.assertEquals((Object)"engine1", (Object)engineXml1.getName());
        Assert.assertEquals((Object)"configuration", (Object)engineXml1.getConfigurationClass());
        Assert.assertEquals((Object)"datasource", (Object)engineXml1.getDatasource());
        Map properties1 = engineXml1.getProperties();
        Assert.assertNotNull((Object)properties1);
        Assert.assertEquals((long)2L, (long)properties1.size());
        Assert.assertEquals((Object)"value1", properties1.get("prop1"));
        Assert.assertEquals((Object)"value2", properties1.get("prop2"));
        ProcessEngineXml engineXml2 = (ProcessEngineXml)processesXml.getProcessEngines().get(1);
        Assert.assertEquals((Object)"engine2", (Object)engineXml2.getName());
        Assert.assertEquals((Object)"configuration", (Object)engineXml2.getConfigurationClass());
        Assert.assertEquals((Object)"datasource", (Object)engineXml2.getDatasource());
        Map properties2 = engineXml2.getProperties();
        Assert.assertNotNull((Object)properties2);
        Assert.assertEquals((long)0L, (long)properties2.size());
    }

    @Test
    public void testParseProcessesXmlOneArchive() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_one_archive.xml")).execute().getProcessesXml();
        Assert.assertNotNull((Object)processesXml);
        Assert.assertEquals((long)0L, (long)processesXml.getProcessEngines().size());
        Assert.assertEquals((long)1L, (long)processesXml.getProcessArchives().size());
        ProcessArchiveXml archiveXml1 = (ProcessArchiveXml)processesXml.getProcessArchives().get(0);
        Assert.assertEquals((Object)"pa1", (Object)archiveXml1.getName());
        Assert.assertEquals((Object)"default", (Object)archiveXml1.getProcessEngineName());
        List resourceNames = archiveXml1.getProcessResourceNames();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertEquals((Object)"process1.bpmn", resourceNames.get(0));
        Assert.assertEquals((Object)"process2.bpmn", resourceNames.get(1));
        Map properties1 = archiveXml1.getProperties();
        Assert.assertNotNull((Object)properties1);
        Assert.assertEquals((long)2L, (long)properties1.size());
        Assert.assertEquals((Object)"value1", properties1.get("prop1"));
        Assert.assertEquals((Object)"value2", properties1.get("prop2"));
    }

    @Test
    public void testParseProcessesXmlTwoArchives() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_two_archives.xml")).execute().getProcessesXml();
        Assert.assertNotNull((Object)processesXml);
        Assert.assertEquals((long)0L, (long)processesXml.getProcessEngines().size());
        Assert.assertEquals((long)2L, (long)processesXml.getProcessArchives().size());
        ProcessArchiveXml archiveXml1 = (ProcessArchiveXml)processesXml.getProcessArchives().get(0);
        Assert.assertEquals((Object)"pa1", (Object)archiveXml1.getName());
        Assert.assertEquals((Object)"default", (Object)archiveXml1.getProcessEngineName());
        List resourceNames = archiveXml1.getProcessResourceNames();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertEquals((Object)"process1.bpmn", resourceNames.get(0));
        Assert.assertEquals((Object)"process2.bpmn", resourceNames.get(1));
        Map properties1 = archiveXml1.getProperties();
        Assert.assertNotNull((Object)properties1);
        Assert.assertEquals((long)2L, (long)properties1.size());
        Assert.assertEquals((Object)"value1", properties1.get("prop1"));
        Assert.assertEquals((Object)"value2", properties1.get("prop2"));
        ProcessArchiveXml archiveXml2 = (ProcessArchiveXml)processesXml.getProcessArchives().get(1);
        Assert.assertEquals((Object)"pa2", (Object)archiveXml2.getName());
        Assert.assertEquals((Object)"default", (Object)archiveXml2.getProcessEngineName());
        List resourceNames2 = archiveXml2.getProcessResourceNames();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertEquals((Object)"process1.bpmn", resourceNames2.get(0));
        Assert.assertEquals((Object)"process2.bpmn", resourceNames2.get(1));
        Map properties2 = archiveXml2.getProperties();
        Assert.assertNotNull((Object)properties2);
        Assert.assertEquals((long)0L, (long)properties2.size());
    }

    @Test
    public void testParseProcessesXmlTwoArchivesAndTwoEngines() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_two_archives_two_engines.xml")).execute().getProcessesXml();
        Assert.assertNotNull((Object)processesXml);
        Assert.assertEquals((long)2L, (long)processesXml.getProcessEngines().size());
        Assert.assertEquals((long)2L, (long)processesXml.getProcessArchives().size());
        ProcessArchiveXml archiveXml1 = (ProcessArchiveXml)processesXml.getProcessArchives().get(0);
        Assert.assertEquals((Object)"pa1", (Object)archiveXml1.getName());
        Assert.assertEquals((Object)"default", (Object)archiveXml1.getProcessEngineName());
        List resourceNames = archiveXml1.getProcessResourceNames();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertEquals((Object)"process1.bpmn", resourceNames.get(0));
        Assert.assertEquals((Object)"process2.bpmn", resourceNames.get(1));
        Map properties1 = archiveXml1.getProperties();
        Assert.assertNotNull((Object)properties1);
        Assert.assertEquals((long)2L, (long)properties1.size());
        Assert.assertEquals((Object)"value1", properties1.get("prop1"));
        Assert.assertEquals((Object)"value2", properties1.get("prop2"));
        ProcessArchiveXml archiveXml2 = (ProcessArchiveXml)processesXml.getProcessArchives().get(1);
        Assert.assertEquals((Object)"pa2", (Object)archiveXml2.getName());
        Assert.assertEquals((Object)"default", (Object)archiveXml2.getProcessEngineName());
        List resourceNames2 = archiveXml2.getProcessResourceNames();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertEquals((Object)"process1.bpmn", resourceNames2.get(0));
        Assert.assertEquals((Object)"process2.bpmn", resourceNames2.get(1));
        Map properties2 = archiveXml2.getProperties();
        Assert.assertNotNull((Object)properties2);
        Assert.assertEquals((long)0L, (long)properties2.size());
        ProcessEngineXml engineXml1 = (ProcessEngineXml)processesXml.getProcessEngines().get(0);
        Assert.assertEquals((Object)"engine1", (Object)engineXml1.getName());
        Assert.assertEquals((Object)"configuration", (Object)engineXml1.getConfigurationClass());
        Assert.assertEquals((Object)"datasource", (Object)engineXml1.getDatasource());
        properties1 = engineXml1.getProperties();
        Assert.assertNotNull((Object)properties1);
        Assert.assertEquals((long)2L, (long)properties1.size());
        Assert.assertEquals((Object)"value1", properties1.get("prop1"));
        Assert.assertEquals((Object)"value2", properties1.get("prop2"));
        ProcessEngineXml engineXml2 = (ProcessEngineXml)processesXml.getProcessEngines().get(1);
        Assert.assertEquals((Object)"engine2", (Object)engineXml2.getName());
        Assert.assertEquals((Object)"configuration", (Object)engineXml2.getConfigurationClass());
        Assert.assertEquals((Object)"datasource", (Object)engineXml2.getDatasource());
        properties2 = engineXml2.getProperties();
        Assert.assertNotNull((Object)properties2);
        Assert.assertEquals((long)0L, (long)properties2.size());
    }

    @Test
    public void testParseProcessesXmlEngineNoName() {
        try {
            this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_engine_no_name.xml")).execute();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void FAILING_testParseProcessesXmlClassLineBreak() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_one_archive_with_line_break.xml")).execute().getProcessesXml();
        Assert.assertNotNull((Object)processesXml);
        ProcessArchiveXml archiveXml1 = (ProcessArchiveXml)processesXml.getProcessArchives().get(0);
        List resourceNames = archiveXml1.getProcessResourceNames();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertEquals((Object)"process1.bpmn", resourceNames.get(0));
    }

    @Test
    public void testParseProcessesXmlNsPrefix() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_ns_prefix.xml")).execute().getProcessesXml();
        Assert.assertNotNull((Object)processesXml);
        Assert.assertEquals((long)1L, (long)processesXml.getProcessEngines().size());
        Assert.assertEquals((long)1L, (long)processesXml.getProcessArchives().size());
    }

    @Test
    public void testParseProcessesXmlTenantId() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_tenant_id.xml")).execute().getProcessesXml();
        Assert.assertNotNull((Object)processesXml);
        Assert.assertEquals((long)2L, (long)processesXml.getProcessArchives().size());
        ProcessArchiveXml archiveXmlWithoutTenantId = (ProcessArchiveXml)processesXml.getProcessArchives().get(0);
        Assert.assertNull((Object)archiveXmlWithoutTenantId.getTenantId());
        ProcessArchiveXml archiveXmlWithTenantId = (ProcessArchiveXml)processesXml.getProcessArchives().get(1);
        Assert.assertEquals((Object)"tenant1", (Object)archiveXmlWithTenantId.getTenantId());
    }
}

