/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IncidentAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected static final String ANOTHER_ONE_INCIDENT_PROCESS_KEY = "anotherOneIncidentProcess";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/authorization/timerStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/anotherOneIncidentProcess.bpmn20.xml");
        super.setUp();
    }

    @Test
    public void testQueryForStandaloneIncidents() {
        String jobId = this.createStandaloneIncident();
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        this.cleanupStandalonIncident(jobId);
    }

    @Test
    public void testStartTimerJobIncidentQueryWithoutAuthorization() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testStartTimerJobIncidentQueryWithReadPermissionOnAnyProcessInstance() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testStartTimerJobIncidentQueryWithReadInstancePermissionOnProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testStartTimerJobIncidentQueryWithReadInstancePermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Incident incident = (Incident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)processInstanceId, (Object)incident.getProcessInstanceId());
    }

    @Test
    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Incident incident = (Incident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)processInstanceId, (Object)incident.getProcessInstanceId());
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Incident incident = (Incident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)processInstanceId, (Object)incident.getProcessInstanceId());
    }

    @Test
    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Incident incident = (Incident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)processInstanceId, (Object)incident.getProcessInstanceId());
    }

    @Test
    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Incident incident = (Incident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)processInstanceId, (Object)incident.getProcessInstanceId());
    }

    @Test
    public void shouldNotFindIncidentWithRevokedReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Incident incident = (Incident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)processInstanceId, (Object)incident.getProcessInstanceId());
    }

    @Test
    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 7);
    }

    @Test
    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 3);
    }

    @Test
    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults((Query<?, ?>)query, 7);
    }

    @Test
    public void shouldDenySetAnnotationWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setAnnotationForIncidentById(incident.getId(), "my annotation")).isInstanceOf(AuthorizationException.class)).hasMessageMatching(this.getMissingPermissionMessageRegex((Permission)Permissions.UPDATE, (Resource)Resources.PROCESS_INSTANCE)).hasMessageMatching(this.getMissingPermissionMessageRegex((Permission)Permissions.UPDATE_INSTANCE, (Resource)Resources.PROCESS_DEFINITION));
    }

    @Test
    public void shouldAllowSetAnnotationWithUpdatePermissionOnAnyInstance() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), "my annotation");
    }

    @Test
    public void shouldAllowSetAnnotationWithUpdatePermissionOnInstance() {
        ProcessInstance instance = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, instance.getId(), this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), "my annotation");
    }

    @Test
    public void shouldAllowSetAnnotationWithUpdateInstancePermissionOnAnyDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), "my annotation");
    }

    @Test
    public void shouldAllowSetAnnotationWithUpdateInstancePermissionOnOneTaskDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), "my annotation");
    }

    @Test
    public void shouldDenyClearAnnotationWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.clearAnnotationForIncidentById(incident.getId())).isInstanceOf(AuthorizationException.class)).hasMessageMatching(this.getMissingPermissionMessageRegex((Permission)Permissions.UPDATE, (Resource)Resources.PROCESS_INSTANCE)).hasMessageMatching(this.getMissingPermissionMessageRegex((Permission)Permissions.UPDATE_INSTANCE, (Resource)Resources.PROCESS_DEFINITION));
    }

    @Test
    public void shouldAllowClearAnnotationWithUpdatePermissionOnAnyInstance() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.clearAnnotationForIncidentById(incident.getId());
    }

    @Test
    public void shouldAllowClearAnnotationWithUpdatePermissionOnInstance() {
        ProcessInstance instance = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, instance.getId(), this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.clearAnnotationForIncidentById(incident.getId());
    }

    @Test
    public void shouldAllowClearAnnotationWithUpdateInstancePermissionOnAnyDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.clearAnnotationForIncidentById(incident.getId());
    }

    @Test
    public void shouldAllowClearAnnotationWithUpdateInstancePermissionOnOneTaskDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.clearAnnotationForIncidentById(incident.getId());
    }

    @Test
    public void shouldAllowSetAnnotationOnStandaloneIncidentWithoutAuthorization() {
        String jobId = this.createStandaloneIncident();
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), "my annotation");
        this.cleanupStandalonIncident(jobId);
    }

    @Test
    public void shouldAllowClearAnnotationOnStandaloneIncidentWithoutAuthorization() {
        String jobId = this.createStandaloneIncident();
        this.disableAuthorization();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.enableAuthorization();
        this.runtimeService.clearAnnotationForIncidentById(incident.getId());
        this.cleanupStandalonIncident(jobId);
    }

    protected String createStandaloneIncident() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String jobId = null;
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            jobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        return jobId;
    }

    protected void cleanupStandalonIncident(String jobId) {
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    protected void clearDatabase() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
                if (historyLevel.equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                    List incidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                    for (HistoricIncident incident : incidents) {
                        commandContext.getHistoricIncidentManager().delete((DbEntity)((HistoricIncidentEntity)incident));
                    }
                }
                return null;
            }
        });
    }
}

