/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobDefinitionAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/authorization/timerStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml");
        super.setUp();
    }

    @Test
    public void testQueryWithoutAuthorization() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testQueryWithReadPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void shouldNotFindJobDefinitionWithRevokedReadPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", "*", new Permission[]{Permissions.READ});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testSuspendByIdWithoutAuthorization() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.managementService.suspendJobDefinitionById(jobDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendByIdWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.suspendJobDefinitionById(jobDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testSuspendByIdWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.suspendJobDefinitionById(jobDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testActivateByIdWithoutAuthorization() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionById(jobDefinitionId);
        try {
            this.managementService.activateJobDefinitionById(jobDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to activate a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateByIdWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionById(jobDefinitionId);
        this.managementService.activateJobDefinitionById(jobDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testActivateByIdWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionById(jobDefinitionId);
        this.managementService.activateJobDefinitionById(jobDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByIdWithoutAuthorization() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendIncludingJobsByIdWithUpdatePermissionOnProcessInstance() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendIncludingJobsByIdWithUpdatePermissionOnAnyProcessInstance() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByIdWithUpdateInstancePermissionOnProcessDefinition() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByIdWithoutAuthorization() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionById(jobDefinitionId, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateIncludingJobsByIdWithUpdatePermissionOnProcessInstance() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionById(jobDefinitionId, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateIncludingJobsByIdWithUpdatePermissionOnAnyProcessInstance() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByIdWithUpdateInstancePermissionOnProcessDefinition() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    @Test
    public void testSuspendByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendByProcessDefinitionIdWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testSuspendByProcessDefinitionIdWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testActivateByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to activate a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateByProcessDefinitionIdWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testActivateByProcessDefinitionIdWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionIdWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionIdWithUpdateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionIdWithUpdateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    @Test
    public void testSuspendByProcessDefinitionKeyWithoutAuthorization() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendByProcessDefinitionKeyWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testSuspendByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testActivateByProcessDefinitionKeyWithoutAuthorization() {
        this.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateByProcessDefinitionKeyWithUpdatePermissionOnProcessDefinition() {
        this.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testActivateByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessDefinition() {
        this.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionKeyWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionKeyWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testSuspendIncludingJobsByProcessDefinitionKeyWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionKeyWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
            Assert.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionKeyWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    @Test
    public void testActivateIncludingJobsByProcessDefinitionKeyWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
    }

    protected JobDefinition selectJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.disableAuthorization();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        this.enableAuthorization();
        return jobDefinition;
    }

    protected Job selectJobByProcessInstanceId(String processInstanceId) {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        this.enableAuthorization();
        return job;
    }
}

