/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SingleProcessInstanceModificationAsyncAuthorizationTest
extends AuthorizationTest {
    protected static final String PARALLEL_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";

    @Override
    @After
    public void tearDown() {
        this.disableAuthorization();
        List batches = this.managementService.createBatchQuery().list();
        for (Batch batch : batches) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            this.managementService.deleteJob(job.getId());
        }
        this.enableAuthorization();
        super.tearDown();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testModificationWithAllPermissions() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "parallelGateway", this.userId, new Permission[]{Permissions.CREATE_INSTANCE, Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.BATCH, "*", this.userId, new Permission[]{Permissions.CREATE});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        String processDefinitionId = processInstance.getProcessDefinitionId();
        this.disableAuthorization();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        this.enableAuthorization();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Batch modificationBatch = this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).executeAsync();
        Assert.assertNotNull((Object)modificationBatch);
        Job job = (Job)this.managementService.createJobQuery().jobDefinitionId(modificationBatch.getSeedJobDefinitionId()).singleResult();
        this.managementService.executeJob(job.getId());
        for (Job pending : this.managementService.createJobQuery().jobDefinitionId(modificationBatch.getBatchJobDefinitionId()).list()) {
            this.managementService.executeJob(pending.getId());
            Assert.assertEquals((Object)processDefinition.getDeploymentId(), (Object)pending.getDeploymentId());
        }
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        this.disableAuthorization();
        this.completeTasksInOrder("task2");
        this.testRule.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testModificationWithoutBatchPermissions() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "parallelGateway", this.userId, new Permission[]{Permissions.CREATE_INSTANCE, Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).executeAsync();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The user with id 'test' does not have"));
            Assert.assertTrue((boolean)e.getMessage().contains("'CREATE' permission on resource 'Batch'"));
            Assert.assertTrue((boolean)e.getMessage().contains("'CREATE_BATCH_MODIFY_PROCESS_INSTANCES' permission on resource 'Batch'"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testModificationRevoke() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "parallelGateway", this.userId, new Permission[]{Permissions.CREATE_INSTANCE, Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.BATCH, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createRevokeAuthorization((Resource)Resources.BATCH, "*", this.userId, new Permission[]{BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).executeAsync();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The user with id 'test' does not have"));
            Assert.assertTrue((boolean)e.getMessage().contains("'CREATE' permission on resource 'Batch'"));
            Assert.assertTrue((boolean)e.getMessage().contains("'CREATE_BATCH_MODIFY_PROCESS_INSTANCES' permission on resource 'Batch'"));
        }
    }

    protected String getInstanceIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance instance = this.getChildInstanceForActivity(activityInstance, activityId);
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

