/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch.creation;

import java.util.Collection;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.api.authorization.batch.creation.BatchCreationAuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class CorrelateAllMessageBatchAuthorizationTest
extends BatchCreationAuthorizationTest {
    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_CORRELATE_MESSAGE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_CORRELATE_MESSAGE})).succeeds());
    }

    @Test
    public void shouldAuthorizeSetVariablesBatch() {
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").bindResource("processDefinitionKey", "Process").start();
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        this.runtimeService.createMessageCorrelationAsync("test").processInstanceQuery(processInstanceQuery).setVariable("foo", (Object)"bar").correlateAllAsync();
        this.authRule.assertScenario(this.scenario);
    }
}

