/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "testProcess";
    protected static final String DECISION_DEFINITION_KEY = "testDecision";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml");
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testQueryWithReadPermissionOnAnyDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testQueryWithMultiple() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void shouldNotFindDecisionInstanceWithRevokedReadPermissionOnAnyDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", "*", new Permission[]{Permissions.READ_HISTORY});
        this.createRevokeAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testDeleteHistoricDecisionInstanceWithoutAuthorization() {
        this.startProcessInstanceAndEvaluateDecision();
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
            Assert.fail((String)"expect authorization exception");
        }
        catch (AuthorizationException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"The user with id 'test' does not have 'DELETE_HISTORY' permission on resource 'testDecision' of type 'DecisionDefinition'.");
        }
    }

    @Test
    public void testDeleteHistoricDecisionInstanceWithDeleteHistoryPermissionOnDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        this.disableAuthorization();
        Assertions.assertThat((long)this.historyService.createHistoricDecisionInstanceQuery().count()).isEqualTo(0L);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteHistoricDecisionInstanceWithDeleteHistoryPermissionOnAnyDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        this.disableAuthorization();
        Assertions.assertThat((long)this.historyService.createHistoricDecisionInstanceQuery().count()).isEqualTo(0L);
        this.enableAuthorization();
    }

    @Test
    public void testDeleteHistoricDecisionInstanceByInstanceIdWithoutAuthorization() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        try {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
            Assert.fail((String)"expect authorization exception");
        }
        catch (AuthorizationException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"The user with id 'test' does not have 'DELETE_HISTORY' permission on resource 'testDecision' of type 'DecisionDefinition'.");
        }
    }

    @Test
    public void testDeleteHistoricDecisionInstanceByInstanceIdWithDeleteHistoryPermissionOnDecisionDefinition() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY, Permissions.READ_HISTORY});
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testHistoryCleanupReportWithoutAuthorization() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testHistoryCleanupReportWithAuthorization() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_HISTORY});
        this.createGrantAuthorizationGroup((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.groupId, new Permission[]{Permissions.READ, Permissions.READ_HISTORY});
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals((long)10L, (long)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0)).getCleanableDecisionInstanceCount());
        Assert.assertEquals((long)10L, (long)((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0)).getFinishedDecisionInstanceCount());
    }

    @Test
    public void testHistoryCleanupReportWithReadPermissionOnly() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testHistoryCleanupReportWithReadHistoryPermissionOnly() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void shouldNotFindCleanupReportWithRevokedReadHistoryPermissionOnDecisionDefinition() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ, Permissions.READ_HISTORY});
        this.createRevokeAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    protected void startProcessInstanceAndEvaluateDecision() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input1", null);
        this.startProcessInstanceByKey(PROCESS_KEY, variables);
    }

    protected void prepareDecisionInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        DecisionDefinition decisionDefinition = this.selectDecisionDefinitionByKey(key);
        this.disableAuthorization();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), historyTimeToLive);
        this.enableAuthorization();
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        VariableMap variables = Variables.createVariables().putValue("input1", null);
        for (int i = 0; i < instanceCount; ++i) {
            this.disableAuthorization();
            this.decisionService.evaluateDecisionByKey(key).variables((Map)variables).evaluate();
            this.enableAuthorization();
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }
}

