/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.task.updatevariable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StandaloneTaskAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected TaskService taskService;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected static final String userId = "userId";
    protected String taskId = "myTask";
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    protected static final String PROCESS_KEY = "oneTaskProcess";

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{TaskPermissions.UPDATE_VARIABLE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.UPDATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "*", userId, new Permission[]{Permissions.UPDATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{TaskPermissions.UPDATE_VARIABLE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "*", userId, new Permission[]{TaskPermissions.UPDATE_VARIABLE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.TASK, "*", "*", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.revoke((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.UPDATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.TASK, "taskId", userId, new Permission[]{TaskPermissions.UPDATE_VARIABLE})));
    }

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.authRule.createUserAndGroup(userId, "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.taskService.deleteTask(this.taskId, true);
        for (HistoricVariableInstance var : this.historyService.createHistoricVariableInstanceQuery().includeDeleted().list()) {
            this.historyService.deleteHistoricVariableInstance(var.getId());
        }
    }

    @Test
    public void testSetVariable() {
        this.createTask(this.taskId);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        this.taskService.setVariable(this.taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    public void testSetVariableLocal() {
        this.createTask(this.taskId);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        this.taskService.setVariableLocal(this.taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    public void testSetVariables() {
        this.createTask(this.taskId);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        this.taskService.setVariables(this.taskId, (Map)this.getVariables());
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    public void testSetVariablesLocal() {
        this.createTask(this.taskId);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        this.taskService.setVariablesLocal(this.taskId, (Map)this.getVariables());
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testRemoveVariable() {
        this.createTask(this.taskId);
        this.taskService.setVariable(this.taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        this.taskService.removeVariable(this.taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariable();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testRemoveVariableLocal() {
        this.createTask(this.taskId);
        this.taskService.setVariableLocal(this.taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        this.taskService.removeVariableLocal(this.taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariable();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testRemoveVariables() {
        this.createTask(this.taskId);
        this.taskService.setVariable(this.taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        this.taskService.removeVariables(this.taskId, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariable();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testRemoveVariablesLocal() {
        this.createTask(this.taskId);
        this.taskService.setVariableLocal(this.taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        this.taskService.removeVariablesLocal(this.taskId, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariable();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesAdd() {
        this.createTask(this.taskId);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariables(this.taskId, (Map)this.getVariables(), null);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesRemove() {
        this.createTask(this.taskId);
        this.taskService.setVariable(this.taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariables(this.taskId, null, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariable();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesAddRemove() {
        this.createTask(this.taskId);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariables(this.taskId, (Map)this.getVariables(), Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariable();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesLocalAdd() {
        this.createTask(this.taskId);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(this.taskId, (Map)this.getVariables(), null);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifySetVariables();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesLocalRemove() {
        this.createTask(this.taskId);
        this.taskService.setVariableLocal(this.taskId, VARIABLE_NAME, (Object)VARIABLE_VALUE);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(this.taskId, null, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariable();
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUpdateVariablesLocalAddRemove() {
        this.createTask(this.taskId);
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", this.taskId).start();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(this.taskId, (Map)this.getVariables(), Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyRemoveVariable();
        }
    }

    protected void verifySetVariables() {
        this.verifyVariableInstanceCount(1);
        Assert.assertNotNull((Object)this.runtimeService.createVariableInstanceQuery().singleResult());
    }

    protected void verifyRemoveVariable() {
        this.verifyVariableInstanceCount(0);
        Assert.assertNull((Object)this.runtimeService.createVariableInstanceQuery().singleResult());
        HistoricVariableInstance deletedVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().includeDeleted().singleResult();
        Assert.assertEquals((Object)"DELETED", (Object)deletedVariable.getState());
    }

    protected void verifyVariableInstanceCount(int count) {
        Assert.assertEquals((long)count, (long)this.runtimeService.createVariableInstanceQuery().list().size());
        Assert.assertEquals((long)count, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    protected void createTask(String taskId) {
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue(VARIABLE_NAME, (Object)VARIABLE_VALUE);
    }
}

