/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import org.apache.ibatis.datasource.pooled.PoolState;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class ForceCloseMybatisConnectionPoolTest {
    @Test
    public void testForceCloseMybatisConnectionPoolTrue() {
        ProcessEngineConfigurationImpl configurationImpl = new StandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:camunda-forceclose").setProcessEngineName("engine-forceclose").setForceCloseMybatisConnectionPool(true);
        ProcessEngine processEngine = configurationImpl.buildProcessEngine();
        PooledDataSource pooledDataSource = (PooledDataSource)configurationImpl.getDataSource();
        PoolState state = pooledDataSource.getPoolState();
        processEngine.close();
        Assert.assertTrue((state.getIdleConnectionCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testForceCloseMybatisConnectionPoolFalse() {
        ProcessEngineConfigurationImpl configurationImpl = new StandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:camunda-forceclose").setProcessEngineName("engine-forceclose").setForceCloseMybatisConnectionPool(false);
        ProcessEngine processEngine = configurationImpl.buildProcessEngine();
        PooledDataSource pooledDataSource = (PooledDataSource)configurationImpl.getDataSource();
        PoolState state = pooledDataSource.getPoolState();
        int idleConnections = state.getIdleConnectionCount();
        processEngine.close();
        Assert.assertEquals((long)state.getIdleConnectionCount(), (long)idleConnections);
        pooledDataSource.forceCloseAll();
        Assert.assertTrue((state.getIdleConnectionCount() == 0 ? 1 : 0) != 0);
    }
}

