/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class CaseServiceCaseInstanceTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("oneTaskCase").create();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertNull((Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertEquals((Object)caseInstance.getId(), (Object)instance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)instance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)instance.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstance.isActive(), (Object)instance.isActive());
        Assert.assertEquals((Object)caseInstance.isEnabled(), (Object)instance.isEnabled());
    }

    @Test
    public void testCreateByInvalidKey() {
        try {
            this.caseService.withCaseDefinitionByKey("invalid").create();
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.withCaseDefinitionByKey(null).create();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateById() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).create();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertNull((Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertEquals((Object)caseInstance.getId(), (Object)instance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)instance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)instance.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstance.isActive(), (Object)instance.isActive());
        Assert.assertEquals((Object)caseInstance.isEnabled(), (Object)instance.isEnabled());
    }

    @Test
    public void testCreateByInvalidId() {
        try {
            this.caseService.withCaseDefinition("invalid").create();
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            this.caseService.withCaseDefinition(null).create();
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByKeyWithBusinessKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("oneTaskCase").businessKey("aBusinessKey").create();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertEquals((Object)caseInstance.getId(), (Object)instance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)instance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)instance.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstance.isActive(), (Object)instance.isActive());
        Assert.assertEquals((Object)caseInstance.isEnabled(), (Object)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByIdWithBusinessKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).businessKey("aBusinessKey").create();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertEquals((Object)caseInstance.getId(), (Object)instance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)instance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)instance.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstance.isActive(), (Object)instance.isActive());
        Assert.assertEquals((Object)caseInstance.isEnabled(), (Object)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByKeyWithVariable() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("aVariableName", (Object)"aVariableValue").setVariable("anotherVariableName", (Object)999).create();
        Assert.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByKeyWithVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "aVariableValue");
        variables.put("anotherVariableName", 999);
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariables(variables).create();
        Assert.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByIdWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).setVariable("aVariableName", (Object)"aVariableValue").setVariable("anotherVariableName", (Object)999).create();
        Assert.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByIdWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "aVariableValue");
        variables.put("anotherVariableName", 999);
        CaseInstance caseInstance = this.caseService.withCaseDefinition(caseDefinitionId).setVariables(variables).create();
        Assert.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                Assert.assertEquals((Object)"aVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                Assert.assertEquals((Object)"anotherVariableName", (Object)variableInstance.getName());
                Assert.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            Assert.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testManualStart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).manualStart();
            Assert.fail((String)"It should not be possible to start a case instance manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testDisable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).disable();
            Assert.fail((String)"It should not be possible to disable a case instance.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testReenable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).reenable();
            Assert.fail((String)"It should not be possible to re-enable a case instance.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testCompleteWithEnabledTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        this.caseService.withCaseExecution(caseInstanceId).complete();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testCompleteWithEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseExecution caseExecution2 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2").singleResult();
        this.caseService.withCaseExecution(caseExecution.getId()).complete();
        this.caseService.withCaseExecution(caseExecution2.getId()).complete();
        CaseExecution caseExecution3 = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        Assert.assertNull((Object)caseExecution3);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCompleteWithActiveTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).complete();
            Assert.fail((String)"It should not be possible to complete a case instance containing an active task.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)caseExecution);
        Assert.assertTrue((boolean)caseExecution.isActive());
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    @Test
    public void testCompleteWithActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).complete();
            Assert.fail((String)"It should not be possible to complete a case instance containing an active stage.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        Assert.assertNotNull((Object)caseExecution);
        Assert.assertTrue((boolean)caseExecution.isActive());
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyCasePlanModelCase.cmmn"})
    @Test
    public void testAutoCompletionOfEmptyCase() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCloseAnActiveCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        try {
            this.caseService.withCaseExecution(caseInstanceId).close();
            Assert.fail((String)"It should not be possible to close an active case instance.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testCloseACompletedCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.withCaseExecution(caseInstanceId).close();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNull((Object)caseInstance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testTerminateActiveCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        Assert.assertNotNull((Object)this.queryCaseExecutionByActivityId("CasePlanModel_1"));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Assert.assertTrue((boolean)taskExecution.isActive());
        this.caseService.withCaseExecution(caseInstanceId).terminate();
        CaseExecution caseInstance = this.queryCaseExecutionByActivityId("CasePlanModel_1");
        Assert.assertTrue((boolean)caseInstance.isTerminated());
        Assert.assertNull((Object)this.queryCaseExecutionByActivityId("PI_HumanTask_1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testTerminateNonActiveCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        Assert.assertNotNull((Object)this.queryCaseExecutionByActivityId("CasePlanModel_1"));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Assert.assertTrue((boolean)taskExecution.isEnabled());
        this.caseService.completeCaseExecution(caseInstanceId);
        try {
            this.caseService.terminateCaseExecution(caseInstanceId);
            Assert.fail((String)"It should not be possible to terminate a task.");
        }
        catch (NotAllowedException e) {
            boolean result = e.getMessage().contains("The case execution must be in state 'active' to terminate");
            Assert.assertTrue((boolean)result);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testTerminateActiveCaseInstanceNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        Assert.assertNotNull((Object)this.queryCaseExecutionByActivityId("CasePlanModel_1"));
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        Assert.assertTrue((boolean)taskExecution.isActive());
        this.caseService.terminateCaseExecution(caseInstanceId);
        CaseExecution caseInstance = this.queryCaseExecutionByActivityId("CasePlanModel_1");
        Assert.assertTrue((boolean)caseInstance.isTerminated());
        Assert.assertNull((Object)this.queryCaseExecutionByActivityId("PI_HumanTask_1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByKeyNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertNull((Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertEquals((Object)caseInstance.getId(), (Object)instance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)instance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)instance.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstance.isActive(), (Object)instance.isActive());
        Assert.assertEquals((Object)caseInstance.isEnabled(), (Object)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByIdNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId);
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertNull((Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertEquals((Object)caseInstance.getId(), (Object)instance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)instance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)instance.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstance.isActive(), (Object)instance.isActive());
        Assert.assertEquals((Object)caseInstance.isEnabled(), (Object)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByKeyWithBusinessKeyNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", "aBusinessKey");
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertEquals((Object)caseInstance.getId(), (Object)instance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)instance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)instance.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstance.isActive(), (Object)instance.isActive());
        Assert.assertEquals((Object)caseInstance.isEnabled(), (Object)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByIdWithBusinessKeyNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId, "aBusinessKey");
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)caseInstance.getBusinessKey());
        Assert.assertEquals((Object)caseDefinitionId, (Object)caseInstance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)caseInstance.getCaseInstanceId());
        Assert.assertTrue((boolean)caseInstance.isActive());
        Assert.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertEquals((Object)caseInstance.getId(), (Object)instance.getId());
        Assert.assertEquals((Object)caseInstance.getBusinessKey(), (Object)instance.getBusinessKey());
        Assert.assertEquals((Object)caseInstance.getCaseDefinitionId(), (Object)instance.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstance.getCaseInstanceId(), (Object)instance.getCaseInstanceId());
        Assert.assertEquals((Object)caseInstance.isActive(), (Object)instance.isActive());
        Assert.assertEquals((Object)caseInstance.isEnabled(), (Object)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByKeyWithVariablesNonFluent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", variables);
        Assert.assertNotNull((Object)caseInstance);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstance.getId()}).singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"aVariable", (Object)variable.getName());
        Assert.assertEquals((Object)"aValue", (Object)variable.getValue());
        Assert.assertEquals((Object)caseInstance.getId(), (Object)variable.getCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByIdWithVariablesNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId, variables);
        Assert.assertNotNull((Object)caseInstance);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstance.getId()}).singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"aVariable", (Object)variable.getName());
        Assert.assertEquals((Object)"aValue", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByKeyWithVariablesAndBusinessKeyNonFluent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", "aBusinessKey", variables);
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)caseInstance.getBusinessKey());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstance.getId()}).variableValueEquals("aVariable", (Object)"aValue").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCreateByIdWithVariablesAndBusinessKeyNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId, "aBusinessKey", variables);
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertEquals((Object)"aBusinessKey", (Object)caseInstance.getBusinessKey());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstance.getId()}).variableValueEquals("aVariable", (Object)"aValue").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    @Test
    public void testCloseNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.closeCaseInstance(caseInstanceId);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNull((Object)caseInstance);
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }
}

