/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.delegate;

import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.test.api.delegate.AssertingJavaDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DelegateExecutionHierarchyTest
extends PluggableProcessEngineTest {
    @After
    public void tearDown() throws Exception {
        AssertingJavaDelegate.clear();
    }

    @Test
    public void testSingleNonScopeActivity() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done());
        AssertingJavaDelegate.addAsserts(new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                Assert.assertEquals((Object)execution, (Object)execution.getProcessInstance());
                Assert.assertNull((Object)execution.getSuperExecution());
            }
        });
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }

    @Test
    public void testConcurrentServiceTasks() {
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().parallelGateway("fork").serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).parallelGateway("join").endEvent().moveToNode("fork").serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).connectTo("join").done());
        AssertingJavaDelegate.addAsserts(new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                Assert.assertFalse((boolean)execution.equals(execution.getProcessInstance()));
                Assert.assertNull((Object)execution.getSuperExecution());
            }
        });
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }

    @Test
    public void testTaskInsideEmbeddedSubprocess() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().subProcess().embeddedSubProcess().startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().subProcessDone().endEvent().done());
        AssertingJavaDelegate.addAsserts(new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                Assert.assertFalse((boolean)execution.equals(execution.getProcessInstance()));
                Assert.assertNull((Object)execution.getSuperExecution());
            }
        });
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }

    @Test
    public void testSubProcessInstance() {
        this.testRule.deploy(((CallActivityBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().callActivity().calledElement("testProcess2")).endEvent().done(), ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess2").startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done());
        AssertingJavaDelegate.addAsserts(new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                Assert.assertTrue((boolean)execution.equals(execution.getProcessInstance()));
                Assert.assertNotNull((Object)execution.getSuperExecution());
            }
        });
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }
}

