/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.filter.FilterQuery;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.task.NativeTaskQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterQueryTest
extends PluggableProcessEngineTest {
    protected List<String> filterIds = new ArrayList<String>();

    @Before
    public void setUp() {
        this.saveFilter("b", "b");
        this.saveFilter("d", "d");
        this.saveFilter("a", "a");
        this.saveFilter("c_", "c");
    }

    protected void saveFilter(String name, String owner) {
        Filter filter = this.filterService.newTaskFilter().setName(name).setOwner(owner);
        this.filterService.saveFilter(filter);
        this.filterIds.add(filter.getId());
    }

    @After
    public void tearDown() {
        for (Filter filter : this.filterService.createFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
    }

    @Test
    public void testQueryNoCriteria() {
        FilterQuery query = this.filterService.createFilterQuery();
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)4L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByFilterId() {
        FilterQuery query = this.filterService.createFilterQuery().filterId(this.filterIds.get(0));
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidFilterId() {
        FilterQuery query = this.filterService.createFilterQuery().filterId("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.filterService.createFilterQuery().filterId(null);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByResourceType() {
        FilterQuery query = this.filterService.createFilterQuery().filterResourceType("Task");
        try {
            query.singleResult();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)query.list().size());
        Assert.assertEquals((long)4L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidResourceType() {
        FilterQuery query = this.filterService.createFilterQuery().filterResourceType("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.filterService.createFilterQuery().filterResourceType(null);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByName() {
        FilterQuery query = this.filterService.createFilterQuery().filterName("a");
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByNameLike() {
        FilterQuery query = this.filterService.createFilterQuery().filterNameLike("%\\_");
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidName() {
        FilterQuery query = this.filterService.createFilterQuery().filterName("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.filterService.createFilterQuery().filterName(null);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByOwner() {
        FilterQuery query = this.filterService.createFilterQuery().filterOwner("a");
        Assert.assertNotNull((Object)query.singleResult());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidOwner() {
        FilterQuery query = this.filterService.createFilterQuery().filterOwner("invalid");
        Assert.assertNull((Object)query.singleResult());
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            this.filterService.createFilterQuery().filterOwner(null);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryPaging() {
        FilterQuery query = this.filterService.createFilterQuery();
        Assert.assertEquals((long)4L, (long)query.listPage(0, Integer.MAX_VALUE).size());
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)4L, (long)query.list().size());
        Assert.assertEquals((long)2L, (long)query.listPage(0, 2).size());
        Assert.assertEquals((long)2L, (long)query.listPage(2, 2).size());
        Assert.assertEquals((long)1L, (long)query.listPage(3, 1).size());
        Assert.assertEquals((long)0L, (long)query.listPage(-1, -1).size());
        Assert.assertEquals((long)0L, (long)query.listPage(4, 2).size());
        Assert.assertEquals((long)4L, (long)query.listPage(0, 15).size());
    }

    @Test
    public void testQuerySorting() {
        ArrayList<String> sortedIds = new ArrayList<String>(this.filterIds);
        Collections.sort(sortedIds);
        Assert.assertEquals((long)4L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().asc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().asc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)((String)sortedIds.get(0)))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)((String)sortedIds.get(1)))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)((String)sortedIds.get(2)))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)((String)sortedIds.get(3))))}));
        Assert.assertEquals((long)4L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterResourceType().asc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterResourceType().asc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task"))}));
        Assert.assertEquals((long)4L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterName().asc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterName().asc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"a")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"b")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"c_")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"d"))}));
        Assert.assertEquals((long)4L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterOwner().asc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterOwner().asc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"owner", (Matcher)Matchers.equalTo((Object)"a")), HasPropertyWithValue.hasProperty((String)"owner", (Matcher)Matchers.equalTo((Object)"b")), HasPropertyWithValue.hasProperty((String)"owner", (Matcher)Matchers.equalTo((Object)"c")), HasPropertyWithValue.hasProperty((String)"owner", (Matcher)Matchers.equalTo((Object)"d"))}));
        Assert.assertEquals((long)4L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().desc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().desc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)((String)sortedIds.get(3)))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)((String)sortedIds.get(2)))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)((String)sortedIds.get(1)))), HasPropertyWithValue.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)((String)sortedIds.get(0))))}));
        Assert.assertEquals((long)4L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterResourceType().desc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterResourceType().desc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task")), HasPropertyWithValue.hasProperty((String)"resourceType", (Matcher)Matchers.equalTo((Object)"Task"))}));
        Assert.assertEquals((long)4L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterName().desc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterName().desc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"d")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"c_")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"b")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"a"))}));
        Assert.assertEquals((long)4L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterOwner().desc()).list().size());
        Assert.assertThat((Object)((FilterQuery)this.filterService.createFilterQuery().orderByFilterOwner().desc()).list(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"d")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"c_")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"b")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"a"))}));
        Assert.assertEquals((long)1L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().filterName("a").asc()).list().size());
        Assert.assertEquals((long)1L, (long)((FilterQuery)this.filterService.createFilterQuery().orderByFilterId().filterName("a").desc()).list().size());
    }

    @Test
    public void testNativeQuery() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_FILTER"), (Object)this.managementService.getTableName(Filter.class));
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_FILTER"), (Object)this.managementService.getTableName(FilterEntity.class));
        Assert.assertEquals((long)4L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Filter.class))).list().size());
        Assert.assertEquals((long)4L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Filter.class))).count());
        Assert.assertEquals((long)16L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + tablePrefix + "ACT_RU_FILTER F1, " + tablePrefix + "ACT_RU_FILTER F2")).count());
        Assert.assertEquals((long)4L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT F1.* FROM " + tablePrefix + "ACT_RU_FILTER F1")).list().size());
        Assert.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Filter.class) + " F WHERE F.NAME_ = 'a'")).count());
        Assert.assertEquals((long)1L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Filter.class) + " F WHERE F.NAME_ = 'a'")).list().size());
        Assert.assertEquals((long)1L, (long)((NativeTaskQuery)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(Filter.class) + " F WHERE F.NAME_ = #{filterName}")).parameter("filterName", (Object)"a")).count());
    }

    @Test
    public void testNativeQueryPaging() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_FILTER"), (Object)this.managementService.getTableName(Filter.class));
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_FILTER"), (Object)this.managementService.getTableName(FilterEntity.class));
        Assert.assertEquals((long)3L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Filter.class))).listPage(0, 3).size());
        Assert.assertEquals((long)2L, (long)((NativeTaskQuery)this.taskService.createNativeTaskQuery().sql("SELECT * FROM " + this.managementService.getTableName(Filter.class))).listPage(2, 2).size());
    }
}

