/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class FilterServiceUserOperationLogTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected FilterService filterService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule);

    @Before
    public void setUp() {
        this.filterService = this.engineRule.getFilterService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void tearDown() {
        for (Filter filter : this.filterService.createTaskFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
    }

    @Test
    public void testCreateFilter() {
        Filter filter = this.filterService.newTaskFilter().setName("name").setOwner("owner").setQuery((Query)this.taskService.createTaskQuery()).setProperties(new HashMap());
        this.identityService.setAuthenticatedUserId("userId");
        this.filterService.saveFilter(filter);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)1L, (long)this.historyService.createUserOperationLogQuery().count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"Filter");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Create");
        Assertions.assertThat((String)logEntry.getProperty()).isEqualTo((Object)"filterId");
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isEqualTo((Object)filter.getId());
    }

    @Test
    public void testUpdateFilter() {
        Filter filter = this.filterService.newTaskFilter().setName("name").setOwner("owner").setQuery((Query)this.taskService.createTaskQuery()).setProperties(new HashMap());
        this.filterService.saveFilter(filter);
        this.identityService.setAuthenticatedUserId("userId");
        filter.setName(filter.getName() + "_new");
        this.filterService.saveFilter(filter);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)1L, (long)this.historyService.createUserOperationLogQuery().count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"Filter");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Update");
        Assertions.assertThat((String)logEntry.getProperty()).isEqualTo((Object)"filterId");
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isEqualTo((Object)filter.getId());
    }

    @Test
    public void testDeleteFilter() {
        Filter filter = this.filterService.newTaskFilter().setName("name").setOwner("owner").setQuery((Query)this.taskService.createTaskQuery()).setProperties(new HashMap());
        this.filterService.saveFilter(filter);
        this.identityService.setAuthenticatedUserId("userId");
        this.filterService.deleteFilter(filter.getId());
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)1L, (long)this.historyService.createUserOperationLogQuery().count());
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"Filter");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)logEntry.getProperty()).isEqualTo((Object)"filterId");
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isEqualTo((Object)filter.getId());
    }
}

