/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.impl.DefaultPriorityProvider;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class HistoryCleanupJobPriorityTest {
    private static final Long CUSTOM_PRIORITY = 10L;
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl config;
    protected HistoryService historyService;
    protected long defaultHistoryCleanupJobPriority;

    @Before
    public void setup() {
        this.config = this.engineRule.getProcessEngineConfiguration();
        this.historyService = this.engineRule.getHistoryService();
        this.defaultHistoryCleanupJobPriority = this.config.getHistoryCleanupJobPriority();
    }

    @After
    public void reset() {
        this.config.setHistoryCleanupJobPriority(this.defaultHistoryCleanupJobPriority);
        this.resetDatabase();
    }

    private void resetDatabase() {
        this.config.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupJobPriorityTest.this.historyService.findHistoryCleanupJobs();
                for (Job job : jobs) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }

    @Test
    public void historyCleanupJobShouldHaveDefaultPriority() {
        this.historyService.cleanUpHistoryAsync(true);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assertions.assertThat((List)historyCleanupJobs).hasSize(1);
        Assertions.assertThat((long)((Job)historyCleanupJobs.get(0)).getPriority()).isEqualTo(DefaultPriorityProvider.DEFAULT_PRIORITY);
    }

    @Test
    public void historyCleanupJobShouldGetPriorityFromProcessEngineConfiguration() {
        this.config.setHistoryCleanupJobPriority(CUSTOM_PRIORITY.longValue());
        this.historyService.cleanUpHistoryAsync(true);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assertions.assertThat((List)historyCleanupJobs).hasSize(1);
        Assertions.assertThat((long)((Job)historyCleanupJobs.get(0)).getPriority()).isEqualTo((Object)CUSTOM_PRIORITY);
    }
}

