/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.history.removaltime.batch.helper.BatchSetRemovalTimeRule;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchSetRemovalTimeInChunksTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchSetRemovalTimeRule testRule = new BatchSetRemovalTimeRule(this.engineRule, this.engineTestRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule).around((TestRule)this.testRule);
    protected final Date REMOVAL_TIME;
    protected final Date CREATE_TIME;
    protected final Date CURRENT_DATE;
    protected ProcessEngineConfigurationImpl engineConfiguration;
    protected RuntimeService runtimeService;
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected ExternalTaskService externalTaskService;
    protected AuthorizationService authorizationService;
    protected int defaultMaxUpdateRows;
    protected int defaultInvocationsPerBatchJob;

    public BatchSetRemovalTimeInChunksTest() {
        this.REMOVAL_TIME = this.testRule.REMOVAL_TIME;
        this.CREATE_TIME = new GregorianCalendar(2013, 2, 18, 13, 0, 0).getTime();
        this.CURRENT_DATE = this.testRule.CURRENT_DATE;
    }

    @Before
    public void setup() {
        this.engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.defaultMaxUpdateRows = this.engineConfiguration.getRemovalTimeUpdateChunkSize();
        this.defaultInvocationsPerBatchJob = this.engineConfiguration.getInvocationsPerBatchJob();
        this.engineConfiguration.setRemovalTimeUpdateChunkSize(1);
        this.runtimeService = this.engineRule.getRuntimeService();
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.authorizationService = this.engineRule.getAuthorizationService();
    }

    @After
    public void tearDown() {
        this.engineConfiguration.setRemovalTimeUpdateChunkSize(this.defaultMaxUpdateRows);
        this.engineConfiguration.setInvocationsPerBatchJob(this.defaultInvocationsPerBatchJob);
    }

    @Test
    public void shouldRescheduleRemovalTimeJob() {
        this.testRule.process().serviceTask().serviceTask().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync();
        this.testRule.executeSeedJobs(batch, true);
        this.testRule.getExecutionJobs(batch).forEach(job -> this.managementService.executeJob(job.getId()));
        this.testRule.getExecutionJobs(batch).forEach(job -> this.managementService.executeJob(job.getId()));
        Assertions.assertThat(this.testRule.getExecutionJobs(batch)).isNotEmpty();
    }

    @Test
    public void shouldUseCustomChunkSize() {
        this.testRule.process().serviceTask().serviceTask().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().chunkSize(100).executeAsync();
        this.testRule.executeSeedJobs(batch, true);
        this.testRule.getExecutionJobs(batch).forEach(job -> this.managementService.executeJob(job.getId()));
        this.testRule.getExecutionJobs(batch).forEach(job -> this.managementService.executeJob(job.getId()));
        Assertions.assertThat(this.testRule.getExecutionJobs(batch)).isEmpty();
    }

    @Test
    public void shouldUpdateProcessInstanceLast() {
        this.testRule.process().serviceTask().serviceTask().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().chunkSize(100).executeAsync();
        this.testRule.executeSeedJobs(batch, true);
        this.testRule.getExecutionJobs(batch).forEach(job -> this.managementService.executeJob(job.getId()));
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        this.testRule.getExecutionJobs(batch).forEach(job -> this.managementService.executeJob(job.getId()));
        historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        Assertions.assertThat(this.testRule.getExecutionJobs(batch)).isEmpty();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldUpdateProcessInstanceLast_Hierarchical() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        Batch batch = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).hierarchical().updateInChunks().chunkSize(100).executeAsync();
        this.testRule.executeSeedJobs(batch, true);
        this.testRule.getExecutionJobs(batch).forEach(job -> this.managementService.executeJob(job.getId()));
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.getExecutionJobs(batch).forEach(job -> this.managementService.executeJob(job.getId()));
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat(this.testRule.getExecutionJobs(batch)).isEmpty();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldCreateOneRemovalTimeJobPerProcessInstance() {
        this.engineConfiguration.setInvocationsPerBatchJob(3);
        BatchSetRemovalTimeRule.TestProcessBuilder process = this.testRule.process().userTask().deploy();
        process.start();
        process.start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync();
        this.testRule.executeSeedJobs(batch, true);
        Assertions.assertThat(this.testRule.getExecutionJobs(batch)).hasSize(2);
    }

    @Test
    public void shouldRejectChunkSize_Zero() {
        this.engineConfiguration.setRemovalTimeUpdateChunkSize(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineConfiguration.initBatchHandlers()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("chunk size should be between 1 and");
    }

    @Test
    public void shouldRejectChunkSize_Negative() {
        this.engineConfiguration.setRemovalTimeUpdateChunkSize(-5);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineConfiguration.initBatchHandlers()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("chunk size should be between 1 and");
    }

    @Test
    public void shouldRejectChunkSize_ExceedingLimit() {
        this.engineConfiguration.setRemovalTimeUpdateChunkSize(505);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineConfiguration.initBatchHandlers()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("chunk size should be between 1 and");
    }

    @Test
    public void shouldRejectCustomChunkSize_Zero() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyService.setRemovalTimeToHistoricProcessInstances();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.chunkSize(0)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("chunk size should be between 1 and");
    }

    @Test
    public void shouldRejectCustomChunkSize_Negative() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyService.setRemovalTimeToHistoricProcessInstances();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.chunkSize(-3)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("chunk size should be between 1 and");
    }

    @Test
    public void shouldRejectCustomChunkSize_ExceedingLimit() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyService.setRemovalTimeToHistoricProcessInstances();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.chunkSize(501)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("chunk size should be between 1 and");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionInstance() {
        this.testRule.process().ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionInputInstance() {
        this.testRule.process().ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionOutputInstance() {
        this.testRule.process().ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ProcessInstance() {
        this.testRule.process().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ActivityInstance() {
        this.testRule.process().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityName("userTask").singleResult();
        Assertions.assertThat((Date)historicActivityInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_TaskInstance() {
        this.testRule.process().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicTaskInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_HistoricTaskInstanceAuthorization() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        this.testRule.enableAuth();
        this.testRule.process().userTask().deploy().start();
        this.testRule.disableAuth();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Assertions.assertThat((Date)authorization.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldNotSetRemovalTime_HistoricTaskInstancePermissionsDisabled() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        this.testRule.enableAuth();
        this.testRule.process().userTask().deploy().start();
        this.testRule.disableAuth();
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(false);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Assertions.assertThat((Date)authorization.getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_HistoricProcessInstanceAuthorization() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        authorization.setResourceId(processInstanceId);
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, processInstanceId})});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{this.REMOVAL_TIME, processInstanceId, processInstanceId})});
    }

    @Test
    public void shouldNotSetRemovalTime_HistoricProcessInstancePermissionsDisabled() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(false);
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        authorization.setResourceId(processInstanceId);
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, processInstanceId})});
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, processInstanceId})});
    }

    @Test
    public void shouldSetRemovalTime_VariableInstance() {
        this.testRule.process().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue"));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicVariableInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_Detail() {
        this.testRule.process().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue"));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        Assertions.assertThat((Date)historicDetail.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ExternalTaskLog() {
        this.testRule.process().externalTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        HistoricExternalTaskLog historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getRemovalTime()).isNull();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ExternalTaskLog_WithPreservedCreateTime() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        this.testRule.process().externalTask().deploy().start();
        HistoricExternalTaskLog historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldSetRemovalTime_JobLog() {
        String processInstanceId = this.testRule.process().async().userTask().deploy().start();
        HistoricJobLog job = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).singleResult();
        Assertions.assertThat((Date)job.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        job = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId).singleResult();
        Assertions.assertThat((Date)job.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_Incident() {
        this.testRule.process().async().userTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_Incident_WithPreservedCreateTime() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        this.testRule.process().async().userTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getCreateTime()).isEqualTo((Object)this.CREATE_TIME);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        Assertions.assertThat((Date)historicIncident.getCreateTime()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldSetRemovalTime_OperationLog() {
        String processInstanceId = this.testRule.process().async().userTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_OperationLog_WithPreservedTimestamp() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        String processInstanceId = this.testRule.process().async().userTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getTimestamp()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldSetRemovalTime_IdentityLinkLog() {
        this.testRule.process().userTask().deploy().start();
        HistoricIdentityLinkLog identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_IdentityLinkLog_WithPreservedTime() {
        ClockUtil.setCurrentTime((Date)this.CREATE_TIME);
        this.testRule.process().userTask().deploy().start();
        HistoricIdentityLinkLog identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getTime()).isEqualTo((Object)this.CREATE_TIME);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getTime()).isEqualTo((Object)this.CREATE_TIME);
    }

    @Test
    public void shouldNotSetUnaffectedRemovalTime_IdentityLinkLog() {
        BatchSetRemovalTimeRule.TestProcessBuilder testProcessBuilder = this.testRule.process().userTask().deploy();
        String instance1 = testProcessBuilder.start();
        String instance2 = testProcessBuilder.start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query.processInstanceId(instance1)).updateInChunks().executeAsync());
        Task task2 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2).singleResult();
        HistoricIdentityLinkLog identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().taskId(task2.getId()).singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_CommentByTaskId() {
        this.testRule.process().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        this.taskService.createComment(taskId, null, "aComment");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_CommentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        this.taskService.createComment(null, processInstanceId, "aComment");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_AttachmentByTaskId() {
        this.testRule.process().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        Attachment attachment = this.taskService.createAttachment(null, taskId, null, null, null, "http://camunda.com");
        Assertions.assertThat((Date)attachment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        attachment = (Attachment)this.taskService.getTaskAttachments(taskId).get(0);
        Assertions.assertThat((Date)attachment.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_AttachmentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        Attachment attachment = this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com");
        Assertions.assertThat((Date)attachment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        attachment = (Attachment)this.taskService.getProcessInstanceAttachments(processInstanceId).get(0);
        Assertions.assertThat((Date)attachment.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_AttachmentByTaskId() {
        this.testRule.process().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, taskId, null, null, null, (InputStream)new ByteArrayInputStream("".getBytes()));
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(attachment.getContentId());
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(attachment.getContentId());
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_AttachmentByProcessInstanceId() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, null, processInstanceId, null, null, (InputStream)new ByteArrayInputStream("".getBytes()));
        String byteArrayId = attachment.getContentId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_Variable() {
        this.testRule.process().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)Variables.fileValue((String)"file.xml").file("<root />".getBytes())));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        String byteArrayId = ((HistoricVariableInstanceEntity)historicVariableInstance).getByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_JobLog() {
        this.testRule.process().async().scriptTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLog historicJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String byteArrayId = ((HistoricJobLogEventEntity)historicJobLog).getExceptionByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_ExternalTaskLog() {
        this.testRule.process().externalTask().deploy().start();
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("aTopicName", Integer.MAX_VALUE).execute().get(0)).getId();
        this.externalTaskService.handleFailure(externalTaskId, "aWorkerId", null, "errorDetails", 5, 3000L);
        HistoricExternalTaskLog externalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        String byteArrayId = ((HistoricExternalTaskLogEntity)externalTaskLog).getErrorDetailsByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTime_ByteArray_DecisionInputInstance() {
        this.testRule.process().ruleTask("testDecision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        String byteArrayId = ((HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTime_ByteArray_DecisionOutputInstance() {
        this.testRule.process().ruleTask("testDecision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        String byteArrayId = ((HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionInstance_Hierarchical() {
        this.testRule.process().call().passVars("temperature", "dayType").ruleTask("dish-decision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionInputInstance_Hierarchical() {
        this.testRule.process().call().passVars("temperature", "dayType").ruleTask("dish-decision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTime_DecisionOutputInstance_Hierarchical() {
        this.testRule.process().call().passVars("temperature", "dayType").ruleTask("dish-decision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Assertions.assertThat((Date)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ProcessInstance_Hierarchical() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ActivityInstance_Hierarchical() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityName("userTask").singleResult();
        Assertions.assertThat((Date)historicActivityInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityName("userTask").singleResult();
        Assertions.assertThat((Date)historicActivityInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_TaskInstance_Hierarchical() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicTaskInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicTaskInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_HistoricTaskInstanceAuthorization_Hierarchical() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        this.testRule.enableAuth();
        this.testRule.process().call().userTask().deploy().start();
        this.testRule.disableAuth();
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicTaskInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Assertions.assertThat((Date)authorization.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldNotSetRemovalTime_HistoricTaskInstancePermissionsDisabled_Hierarchical() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        this.testRule.enableAuth();
        this.testRule.process().call().userTask().deploy().start();
        this.testRule.disableAuth();
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(false);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Assertions.assertThat((Date)authorization.getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_HistoricProcessInstanceAuthorization_Hierarchical() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(true);
        String rootProcessInstanceId = this.testRule.process().call().userTask().deploy().start();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult()).getId();
        authorization.setResourceId(processInstanceId);
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, rootProcessInstanceId})});
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Date removalTime = BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{removalTime, processInstanceId, rootProcessInstanceId})});
    }

    @Test
    public void shouldNotSetRemovalTime_HistoricProcessInstancePermissionsDisabled_Hierarchical() {
        this.testRule.getProcessEngineConfiguration().setEnableHistoricInstancePermissions(false);
        String rootProcessInstanceId = this.testRule.process().call().userTask().deploy().start();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult()).getId();
        authorization.setResourceId(processInstanceId);
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, rootProcessInstanceId})});
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, rootProcessInstanceId})});
    }

    @Test
    public void shouldSetRemovalTime_VariableInstance_Hierarchical() {
        this.testRule.process().call().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue"));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicVariableInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicVariableInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_Detail_Hierarchical() {
        this.testRule.process().call().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue"));
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        Assertions.assertThat((Date)historicDetail.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        Assertions.assertThat((Date)historicDetail.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ExternalTaskLog_Hierarchical() {
        this.testRule.process().call().externalTask().deploy().start();
        HistoricExternalTaskLog historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicExternalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        Assertions.assertThat((Date)historicExternalTaskLog.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_JobLog_Hierarchical() {
        this.testRule.process().call().async().userTask().deploy().start();
        HistoricJobLog job = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processDefinitionKey("process").singleResult();
        Assertions.assertThat((Date)job.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        job = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().processDefinitionKey("process").singleResult();
        Assertions.assertThat((Date)job.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_Incident_Hierarchical() {
        String rootProcessInstanceId = this.testRule.process().call().async().userTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        String leafProcessInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstanceId).singleResult()).getId();
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().processInstanceId(leafProcessInstanceId).singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().processInstanceId(leafProcessInstanceId).singleResult();
        Assertions.assertThat((Date)historicIncident.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_OperationLog_Hierarchical() {
        String processInstanceId = this.testRule.process().call().async().userTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((Date)userOperationLog.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_IdentityLinkLog_Hierarchical() {
        this.testRule.process().call().userTask().deploy().start();
        HistoricIdentityLinkLog identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        identityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        Assertions.assertThat((Date)identityLinkLog.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_CommentByTaskId_Hierarchical() {
        this.testRule.process().call().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        this.taskService.createComment(taskId, null, "aComment");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)comment.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_CommentByProcessInstanceId_Hierarchical() {
        String processInstanceId = this.testRule.process().call().userTask().deploy().start();
        this.taskService.createComment(null, processInstanceId, "aComment");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)comment.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        Assertions.assertThat((Date)comment.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_AttachmentByTaskId_Hierarchical() {
        this.testRule.process().call().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        Attachment attachment = this.taskService.createAttachment(null, taskId, null, null, null, "http://camunda.com");
        Assertions.assertThat((Date)attachment.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        attachment = (Attachment)this.taskService.getTaskAttachments(taskId).get(0);
        Assertions.assertThat((Date)attachment.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_AttachmentByProcessInstanceId_Hierarchical() {
        String processInstanceId = this.testRule.process().call().userTask().deploy().start();
        Attachment attachment = this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com");
        Assertions.assertThat((Date)attachment.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        attachment = (Attachment)this.taskService.getProcessInstanceAttachments(processInstanceId).get(0);
        Assertions.assertThat((Date)attachment.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_AttachmentByTaskId_Hierarchical() {
        this.testRule.process().call().userTask().deploy().start();
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskName("userTask").singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, taskId, null, null, null, (InputStream)new ByteArrayInputStream("".getBytes()));
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(attachment.getContentId());
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(attachment.getContentId());
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_AttachmentByProcessInstanceId_Hierarchical() {
        String processInstanceId = this.testRule.process().call().userTask().deploy().start();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, null, processInstanceId, null, null, (InputStream)new ByteArrayInputStream("".getBytes()));
        String byteArrayId = attachment.getContentId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_Variable_Hierarchical() {
        this.testRule.process().call().userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("aVariableName", (Object)Variables.fileValue((String)"file.xml").file("<root />".getBytes())));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        String byteArrayId = ((HistoricVariableInstanceEntity)historicVariableInstance).getByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_JobLog_Hierarchical() {
        this.testRule.process().call().async().scriptTask().deploy().start();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLog historicJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String byteArrayId = ((HistoricJobLogEventEntity)historicJobLog).getExceptionByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByteArray_ExternalTaskLog_Hierarchical() {
        this.testRule.process().call().externalTask().deploy().start();
        String externalTaskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("aTopicName", Integer.MAX_VALUE).execute().get(0)).getId();
        this.externalTaskService.handleFailure(externalTaskId, "aWorkerId", null, "errorDetails", 5, 3000L);
        HistoricExternalTaskLog externalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        String byteArrayId = ((HistoricExternalTaskLogEntity)externalTaskLog).getErrorDetailsByteArrayId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTime_ByteArray_DecisionInputInstance_Hierarchical() {
        this.testRule.process().call().passVars("pojo").ruleTask("testDecision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        String byteArrayId = ((HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldSetRemovalTime_ByteArray_DecisionOutputInstance_Hierarchical() {
        this.testRule.process().call().passVars("pojo").ruleTask("testDecision").userTask().deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        String byteArrayId = ((HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0)).getByteArrayValueId();
        ByteArrayEntity byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().updateInChunks().executeAsync());
        byteArrayEntity = this.testRule.findByteArrayById(byteArrayId);
        Assertions.assertThat((Date)byteArrayEntity.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }
}

