/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Date;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.event.HistoricJobLogEvent;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupRemovalTime;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.camunda.bpm.engine.test.util.EntityRemoveRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.RemoveAfter;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupByteArrayRemovalTest {
    private ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(config -> {
        config.setHistoryRemovalTimeStrategy("end").setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)new DefaultHistoryRemovalTimeProvider()).initHistoryRemovalTime();
        config.setHistoryCleanupStrategy("removalTimeBased");
        config.setHistoryCleanupBatchSize(500);
        config.setHistoryCleanupBatchWindowStartTime(null);
        config.setHistoryCleanupDegreeOfParallelism(1);
        config.setBatchOperationHistoryTimeToLive(null);
        config.setBatchOperationsForHistoryCleanup(null);
        config.setHistoryTimeToLive(null);
        config.setTaskMetricsEnabled(false);
        config.setTaskMetricsTimeToLive(null);
        config.initHistoryCleanup();
    });
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected EntityRemoveRule entityRemoveRule = EntityRemoveRule.ofLazyRule(() -> this.testRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.entityRemoveRule);
    private ManagementService managementService;
    private HistoryService historyService;
    private ProcessEngineConfigurationImpl engineConfiguration;

    @Before
    public void init() {
        ProcessEngine processEngine = this.bootstrapRule.getProcessEngine();
        this.managementService = processEngine.getManagementService();
        this.historyService = processEngine.getHistoryService();
        this.engineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() {
        this.restoreCleanupJobHandler();
        this.testRule.deleteHistoryCleanupJobs();
    }

    @Test
    @RemoveAfter
    public void shouldHaveRemovalTimeOnFailingHistoryCleanupJob() {
        this.engineConfiguration.setHistoryCleanupJobLogTimeToLive("1");
        this.overrideFailingCleanupJobHandler();
        try {
            this.runHistoryCleanup();
            Assertions.fail((String)"This test should fail during history cleanup and not reach this point");
        }
        catch (Exception e) {
            HistoricJobLogEvent event = this.getLastFailingHistoryCleanupJobEvent();
            String exceptionByteArrayId = event.getExceptionByteArrayId();
            ByteArrayEntity byteArray = this.findByteArrayById(exceptionByteArrayId);
            Assertions.assertThat((Object)byteArray).isNotNull();
            Assertions.assertThat((Date)byteArray.getRemovalTime()).isNotNull();
        }
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId) {
        return (ByteArrayEntity)this.engineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayId));
    }

    protected void restoreCleanupJobHandler() {
        this.engineConfiguration.getJobHandlers().put("history-cleanup", new HistoryCleanupJobHandler());
    }

    protected void overrideFailingCleanupJobHandler() {
        this.engineConfiguration.getJobHandlers().put("history-cleanup", new FailingHistoryCleanupJobHandler());
    }

    protected void runHistoryCleanup() {
        this.historyService.cleanUpHistoryAsync(true);
        this.historyService.findHistoryCleanupJobs().forEach(job -> this.managementService.executeJob(job.getId()));
    }

    protected HistoricJobLogEvent getLastFailingHistoryCleanupJobEvent() {
        return (HistoricJobLogEvent)this.historyService.createHistoricJobLogQuery().failureLog().jobDefinitionType("history-cleanup").singleResult();
    }

    static class FailingHistoryCleanupJobHandler
    extends HistoryCleanupJobHandler {
        FailingHistoryCleanupJobHandler() {
        }

        protected HistoryCleanupRemovalTime getTimeBasedHandler() {
            return new FailingProcessCleanupRemovalTime();
        }

        static class FailingProcessCleanupRemovalTime
        extends HistoryCleanupRemovalTime {
            FailingProcessCleanupRemovalTime() {
            }

            protected Map<Class<? extends DbEntity>, DbOperation> performProcessCleanup() {
                throw new RuntimeException("This operation is always failing!");
            }
        }
    }
}

