/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.history.removaltime.cleanup.AbstractHistoryCleanupSchedulerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupSchedulerTaskInstancesTest
extends AbstractHistoryCleanupSchedulerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> HistoryCleanupSchedulerTaskInstancesTest.configure(configuration, HistoryEventTypes.TASK_INSTANCE_CREATE));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected final String PROCESS_KEY = "process";
    protected final BpmnModelInstance PROCESS = ((MultiInstanceLoopCharacteristicsBuilder)((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().userTask("userTask").name("userTask")).multiInstance().cardinality("5")).multiInstanceDone().endEvent().done();
    protected final Date END_DATE = new GregorianCalendar(2013, 2, 18, 13, 0, 0).getTime();

    @Before
    public void init() {
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.initEngineConfiguration(engineConfiguration);
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void shouldScheduleToNow() {
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        engineConfiguration.setHistoryCleanupBatchSize(5);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)removalTime);
    }

    @Test
    public void shouldScheduleToLater() {
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        engineConfiguration.setHistoryCleanupBatchSize(6);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)DateUtils.addSeconds((Date)removalTime, (int)10));
    }
}

