/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.test.api.identity.TestPermissions;
import org.camunda.bpm.engine.test.api.identity.TestResource;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthorizationQueryTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        this.createAuthorization("user1", null, resource1, "resource1-1", TestPermissions.ACCESS);
        this.createAuthorization("user1", null, resource2, "resource2-1", TestPermissions.DELETE);
        this.createAuthorization("user2", null, resource1, "resource1-2", new Permission[0]);
        this.createAuthorization("user3", null, resource2, "resource2-1", TestPermissions.READ, TestPermissions.UPDATE);
        this.createAuthorization(null, "group1", resource1, "resource1-1", new Permission[0]);
        this.createAuthorization(null, "group1", resource1, "resource1-2", TestPermissions.UPDATE);
        this.createAuthorization(null, "group2", resource2, "resource2-2", TestPermissions.READ, TestPermissions.UPDATE);
        this.createAuthorization(null, "group3", resource2, "resource2-3", TestPermissions.DELETE);
    }

    @After
    public void tearDown() throws Exception {
        List list = this.authorizationService.createAuthorizationQuery().list();
        for (Authorization authorization : list) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    protected void createAuthorization(String userId, String groupId, Resource resourceType, String resourceId, Permission ... permissions) {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(userId);
        authorization.setGroupId(groupId);
        authorization.setResource(resourceType);
        authorization.setResourceId(resourceId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.authorizationService.saveAuthorization(authorization);
    }

    @Test
    public void testValidQueryCounts() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        NonExistingResource nonExisting = new NonExistingResource("non-existing", 102);
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user2"}).count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user3"}).count());
        Assert.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1", "user2"}).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"non-existing"}).count());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1"}).count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group2"}).count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group3"}).count());
        Assert.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1", "group2"}).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"non-existing"}).count());
        Assert.assertEquals((long)4L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)resource1).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)nonExisting).count());
        Assert.assertEquals((long)4L, (long)this.authorizationService.createAuthorizationQuery().resourceType(resource1.resourceType()).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType(nonExisting.resourceType()).count());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().resourceId("resource1-2").count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceId("non-existing").count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.ACCESS).count());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.DELETE).count());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.READ).count());
        Assert.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.UPDATE).count());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.READ).hasPermission((Permission)TestPermissions.UPDATE).count());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.UPDATE).hasPermission((Permission)TestPermissions.READ).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.READ).hasPermission((Permission)TestPermissions.ACCESS).count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).resourceType((Resource)resource1).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).resourceType((Resource)nonExisting).count());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group2"}).resourceType((Resource)resource2).count());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1"}).resourceType((Resource)nonExisting).count());
    }

    @Test
    public void testValidQueryLists() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        NonExistingResource nonExisting = new NonExistingResource("non-existing", 102);
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).list().size());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user2"}).list().size());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user3"}).list().size());
        Assert.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1", "user2"}).list().size());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"non-existing"}).list().size());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1"}).list().size());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group2"}).list().size());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group3"}).list().size());
        Assert.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1", "group2"}).list().size());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"non-existing"}).list().size());
        Assert.assertEquals((long)4L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)resource1).list().size());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceType((Resource)nonExisting).list().size());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().resourceId("resource1-2").list().size());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().resourceId("non-existing").list().size());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.ACCESS).list().size());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.DELETE).list().size());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.READ).list().size());
        Assert.assertEquals((long)3L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.UPDATE).list().size());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.READ).hasPermission((Permission)TestPermissions.UPDATE).list().size());
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.UPDATE).hasPermission((Permission)TestPermissions.READ).list().size());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().hasPermission((Permission)TestPermissions.READ).hasPermission((Permission)TestPermissions.ACCESS).list().size());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).resourceType((Resource)resource1).list().size());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"user1"}).resourceType((Resource)nonExisting).list().size());
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group2"}).resourceType((Resource)resource2).list().size());
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"group1"}).resourceType((Resource)nonExisting).list().size());
    }

    @Test
    public void testOrderByQueries() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        List list = ((AuthorizationQuery)this.authorizationService.createAuthorizationQuery().orderByResourceType().asc()).list();
        Assert.assertEquals((long)resource1.resourceType(), (long)((Authorization)list.get(0)).getResourceType());
        Assert.assertEquals((long)resource1.resourceType(), (long)((Authorization)list.get(1)).getResourceType());
        Assert.assertEquals((long)resource1.resourceType(), (long)((Authorization)list.get(2)).getResourceType());
        Assert.assertEquals((long)resource1.resourceType(), (long)((Authorization)list.get(3)).getResourceType());
        Assert.assertEquals((long)resource2.resourceType(), (long)((Authorization)list.get(4)).getResourceType());
        Assert.assertEquals((long)resource2.resourceType(), (long)((Authorization)list.get(5)).getResourceType());
        Assert.assertEquals((long)resource2.resourceType(), (long)((Authorization)list.get(6)).getResourceType());
        Assert.assertEquals((long)resource2.resourceType(), (long)((Authorization)list.get(7)).getResourceType());
        list = ((AuthorizationQuery)this.authorizationService.createAuthorizationQuery().orderByResourceType().desc()).list();
        Assert.assertEquals((long)resource2.resourceType(), (long)((Authorization)list.get(0)).getResourceType());
        Assert.assertEquals((long)resource2.resourceType(), (long)((Authorization)list.get(1)).getResourceType());
        Assert.assertEquals((long)resource2.resourceType(), (long)((Authorization)list.get(2)).getResourceType());
        Assert.assertEquals((long)resource2.resourceType(), (long)((Authorization)list.get(3)).getResourceType());
        Assert.assertEquals((long)resource1.resourceType(), (long)((Authorization)list.get(4)).getResourceType());
        Assert.assertEquals((long)resource1.resourceType(), (long)((Authorization)list.get(5)).getResourceType());
        Assert.assertEquals((long)resource1.resourceType(), (long)((Authorization)list.get(6)).getResourceType());
        Assert.assertEquals((long)resource1.resourceType(), (long)((Authorization)list.get(7)).getResourceType());
        list = ((AuthorizationQuery)this.authorizationService.createAuthorizationQuery().orderByResourceId().asc()).list();
        Assert.assertEquals((Object)"resource1-1", (Object)((Authorization)list.get(0)).getResourceId());
        Assert.assertEquals((Object)"resource1-1", (Object)((Authorization)list.get(1)).getResourceId());
        Assert.assertEquals((Object)"resource1-2", (Object)((Authorization)list.get(2)).getResourceId());
        Assert.assertEquals((Object)"resource1-2", (Object)((Authorization)list.get(3)).getResourceId());
        Assert.assertEquals((Object)"resource2-1", (Object)((Authorization)list.get(4)).getResourceId());
        Assert.assertEquals((Object)"resource2-1", (Object)((Authorization)list.get(5)).getResourceId());
        Assert.assertEquals((Object)"resource2-2", (Object)((Authorization)list.get(6)).getResourceId());
        Assert.assertEquals((Object)"resource2-3", (Object)((Authorization)list.get(7)).getResourceId());
        list = ((AuthorizationQuery)this.authorizationService.createAuthorizationQuery().orderByResourceId().desc()).list();
        Assert.assertEquals((Object)"resource2-3", (Object)((Authorization)list.get(0)).getResourceId());
        Assert.assertEquals((Object)"resource2-2", (Object)((Authorization)list.get(1)).getResourceId());
        Assert.assertEquals((Object)"resource2-1", (Object)((Authorization)list.get(2)).getResourceId());
        Assert.assertEquals((Object)"resource2-1", (Object)((Authorization)list.get(3)).getResourceId());
        Assert.assertEquals((Object)"resource1-2", (Object)((Authorization)list.get(4)).getResourceId());
        Assert.assertEquals((Object)"resource1-2", (Object)((Authorization)list.get(5)).getResourceId());
        Assert.assertEquals((Object)"resource1-1", (Object)((Authorization)list.get(6)).getResourceId());
        Assert.assertEquals((Object)"resource1-1", (Object)((Authorization)list.get(7)).getResourceId());
    }

    @Test
    public void testInvalidOrderByQueries() {
        try {
            this.authorizationService.createAuthorizationQuery().orderByResourceType().list();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Invalid query: call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.authorizationService.createAuthorizationQuery().orderByResourceId().list();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Invalid query: call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.authorizationService.createAuthorizationQuery().orderByResourceId().orderByResourceType().list();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Invalid query: call asc() or desc() after using orderByXX()", e.getMessage());
        }
        try {
            this.authorizationService.createAuthorizationQuery().orderByResourceType().orderByResourceId().list();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Invalid query: call asc() or desc() after using orderByXX()", e.getMessage());
        }
    }

    @Test
    public void testInvalidQueries() {
        try {
            this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"a"}).userIdIn(new String[]{"b"}).count();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot query for user and group authorizations at the same time.", e.getMessage());
        }
        try {
            this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"b"}).groupIdIn(new String[]{"a"}).count();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot query for user and group authorizations at the same time.", e.getMessage());
        }
    }

    class NonExistingResource
    implements Resource {
        protected int id;
        protected String name;

        public NonExistingResource(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String resourceName() {
            return this.name;
        }

        public int resourceType() {
            return this.id;
        }
    }
}

