/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyTaskCountByCandidateGroupTest {
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule processEngineTestRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineTestRule).around((TestRule)this.processEngineRule);
    protected TaskService taskService;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected String userId = "aUser";
    protected String groupId = "aGroup";
    protected String tenantId = "aTenant";
    protected String anotherTenantId = "anotherTenant";
    protected List<String> taskIds = new ArrayList<String>();

    @Before
    public void setUp() {
        this.taskService = this.processEngineRule.getTaskService();
        this.identityService = this.processEngineRule.getIdentityService();
        this.authorizationService = this.processEngineRule.getAuthorizationService();
        this.processEngineConfiguration = this.processEngineRule.getProcessEngineConfiguration();
        this.createTask(this.groupId, this.tenantId);
        this.createTask(this.groupId, this.anotherTenantId);
        this.createTask(this.groupId, this.anotherTenantId);
        this.processEngineConfiguration.setTenantCheckEnabled(true);
    }

    @After
    public void cleanUp() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        for (String taskId : this.taskIds) {
            this.taskService.deleteTask(taskId, true);
        }
    }

    @Test
    public void shouldOnlyShowTenantSpecificTasks() {
        this.identityService.setAuthentication(this.userId, null, Collections.singletonList(this.tenantId));
        List results = this.taskService.createTaskReport().taskCountByCandidateGroup();
        Assert.assertEquals((long)1L, (long)results.size());
    }

    protected void createTask(String groupId, String tenantId) {
        Task task = this.taskService.newTask();
        task.setTenantId(tenantId);
        this.taskService.saveTask(task);
        if (groupId != null) {
            this.taskService.addCandidateGroup(task.getId(), groupId);
            this.taskIds.add(task.getId());
        }
    }
}

