/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricBatchQueryTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain defaultRuleChin = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected BatchMigrationHelper batchHelper = new BatchMigrationHelper(this.engineRule);
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected Batch sharedBatch;
    protected Batch tenant1Batch;
    protected Batch tenant2Batch;

    @Before
    public void initServices() {
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Before
    public void deployProcesses() {
        ProcessDefinition sharedDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant1Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant2Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_TWO, ProcessModels.ONE_TASK_PROCESS);
        this.sharedBatch = this.batchHelper.migrateProcessInstanceAsync(sharedDefinition, sharedDefinition);
        this.tenant1Batch = this.batchHelper.migrateProcessInstanceAsync(tenant1Definition, tenant1Definition);
        this.tenant2Batch = this.batchHelper.migrateProcessInstanceAsync(tenant2Definition, tenant2Definition);
    }

    @After
    public void removeBatches() {
        this.batchHelper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testHistoricBatchQueryNoAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, null);
        List batches = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertEquals((Object)this.sharedBatch.getId(), (Object)((HistoricBatch)batches.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricBatchQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testHistoricBatchQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        List batches = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)2L, (long)batches.size());
        this.assertBatches(batches, this.tenant1Batch.getId(), this.sharedBatch.getId());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricBatchQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testHistoricBatchQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        List batches = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)3L, (long)batches.size());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricBatchQuery().count());
        this.identityService.clearAuthentication();
    }

    @Test
    public void testDeleteHistoricBatch() {
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        this.historyService.deleteHistoricBatch(this.tenant1Batch.getId());
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricBatchQuery().count());
    }

    @Test
    public void testDeleteHistoricBatchFailsWithWrongTenant() {
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        try {
            this.historyService.deleteHistoricBatch(this.tenant2Batch.getId());
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot delete historic batch '" + this.tenant2Batch.getId() + "' because it belongs to no authenticated tenant"});
        }
        this.identityService.clearAuthentication();
    }

    @Test
    public void testHistoricBatchQueryFilterByTenant() {
        HistoricBatch returnedBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Assert.assertNotNull((Object)returnedBatch);
        Assert.assertEquals((Object)this.tenant1Batch.getId(), (Object)returnedBatch.getId());
    }

    @Test
    public void testHistoricBatchQueryFilterByTenants() {
        List returnedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertEquals((long)2L, (long)returnedBatches.size());
        Assert.assertEquals((Object)this.tenant1Batch.getId(), (Object)((HistoricBatch)returnedBatches.get(0)).getId());
        Assert.assertEquals((Object)this.tenant2Batch.getId(), (Object)((HistoricBatch)returnedBatches.get(1)).getId());
    }

    @Test
    public void testHistoricBatchQueryFilterWithoutTenantId() {
        HistoricBatch returnedBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().withoutTenantId().singleResult();
        Assert.assertNotNull((Object)returnedBatch);
        Assert.assertEquals((Object)this.sharedBatch.getId(), (Object)returnedBatch.getId());
    }

    @Test
    public void testBatchQueryFailOnNullTenantIdCase1() {
        String[] tenantIds = null;
        try {
            this.historyService.createHistoricBatchQuery().tenantIdIn(tenantIds);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testBatchQueryFailOnNullTenantIdCase2() {
        String[] tenantIds = new String[]{null};
        try {
            this.historyService.createHistoricBatchQuery().tenantIdIn(tenantIds);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testOrderByTenantIdAsc() {
        List orderedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().orderByTenantId().asc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.historicBatchByTenantId());
    }

    @Test
    public void testOrderByTenantIdDesc() {
        List orderedBatches = ((HistoricBatchQuery)this.historyService.createHistoricBatchQuery().orderByTenantId().desc()).list();
        TestOrderingUtil.verifySorting(orderedBatches, TestOrderingUtil.inverted(TestOrderingUtil.historicBatchByTenantId()));
    }

    protected void assertBatches(List<HistoricBatch> actualBatches, String ... expectedIds) {
        Assert.assertEquals((long)expectedIds.length, (long)actualBatches.size());
        HashSet<String> actualIds = new HashSet<String>();
        for (HistoricBatch batch : actualBatches) {
            actualIds.add(batch.getId());
        }
        for (String expectedId : expectedIds) {
            Assert.assertTrue((boolean)actualIds.contains(expectedId));
        }
    }
}

