/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricIdentityLinkLogQueryTest {
    private static final String GROUP_1 = "Group1";
    private static final String USER_1 = "User1";
    private static String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected static final String A_USER_ID = "aUserId";
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_1 = "tenant1";
    protected static final String TENANT_2 = "tenant2";
    protected static final String TENANT_3 = "tenant3";

    @Before
    public void init() {
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        BpmnModelInstance oneTaskProcess = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("task").camundaCandidateUsers(A_USER_ID)).endEvent().done();
        this.testRule.deployForTenant(TENANT_NULL, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_1, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_2, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_3, oneTaskProcess);
    }

    @Test
    public void shouldAddAndDeleteHistoricIdentityLinkForSingleTenant() {
        this.startProcessInstanceForTenant(TENANT_1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        HistoricIdentityLinkLog historicIdentityLink = (HistoricIdentityLinkLog)query.singleResult();
        this.taskService.deleteCandidateUser(historicIdentityLink.getTaskId(), A_USER_ID);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_1}).count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        this.startProcessInstanceForTenant(TENANT_NULL);
        this.startProcessInstanceForTenant(TENANT_1);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldAddHistoricIdentityLinkForMultipleTenants() {
        this.startProcessInstanceForTenant(TENANT_1);
        this.startProcessInstanceForTenant(TENANT_2);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assertions.assertThat((int)query.list().size()).isEqualTo(2);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_1}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_2}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldAddAndRemoveHistoricIdentityLinksForProcessDefinitionWithTenantId() throws Exception {
        String resourceName = "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml";
        this.testRule.deployForTenant(TENANT_1, resourceName);
        this.testRule.deployForTenant(TENANT_2, resourceName);
        ProcessDefinition processDefinition1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list().get(0);
        ProcessDefinition processDefinition2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list().get(1);
        Assertions.assertThat((Object)processDefinition1).isNotNull();
        Assertions.assertThat((Object)processDefinition2).isNotNull();
        this.createIdentityLinks(processDefinition1.getId());
        this.createIdentityLinks(processDefinition2.getId());
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(8L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_1}).count()).isEqualTo(4L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_2}).count()).isEqualTo(4L);
    }

    @Test
    public void shouldAddIdentityLinksForProcessDefinitionWithTenantId() throws Exception {
        String resourceName = "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml";
        this.testRule.deployForTenant(TENANT_1, resourceName);
        this.testRule.deployForTenant(TENANT_2, resourceName);
        ProcessDefinition processDefinition1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list().get(0);
        ProcessDefinition processDefinition2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).list().get(1);
        Assertions.assertThat((Object)processDefinition1).isNotNull();
        Assertions.assertThat((Object)processDefinition2).isNotNull();
        this.addIdentityLinks(processDefinition1.getId());
        this.addIdentityLinks(processDefinition2.getId());
        List identityLinks = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition1.getId());
        Assertions.assertThat((int)identityLinks.size()).isEqualTo(2);
        Assertions.assertThat((String)((IdentityLink)identityLinks.get(0)).getTenantId()).isEqualTo((Object)TENANT_1);
        Assertions.assertThat((String)((IdentityLink)identityLinks.get(1)).getTenantId()).isEqualTo((Object)TENANT_1);
        identityLinks = this.repositoryService.getIdentityLinksForProcessDefinition(processDefinition2.getId());
        Assertions.assertThat((int)identityLinks.size()).isEqualTo(2);
        Assertions.assertThat((String)((IdentityLink)identityLinks.get(0)).getTenantId()).isEqualTo((Object)TENANT_2);
        Assertions.assertThat((String)((IdentityLink)identityLinks.get(1)).getTenantId()).isEqualTo((Object)TENANT_2);
    }

    @Test
    public void shouldUseSingleQueryForMultipleTenants() {
        this.startProcessInstanceForTenant(TENANT_NULL);
        this.startProcessInstanceForTenant(TENANT_1);
        this.startProcessInstanceForTenant(TENANT_2);
        this.startProcessInstanceForTenant(TENANT_3);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_1, TENANT_2}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_2, TENANT_3}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_1, TENANT_2, TENANT_3}).count()).isEqualTo(3L);
    }

    protected void createIdentityLinks(String processDefinitionId) {
        this.addIdentityLinks(processDefinitionId);
        this.deleteIdentityLinks(processDefinitionId);
    }

    protected void addIdentityLinks(String processDefinitionId) {
        this.repositoryService.addCandidateStarterGroup(processDefinitionId, GROUP_1);
        this.repositoryService.addCandidateStarterUser(processDefinitionId, USER_1);
    }

    protected void deleteIdentityLinks(String processDefinitionId) {
        this.repositoryService.deleteCandidateStarterGroup(processDefinitionId, GROUP_1);
        this.repositoryService.deleteCandidateStarterUser(processDefinitionId, USER_1);
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant) {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(tenant).execute();
    }
}

