/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="activity")
public class MultiTenancyHistoricTaskInstanceQueryTest {
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();
        this.testRule.deployForTenant(TENANT_NULL, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_ONE, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_TWO, oneTaskProcess);
        ProcessInstance processInstanceNull = this.startProcessInstanceForTenant(TENANT_NULL);
        ProcessInstance processInstanceOne = this.startProcessInstanceForTenant(TENANT_ONE);
        ProcessInstance processInstanceTwo = this.startProcessInstanceForTenant(TENANT_TWO);
        this.completeUserTask(processInstanceNull);
        this.completeUserTask(processInstanceOne);
        this.completeUserTask(processInstanceTwo);
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricTaskInstanceQuery queryTenantOne = this.historyService.createHistoricTaskInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        HistoricTaskInstanceQuery queryTenantTwo = this.historyService.createHistoricTaskInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)queryTenantOne.count()).isEqualTo(1L);
        Assertions.assertThat((long)queryTenantTwo.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryFilterWithoutTenantId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricTaskInstanceQuery().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicTaskInstances.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicTaskInstances, TestOrderingUtil.historicTaskInstanceByTenantId());
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicTaskInstances.size()).isEqualTo(3);
        TestOrderingUtil.verifySorting(historicTaskInstances, TestOrderingUtil.inverted(TestOrderingUtil.historicTaskInstanceByTenantId()));
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant) {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(tenant).execute();
    }

    protected void completeUserTask(ProcessInstance processInstance) {
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)task).isNotNull();
        this.taskService.complete(task.getId());
    }
}

