/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyCleanableHistoricCaseInstanceReportCmdTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    private static final String CASE_DEFINITION_KEY = "one";
    protected static final String CMMN_MODEL = "org/camunda/bpm/engine/test/repository/one.cmmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected CaseService caseService;
    protected HistoryService historyService;
    protected String caseDefinitionId;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.caseService = this.engineRule.getCaseService();
        this.historyService = this.engineRule.getHistoryService();
    }

    private void prepareCaseInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount, String tenantId) {
        List caseDefinitions = null;
        caseDefinitions = tenantId != null ? this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).tenantIdIn(new String[]{tenantId}).list() : this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(key).withoutTenantId().list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)daysInThePast));
        for (int i = 0; i < instanceCount; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceById(((CaseDefinition)caseDefinitions.get(0)).getId());
            if (tenantId != null) {
                Assert.assertEquals((Object)tenantId, (Object)caseInstance.getTenantId());
            }
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    public void testReportNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.identityService.setAuthentication("user", null, null);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)0L, (long)reportResults.size());
    }

    @Test
    public void testReportWithAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricCaseInstanceReportResult)reportResults.get(0)).getTenantId());
    }

    @Test
    public void testReportDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().list();
        Assert.assertEquals((long)2L, (long)reportResults.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricCaseInstanceReportResult)reportResults.get(0)).getTenantId());
        Assert.assertEquals((Object)TENANT_TWO, (Object)((CleanableHistoricCaseInstanceReportResult)reportResults.get(1)).getTenantId());
    }

    @Test
    public void testReportTenantIdInNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        List reportResultsOne = this.historyService.createCleanableHistoricCaseInstanceReport().tenantIdIn(new String[]{TENANT_ONE}).list();
        List reportResultsTwo = this.historyService.createCleanableHistoricCaseInstanceReport().tenantIdIn(new String[]{TENANT_TWO}).list();
        Assert.assertEquals((long)0L, (long)reportResultsOne.size());
        Assert.assertEquals((long)0L, (long)reportResultsTwo.size());
    }

    @Test
    public void testReportTenantIdInWithAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_TWO);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List reportResultsOne = this.historyService.createCleanableHistoricCaseInstanceReport().tenantIdIn(new String[]{TENANT_ONE}).list();
        List reportResultsTwo = this.historyService.createCleanableHistoricCaseInstanceReport().tenantIdIn(new String[]{TENANT_TWO}).list();
        Assert.assertEquals((long)1L, (long)reportResultsOne.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricCaseInstanceReportResult)reportResultsOne.get(0)).getTenantId());
        Assert.assertEquals((long)0L, (long)reportResultsTwo.size());
    }

    @Test
    public void testReportTenantIdInDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.testRule.deployForTenant(TENANT_TWO, CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_TWO);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        List reportResultsOne = this.historyService.createCleanableHistoricCaseInstanceReport().tenantIdIn(new String[]{TENANT_ONE}).list();
        List reportResultsTwo = this.historyService.createCleanableHistoricCaseInstanceReport().tenantIdIn(new String[]{TENANT_TWO}).list();
        Assert.assertEquals((long)1L, (long)reportResultsOne.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricCaseInstanceReportResult)reportResultsOne.get(0)).getTenantId());
        Assert.assertEquals((long)1L, (long)reportResultsTwo.size());
        Assert.assertEquals((Object)TENANT_TWO, (Object)((CleanableHistoricCaseInstanceReportResult)reportResultsTwo.get(0)).getTenantId());
    }

    @Test
    public void testReportWithoutTenantId() {
        this.testRule.deploy(CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, null);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().withoutTenantId().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals(null, (Object)((CleanableHistoricCaseInstanceReportResult)reportResults.get(0)).getTenantId());
    }

    @Test
    public void testReportTenantIdInWithoutTenantId() {
        this.testRule.deploy(CMMN_MODEL);
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, null);
        this.prepareCaseInstances(CASE_DEFINITION_KEY, -6, 5, 10, TENANT_ONE);
        List reportResults = this.historyService.createCleanableHistoricCaseInstanceReport().withoutTenantId().list();
        List reportResultsOne = this.historyService.createCleanableHistoricCaseInstanceReport().tenantIdIn(new String[]{TENANT_ONE}).list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals(null, (Object)((CleanableHistoricCaseInstanceReportResult)reportResults.get(0)).getTenantId());
        Assert.assertEquals((long)1L, (long)reportResultsOne.size());
        Assert.assertEquals((Object)TENANT_ONE, (Object)((CleanableHistoricCaseInstanceReportResult)reportResultsOne.get(0)).getTenantId());
    }
}

