/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyIdentityLinkCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected static final BpmnModelInstance ONE_TASK_PROCESS = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected TaskService taskService;
    protected IdentityService identityService;
    protected Task task;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.testRule.deployForTenant(TENANT_ONE, ONE_TASK_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getId();
        this.task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void setAssigneeForTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.setAssignee(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskAssignee("demo").count()).isEqualTo(1L);
    }

    @Test
    public void setAssigneeForTaskWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.setAssignee(this.task.getId(), "demo")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void setAssigneeForTaskWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.setAssignee(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskAssignee("demo").count()).isEqualTo(1L);
    }

    @Test
    public void setOwnerForTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.setOwner(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskOwner("demo").count()).isEqualTo(1L);
    }

    @Test
    public void setOwnerForTaskWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.setOwner(this.task.getId(), "demo")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void setOwnerForTaskWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.setOwner(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskOwner("demo").count()).isEqualTo(1L);
    }

    @Test
    public void getIdentityLinkWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.setOwner(this.task.getId(), "demo");
        Assertions.assertThat((String)((IdentityLink)this.taskService.getIdentityLinksForTask(this.task.getId()).get(0)).getType()).isEqualTo((Object)"owner");
    }

    @Test
    public void getIdentityLinkWitNoAuthenticatedTenant() {
        this.taskService.setOwner(this.task.getId(), "demo");
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.getIdentityLinksForTask(this.task.getId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void getIdentityLinkWithDisabledTenantCheck() {
        this.taskService.setOwner(this.task.getId(), "demo");
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        Assertions.assertThat((String)((IdentityLink)this.taskService.getIdentityLinksForTask(this.task.getId()).get(0)).getType()).isEqualTo((Object)"owner");
    }

    @Test
    public void addCandidateUserWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.addCandidateUser(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateUser("demo").count()).isEqualTo(1L);
    }

    @Test
    public void addCandidateUserWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.addCandidateUser(this.task.getId(), "demo")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void addCandidateUserWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.addCandidateUser(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateUser("demo").count()).isEqualTo(1L);
    }

    @Test
    public void addCandidateGroupWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.addCandidateGroup(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(1L);
    }

    @Test
    public void addCandidateGroupWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.addCandidateGroup(this.task.getId(), "demo")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void addCandidateGroupWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.addCandidateGroup(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(1L);
    }

    @Test
    public void deleteCandidateUserWithAuthenticatedTenant() {
        this.taskService.addCandidateUser(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateUser("demo").count()).isEqualTo(1L);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.deleteCandidateUser(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateUser("demo").count()).isEqualTo(0L);
    }

    @Test
    public void deleteCandidateUserWithNoAuthenticatedTenant() {
        this.taskService.addCandidateUser(this.task.getId(), "demo");
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.deleteCandidateUser(this.task.getId(), "demo")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void deleteCandidateUserWithDisabledTenantCheck() {
        this.taskService.addCandidateUser(this.task.getId(), "demo");
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.deleteCandidateUser(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateUser("demo").count()).isEqualTo(0L);
    }

    @Test
    public void deleteCandidateGroupWithAuthenticatedTenant() {
        this.taskService.addCandidateGroup(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(1L);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.deleteCandidateGroup(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(0L);
    }

    @Test
    public void deleteCandidateGroupWithNoAuthenticatedTenant() {
        this.taskService.addCandidateGroup(this.task.getId(), "demo");
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.deleteCandidateGroup(this.task.getId(), "demo")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void deleteCandidateGroupWithDisabledTenantCheck() {
        this.taskService.addCandidateGroup(this.task.getId(), "demo");
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.deleteCandidateGroup(this.task.getId(), "demo");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(0L);
    }

    @Test
    public void addUserIdentityLinkWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.addUserIdentityLink(this.task.getId(), "demo", "candidate");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateUser("demo").count()).isEqualTo(1L);
    }

    @Test
    public void addUserIdentityLinkWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.addUserIdentityLink(this.task.getId(), "demo", "candidate")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void addUserIdentityLinkWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.addUserIdentityLink(this.task.getId(), "demo", "assignee");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskAssignee("demo").count()).isEqualTo(1L);
    }

    @Test
    public void addGroupIdentityLinkWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.addGroupIdentityLink(this.task.getId(), "demo", "candidate");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(1L);
    }

    @Test
    public void addGroupIdentityLinkWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.addGroupIdentityLink(this.task.getId(), "demo", "candidate")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void addGroupIdentityLinkWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.addGroupIdentityLink(this.task.getId(), "demo", "candidate");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(1L);
    }

    @Test
    public void deleteUserIdentityLinkWithAuthenticatedTenant() {
        this.taskService.addUserIdentityLink(this.task.getId(), "demo", "assignee");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskAssignee("demo").count()).isEqualTo(1L);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.deleteUserIdentityLink(this.task.getId(), "demo", "assignee");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskAssignee("demo").count()).isEqualTo(0L);
    }

    @Test
    public void deleteUserIdentityLinkWithNoAuthenticatedTenant() {
        this.taskService.addUserIdentityLink(this.task.getId(), "demo", "assignee");
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.deleteUserIdentityLink(this.task.getId(), "demo", "assignee")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void deleteUserIdentityLinkWithDisabledTenantCheck() {
        this.taskService.addUserIdentityLink(this.task.getId(), "demo", "assignee");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskAssignee("demo").count()).isEqualTo(1L);
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.deleteUserIdentityLink(this.task.getId(), "demo", "assignee");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskAssignee("demo").count()).isEqualTo(0L);
    }

    @Test
    public void deleteGroupIdentityLinkWithAuthenticatedTenant() {
        this.taskService.addGroupIdentityLink(this.task.getId(), "demo", "candidate");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(1L);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.taskService.deleteGroupIdentityLink(this.task.getId(), "demo", "candidate");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(0L);
    }

    @Test
    public void deleteGroupIdentityLinkWithNoAuthenticatedTenant() {
        this.taskService.addGroupIdentityLink(this.task.getId(), "demo", "candidate");
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.deleteGroupIdentityLink(this.task.getId(), "demo", "candidate")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void deleteGroupIdentityLinkWithDisabledTenantCheck() {
        this.taskService.addGroupIdentityLink(this.task.getId(), "demo", "candidate");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(1L);
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.taskService.deleteGroupIdentityLink(this.task.getId(), "demo", "candidate");
        Assertions.assertThat((long)this.taskService.createTaskQuery().taskCandidateGroup("demo").count()).isEqualTo(0L);
    }
}

