/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ReceiveTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.SendTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.TerminateEventDefinition;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class SelfCancellationTest {
    protected static final String MESSAGE = "Message";
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineRule).around((TestRule)this.testHelper);
    public static final BpmnModelInstance PROCESS_WITH_CANCELING_RECEIVE_TASK = ((EndEventBuilder)((ReceiveTaskBuilder)((ReceiveTaskBuilder)((EndEventBuilder)((SendTaskBuilder)((SendTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().parallelGateway("fork").userTask().sendTask("sendTask").camundaClass(SendMessageDelegate.class.getName())).camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).endEvent("endEvent").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).moveToLastGateway().receiveTask("receiveTask").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).message("Message")).endEvent("terminateEnd").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).done();
    public static final BpmnModelInstance PROCESS_WITH_CANCELING_RECEIVE_TASK_AND_USER_TASK_AFTER_SEND = ((UserTaskBuilder)ModifiableBpmnModelInstance.modify(PROCESS_WITH_CANCELING_RECEIVE_TASK).removeFlowNode("endEvent").activityBuilder("sendTask").userTask("userTask").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).endEvent().done();
    public static final BpmnModelInstance PROCESS_WITH_CANCELING_RECEIVE_TASK_WITHOUT_END_AFTER_SEND = ModifiableBpmnModelInstance.modify(PROCESS_WITH_CANCELING_RECEIVE_TASK).removeFlowNode("endEvent");
    public static final BpmnModelInstance PROCESS_WITH_CANCELING_RECEIVE_TASK_WITH_SEND_AS_SCOPE = ((EndEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(PROCESS_WITH_CANCELING_RECEIVE_TASK).activityBuilder("sendTask").boundaryEvent("boundary").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).timerWithDuration("PT5S")).endEvent("endEventBoundary").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).done();
    public static final BpmnModelInstance PROCESS_WITH_CANCELING_RECEIVE_TASK_WITH_SEND_AS_SCOPE_WITHOUT_END = ModifiableBpmnModelInstance.modify(PROCESS_WITH_CANCELING_RECEIVE_TASK_WITH_SEND_AS_SCOPE).removeFlowNode("endEvent");
    public static final BpmnModelInstance PROCESS_WITH_SUBPROCESS_AND_DELEGATE_MSG_SEND = ((EndEventBuilder)((StartEventBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(((EndEventBuilder)((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().subProcess().embeddedSubProcess().startEvent().userTask().serviceTask("sendTask").camundaClass(SendMessageDelegate.class.getName())).camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).endEvent("endEventSubProc").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).subProcessDone().endEvent().camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).done()).addSubProcessTo("process").triggerByEvent()).embeddedSubProcess().startEvent("startSubEvent").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).message("Message")).endEvent("endEventSubEvent").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).done();
    public static final BpmnModelInstance PROCESS_WITH_PARALLEL_SEND_TASK_AND_BOUNDARY_EVENT = ((EndEventBuilder)((EndEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((SendTaskBuilder)((SendTaskBuilder)((EndEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().parallelGateway("fork").userTask().endEvent().camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).moveToLastGateway().sendTask("sendTask").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).camundaClass(SignalDelegate.class.getName())).boundaryEvent("boundary").message("Message")).camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).endEvent("endEventBoundary").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).moveToNode("sendTask").endEvent("endEvent").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).done();
    public static final BpmnModelInstance PROCESS_WITH_SEND_TASK_AND_BOUNDARY_EVENT = ((EndEventBuilder)((EndEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((SendTaskBuilder)((SendTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().sendTask("sendTask").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).camundaClass(SignalDelegate.class.getName())).boundaryEvent("boundary").message("Message")).camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).endEvent("endEventBoundary").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).moveToNode("sendTask").endEvent("endEvent").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).done();
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    public static void initEndEvent(BpmnModelInstance modelInstance, String endEventId) {
        EndEvent endEvent = (EndEvent)modelInstance.getModelElementById(endEventId);
        TerminateEventDefinition terminateDefinition = (TerminateEventDefinition)modelInstance.newInstance(TerminateEventDefinition.class);
        endEvent.addChildElement((ModelElementInstance)terminateDefinition);
    }

    @Before
    public void clearRecorderListener() {
        RecorderExecutionListener.clear();
    }

    @Before
    public void initServices() {
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.taskService = this.processEngineRule.getTaskService();
    }

    private void checkRecordedEvents(String ... activityIds) {
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)activityIds.length, (long)recordedEvents.size());
        for (int i = 0; i < activityIds.length; ++i) {
            Assert.assertEquals((Object)activityIds[i], (Object)recordedEvents.get(i).getActivityId());
        }
    }

    private void testParallelTerminationWithSend(BpmnModelInstance modelInstance) {
        this.testHelper.deploy(modelInstance);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.checkRecordedEvents("receiveTask", "sendTask", "terminateEnd");
    }

    @Test
    public void testTriggerParallelTerminateEndEvent() throws Exception {
        this.testParallelTerminationWithSend(PROCESS_WITH_CANCELING_RECEIVE_TASK);
    }

    @Test
    public void testTriggerParallelTerminateEndEventWithUserTask() throws Exception {
        this.testParallelTerminationWithSend(PROCESS_WITH_CANCELING_RECEIVE_TASK_AND_USER_TASK_AFTER_SEND);
    }

    @Test
    public void testTriggerParallelTerminateEndEventWithoutEndAfterSend() throws Exception {
        this.testParallelTerminationWithSend(PROCESS_WITH_CANCELING_RECEIVE_TASK_WITHOUT_END_AFTER_SEND);
    }

    @Test
    public void testTriggerParallelTerminateEndEventWithSendAsScope() throws Exception {
        this.testParallelTerminationWithSend(PROCESS_WITH_CANCELING_RECEIVE_TASK_WITH_SEND_AS_SCOPE);
    }

    @Test
    public void testTriggerParallelTerminateEndEventWithSendAsScopeWithoutEnd() throws Exception {
        this.testParallelTerminationWithSend(PROCESS_WITH_CANCELING_RECEIVE_TASK_WITH_SEND_AS_SCOPE_WITHOUT_END);
    }

    @Test
    public void testSendMessageInSubProcess() throws Exception {
        this.testHelper.deploy(PROCESS_WITH_SUBPROCESS_AND_DELEGATE_MSG_SEND);
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.checkRecordedEvents("sendTask", "startSubEvent", "endEventSubEvent");
    }

    @Test
    public void testParallelSendTaskWithBoundaryRecieveTask() throws Exception {
        this.testHelper.deploy(PROCESS_WITH_PARALLEL_SEND_TASK_AND_BOUNDARY_EVENT);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("process");
        Execution activity = (Execution)this.runtimeService.createExecutionQuery().activityId("sendTask").singleResult();
        this.runtimeService.signal(activity.getId());
        List activities = this.runtimeService.getActiveActivityIds(procInst.getId());
        Assert.assertNotNull((Object)activities);
        Assert.assertEquals((long)1L, (long)activities.size());
        this.checkRecordedEvents("sendTask", "boundary", "endEventBoundary");
    }

    @Test
    public void testSendTaskWithBoundaryEvent() throws Exception {
        this.testHelper.deploy(PROCESS_WITH_SEND_TASK_AND_BOUNDARY_EVENT);
        this.runtimeService.startProcessInstanceByKey("process");
        Execution activity = (Execution)this.runtimeService.createExecutionQuery().activityId("sendTask").singleResult();
        this.runtimeService.signal(activity.getId());
        this.checkRecordedEvents("sendTask", "boundary", "endEventBoundary");
    }

    static {
        SelfCancellationTest.initEndEvent(PROCESS_WITH_CANCELING_RECEIVE_TASK, "terminateEnd");
        SelfCancellationTest.initEndEvent(PROCESS_WITH_CANCELING_RECEIVE_TASK_AND_USER_TASK_AFTER_SEND, "terminateEnd");
        SelfCancellationTest.initEndEvent(PROCESS_WITH_CANCELING_RECEIVE_TASK_WITH_SEND_AS_SCOPE, "terminateEnd");
        SelfCancellationTest.initEndEvent(PROCESS_WITH_CANCELING_RECEIVE_TASK_WITHOUT_END_AFTER_SEND, "terminateEnd");
        SelfCancellationTest.initEndEvent(PROCESS_WITH_CANCELING_RECEIVE_TASK_WITH_SEND_AS_SCOPE_WITHOUT_END, "terminateEnd");
    }

    public static class SendMessageDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = execution.getProcessEngineServices().getRuntimeService();
            runtimeService.correlateMessage(SelfCancellationTest.MESSAGE);
        }
    }

    public static class SignalDelegate
    implements SignallableActivityBehavior {
        public void execute(ActivityExecution execution) throws Exception {
        }

        public void signal(ActivityExecution execution, String signalEvent, Object signalData) throws Exception {
            RuntimeService runtimeService = execution.getProcessEngineServices().getRuntimeService();
            runtimeService.correlateMessage(SelfCancellationTest.MESSAGE);
        }
    }
}

