/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationAddBoundaryEventsTest {
    public static final String AFTER_BOUNDARY_TASK = "afterBoundary";
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    public static final String ERROR_CODE = "Error";
    public static final String ESCALATION_CODE = "Escalation";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testAddMessageBoundaryEventToUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToScopeUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToConcurrentUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToConcurrentScopeUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToSubProcessAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMessageBoundaryEventToParallelSubProcessAndCorrelateMessage() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToUserTaskAndSendSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToScopeUserTaskAndSendSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToConcurrentUserTaskAndSendSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToConcurrentScopeUserTaskAndSendSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToSubProcessAndCorrelateSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("boundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddSignalBoundaryEventToParallelSubProcessAndCorrelateSignal() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobCreated("boundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToUserTaskAndSendTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobCreated("boundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToScopeUserTaskAndSendTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToConcurrentUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobCreated("boundary");
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToConcurrentUserTaskAndSendTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToConcurrentScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobCreated("boundary");
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToConcurrentScopeUserTaskAndSendTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobCreated("boundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToSubProcessAndCorrelateTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToSubProcessWithScopeUserTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobCreated("boundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToParallelSubProcess() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobCreated("boundary");
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddTimerBoundaryEventToParallelSubProcessAndCorrelateTimerWithDate() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddMultipleBoundaryEvents() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("timerBoundary").timerWithDate(TIMER_DATE)).moveToActivity("userTask").boundaryEvent("messageBoundary").message(MESSAGE_NAME)).moveToActivity("userTask").boundaryEvent("signalBoundary").signal(SIGNAL_NAME)).done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionCreated("messageBoundary", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionCreated("signalBoundary", SIGNAL_NAME);
        this.testHelper.assertBoundaryTimerJobCreated("timerBoundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddErrorBoundaryEventToSubProcessAndThrowError() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)((EndEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).endEventBuilder("subProcessEnd").error(ERROR_CODE)).moveToActivity("subProcess").boundaryEvent().error(ERROR_CODE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testAddEscalationBoundaryEventToSubProcessAndThrowEscalation() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)((EndEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).endEventBuilder("subProcessEnd").escalation(ESCALATION_CODE)).moveToActivity("subProcess").boundaryEvent().escalation(ESCALATION_CODE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.completeTask("userTask");
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }
}

