/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CompensationModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CompensateEventDefinitionBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationCompensationRemoveSubProcessTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Before
    @After
    public void clearExecutionListener() {
        RecorderExecutionListener.clear();
    }

    @Test
    public void testCase1() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_TWO_TASKS_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "compensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCase1AssertActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_TWO_TASKS_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").activity("compensationHandler").done());
    }

    @Test
    public void testCase1AssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_TWO_TASKS_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
    }

    @Test
    public void testCase2() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertEventSubscriptionMigrated("compensationHandler", "compensationHandler", null);
        this.testHelper.completeTask("userTask2");
        this.testHelper.completeTask("compensationHandler");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testCase2ActivityInstance() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").activity("compensationHandler").done());
    }

    @Test
    public void testCase2AssertExecutionTree() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask2").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
    }

    @Test
    public void testCanOnlyTriggerCompensationInParentOfRemovedScope() {
        BpmnModelInstance sourceModel = ProcessModels.newModel().startEvent().subProcess("outerSubProcess").embeddedSubProcess().startEvent().userTask("userTask1").boundaryEvent("compensationBoundary").compensateEventDefinition().compensateEventDefinitionDone().moveToActivity("userTask1").subProcess("innerSubProcess").embeddedSubProcess().startEvent().userTask("userTask2").endEvent().subProcessDone().endEvent().subProcessDone().done();
        CompensationModels.addUserTaskCompensationHandler(sourceModel, "compensationBoundary", "compensationHandler");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((CompensateEventDefinitionBuilder)ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_TWO_TASKS_SUBPROCESS_MODEL).endEventBuilder("subProcessEnd").compensateEventDefinition().waitForCompletion(true)).compensateEventDefinitionDone().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("innerSubProcess", "subProcess").mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.completeTask("userTask2");
        ActivityInstance activityInstance = this.rule.getRuntimeService().getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("compensationEvent").beginScope("subProcess").activity("compensationHandler").done());
    }

    @Test
    public void testCanRemoveEventScopeWithVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Execution subProcessExecution = (Execution)this.rule.getRuntimeService().createExecutionQuery().activityId("userTask1").singleResult();
        this.rule.getRuntimeService().setVariableLocal(subProcessExecution.getId(), "foo", (Object)"bar");
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createVariableInstanceQuery().count());
    }

    @Test
    public void testDeletesOnlyVariablesFromRemovingScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.DOUBLE_SUBPROCESS_MODEL);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("innerSubProcess", "subProcess").mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Execution innerSubProcessExecution = (Execution)this.rule.getRuntimeService().createExecutionQuery().activityId("userTask1").singleResult();
        String outerSubProcessExecutionId = ((ExecutionEntity)innerSubProcessExecution).getParentId();
        this.rule.getRuntimeService().setVariableLocal(outerSubProcessExecutionId, "outerVariable", (Object)"outerValue");
        this.rule.getRuntimeService().setVariableLocal(innerSubProcessExecution.getId(), "innerVariable", (Object)"innerValue");
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        VariableInstance migratedVariable = this.testHelper.snapshotAfterMigration.getSingleVariable("innerVariable");
        Assert.assertNotNull((Object)migratedVariable);
        Assert.assertEquals((Object)"innerValue", (Object)migratedVariable.getValue());
    }

    @Test
    public void testNoListenersCalled() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL).activityBuilder("subProcess").camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName()).done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)RecorderExecutionListener.getRecordedEvents().size());
    }

    @Test
    public void testNoOutputMappingExecuted() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL).activityBuilder("subProcess").camundaOutputParameter("foo", "${bar}").done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CompensationModels.ONE_COMPENSATION_TASK_MODEL);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask2", "userTask2").mapActivities("compensationBoundary", "compensationBoundary").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.rule.getRuntimeService().setVariable(processInstance.getId(), "bar", (Object)"value1");
        this.testHelper.completeTask("userTask1");
        this.rule.getRuntimeService().setVariable(processInstance.getId(), "bar", (Object)"value2");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)2L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        VariableInstance variableInstance = this.testHelper.snapshotAfterMigration.getSingleVariable("foo");
        Assert.assertEquals((Object)"value1", (Object)variableInstance.getValue());
    }
}

