/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.batch;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class BatchMigrationHistoryTest {
    protected static final Date START_DATE = new Date(1457326800000L);
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected ProcessDefinition sourceProcessDefinition;
    protected ProcessDefinition targetProcessDefinition;
    protected boolean defaultEnsureJobDueDateSet;
    @Parameterized.Parameter(value=0)
    public boolean ensureJobDueDateSet;
    @Parameterized.Parameter(value=1)
    public Date currentTime;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);

    @Parameterized.Parameters(name="Job DueDate is set: {0}")
    public static Collection<Object[]> scenarios() throws ParseException {
        return Arrays.asList({false, null}, {true, START_DATE});
    }

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Before
    public void setupConfiguration() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.defaultEnsureJobDueDateSet = this.configuration.isEnsureJobDueDateNotNull();
        this.configuration.setEnsureJobDueDateNotNull(this.ensureJobDueDateSet);
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)START_DATE);
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @After
    public void resetConfiguration() {
        this.configuration.setEnsureJobDueDateNotNull(this.defaultEnsureJobDueDateSet);
    }

    @Test
    public void testHistoricBatchCreation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)batch.getId(), (Object)historicBatch.getId());
        Assert.assertEquals((Object)batch.getType(), (Object)historicBatch.getType());
        Assert.assertEquals((long)batch.getTotalJobs(), (long)historicBatch.getTotalJobs());
        Assert.assertEquals((long)batch.getBatchJobsPerSeed(), (long)historicBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)batch.getInvocationsPerBatchJob(), (long)historicBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)historicBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)historicBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)historicBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)START_DATE, (Object)historicBatch.getStartTime());
        Assert.assertEquals((Object)batch.getStartTime(), (Object)historicBatch.getStartTime());
        Assert.assertEquals((Object)batch.getExecutionStartTime(), (Object)historicBatch.getExecutionStartTime());
        Assert.assertNull((Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricBatchCompletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        Date endDate = this.helper.addSecondsToClock(12);
        this.helper.executeMonitorJob(batch);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)endDate, (Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricSeedJobLog() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        HistoricJobLog jobLog = this.helper.getHistoricSeedJobLog(batch).get(0);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-seed-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)this.helper.sourceProcessDefinition.getDeploymentId(), (Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertEquals((Object)this.currentTime, (Object)jobLog.getJobDueDate());
        Date executionDate = this.helper.addSecondsToClock(12);
        this.helper.completeSeedJobs(batch);
        jobLog = this.helper.getHistoricSeedJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)batch.getSeedJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-seed-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)this.helper.sourceProcessDefinition.getDeploymentId(), (Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertEquals((Object)this.currentTime, (Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricMonitorJobLog() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        List<HistoricJobLog> jobLogs = this.helper.getHistoricMonitorJobLog(batch, monitorJob);
        Assert.assertEquals((long)1L, (long)jobLogs.size());
        HistoricJobLog jobLog = jobLogs.get(0);
        this.assertCommonMonitorJobLogProperties(batch, jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)this.currentTime, (Object)jobLog.getJobDueDate());
        Date executionDate = this.helper.addSecondsToClock(15);
        Date monitorJobDueDate = this.helper.addSeconds(executionDate, 30);
        this.helper.executeMonitorJob(batch);
        jobLogs = this.helper.getHistoricMonitorJobLog(batch, monitorJob);
        Assert.assertEquals((long)2L, (long)jobLogs.size());
        jobLog = jobLogs.get(1);
        this.assertCommonMonitorJobLogProperties(batch, jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)this.currentTime, (Object)jobLog.getJobDueDate());
        monitorJob = this.helper.getMonitorJob(batch);
        jobLogs = this.helper.getHistoricMonitorJobLog(batch, monitorJob);
        Assert.assertEquals((long)1L, (long)jobLogs.size());
        jobLog = jobLogs.get(0);
        this.assertCommonMonitorJobLogProperties(batch, jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)monitorJobDueDate, (Object)jobLog.getJobDueDate());
        executionDate = this.helper.addSecondsToClock(15);
        this.helper.executeJobs(batch);
        this.helper.executeMonitorJob(batch);
        jobLogs = this.helper.getHistoricMonitorJobLog(batch, monitorJob);
        Assert.assertEquals((long)2L, (long)jobLogs.size());
        jobLog = jobLogs.get(1);
        this.assertCommonMonitorJobLogProperties(batch, jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)monitorJobDueDate, (Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricBatchJobLog() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        String sourceDeploymentId = this.helper.getSourceProcessDefinition().getDeploymentId();
        Date executionDate = this.helper.addSecondsToClock(12);
        this.helper.executeJobs(batch);
        HistoricJobLog jobLog = this.helper.getHistoricBatchJobLog(batch).get(0);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isCreationLog());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"instance-migration", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)START_DATE, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)sourceDeploymentId, (Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertEquals((Object)this.currentTime, (Object)jobLog.getJobDueDate());
        jobLog = this.helper.getHistoricBatchJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isSuccessLog());
        Assert.assertEquals((Object)batch.getBatchJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"instance-migration", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertEquals((Object)executionDate, (Object)jobLog.getTimestamp());
        Assert.assertEquals((Object)sourceDeploymentId, (Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
        Assert.assertEquals((Object)this.currentTime, (Object)jobLog.getJobDueDate());
    }

    @Test
    public void testHistoricBatchForBatchDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.managementService.deleteBatch(batch.getId(), false);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        Assert.assertNotNull((Object)historicBatch);
        Assert.assertEquals((Object)deletionDate, (Object)historicBatch.getEndTime());
    }

    @Test
    public void testHistoricSeedJobLogForBatchDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.managementService.deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricSeedJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testHistoricMonitorJobLogForBatchDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.managementService.deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricMonitorJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testHistoricBatchJobLogForBatchDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        Date deletionDate = this.helper.addSecondsToClock(12);
        this.managementService.deleteBatch(batch.getId(), false);
        HistoricJobLog jobLog = this.helper.getHistoricBatchJobLog(batch).get(1);
        Assert.assertNotNull((Object)jobLog);
        Assert.assertTrue((boolean)jobLog.isDeletionLog());
        Assert.assertEquals((Object)deletionDate, (Object)jobLog.getTimestamp());
    }

    @Test
    public void testDeleteHistoricBatch() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        this.helper.executeMonitorJob(batch);
        HistoricBatch historicBatch = this.helper.getHistoricBatch(batch);
        this.historyService.deleteHistoricBatch(historicBatch.getId());
        Assert.assertNull((Object)this.helper.getHistoricBatch(batch));
        Assert.assertTrue((boolean)this.helper.getHistoricSeedJobLog(batch).isEmpty());
        Assert.assertTrue((boolean)this.helper.getHistoricMonitorJobLog(batch).isEmpty());
        Assert.assertTrue((boolean)this.helper.getHistoricBatchJobLog(batch).isEmpty());
    }

    @Test
    public void testHistoricSeedJobIncidentDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Job seedJob = this.helper.getSeedJob(batch);
        this.managementService.setJobRetries(seedJob.getId(), 0);
        this.managementService.deleteBatch(batch.getId(), false);
        this.historyService.deleteHistoricBatch(batch.getId());
        long historicIncidents = this.historyService.createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testHistoricMonitorJobIncidentDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        this.managementService.setJobRetries(monitorJob.getId(), 0);
        this.managementService.deleteBatch(batch.getId(), false);
        this.historyService.deleteHistoricBatch(batch.getId());
        long historicIncidents = this.historyService.createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testHistoricBatchJobLogIncidentDeletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(3);
        this.helper.completeSeedJobs(batch);
        this.helper.failExecutionJobs(batch, 3);
        this.managementService.deleteBatch(batch.getId(), false);
        this.historyService.deleteHistoricBatch(batch.getId());
        long historicIncidents = this.historyService.createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    protected void assertCommonMonitorJobLogProperties(Batch batch, HistoricJobLog jobLog) {
        Assert.assertNotNull((Object)jobLog);
        Assert.assertEquals((Object)batch.getMonitorJobDefinitionId(), (Object)jobLog.getJobDefinitionId());
        Assert.assertEquals((Object)"batch-monitor-job", (Object)jobLog.getJobDefinitionType());
        Assert.assertEquals((Object)batch.getId(), (Object)jobLog.getJobDefinitionConfiguration());
        Assert.assertNull((Object)jobLog.getDeploymentId());
        Assert.assertNull((Object)jobLog.getProcessDefinitionId());
        Assert.assertNull((Object)jobLog.getExecutionId());
    }
}

