/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskCountByCandidateGroupResult;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskCountByCandidateGroupsTest {
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule processEngineTestRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineTestRule).around((TestRule)this.processEngineRule);
    protected TaskService taskService;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected String userId = "user";
    protected List<String> tasks = new ArrayList<String>();
    protected List<String> tenants = Arrays.asList("tenant1", "tenant2");
    protected List<String> groups = Arrays.asList("aGroupId", "anotherGroupId");

    @Before
    public void setUp() {
        this.taskService = this.processEngineRule.getTaskService();
        this.identityService = this.processEngineRule.getIdentityService();
        this.authorizationService = this.processEngineRule.getAuthorizationService();
        this.processEngineConfiguration = this.processEngineRule.getProcessEngineConfiguration();
        this.createTask(this.groups.get(0), this.tenants.get(0));
        this.createTask(this.groups.get(0), this.tenants.get(1));
        this.createTask(this.groups.get(1), this.tenants.get(1));
        this.createTask(null, this.tenants.get(1));
    }

    @After
    public void cleanUp() {
        for (String taskId : this.tasks) {
            this.taskService.deleteTask(taskId, true);
        }
    }

    @Test
    public void shouldReturnTaskCountsByGroup() {
        List results = this.taskService.createTaskReport().taskCountByCandidateGroup();
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void shouldProvideTaskCountForEachGroup() {
        List results = this.taskService.createTaskReport().taskCountByCandidateGroup();
        for (TaskCountByCandidateGroupResult result : results) {
            this.checkResultCount(result, null, 1);
            this.checkResultCount(result, this.groups.get(0), 2);
            this.checkResultCount(result, this.groups.get(1), 1);
        }
    }

    @Test
    public void shouldProvideGroupNameForEachGroup() {
        List results = this.taskService.createTaskReport().taskCountByCandidateGroup();
        for (TaskCountByCandidateGroupResult result : results) {
            Assert.assertTrue((boolean)this.checkResultName(result));
        }
    }

    @Test
    public void shouldFetchCountOfTasksWithoutAssignee() {
        User user = this.identityService.newUser(this.userId);
        this.identityService.saveUser(user);
        this.taskService.delegateTask(this.tasks.get(2), this.userId);
        List results = this.taskService.createTaskReport().taskCountByCandidateGroup();
        this.identityService.deleteUser(this.userId);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    protected void createTask(String groupId, String tenantId) {
        Task task = this.taskService.newTask();
        task.setTenantId(tenantId);
        this.taskService.saveTask(task);
        if (groupId != null) {
            this.taskService.addCandidateGroup(task.getId(), groupId);
        }
        this.tasks.add(task.getId());
    }

    protected void checkResultCount(TaskCountByCandidateGroupResult result, String expectedResultName, int expectedResultCount) {
        if (expectedResultName == null && result.getGroupName() == null || result.getGroupName() != null && result.getGroupName().equals(expectedResultName)) {
            Assert.assertEquals((long)expectedResultCount, (long)result.getTaskCount());
        }
    }

    protected boolean checkResultName(TaskCountByCandidateGroupResult result) {
        return result.getGroupName() == null || result.getGroupName().equals(this.groups.get(0)) || result.getGroupName().equals(this.groups.get(1));
    }
}

