/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionQueryImpl;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.api.variables.AbstractVariableIgnoreCaseTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CaseExecutionQueryVariableIgnoreCaseTest
extends AbstractVariableIgnoreCaseTest<CaseExecutionQueryImpl, CaseExecution> {
    CaseService caseService;
    RepositoryService repositoryService;

    @Before
    public void init() {
        this.caseService = this.engineRule.getCaseService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn").deploy();
        this.instance = this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariables(VARIABLES).businessKey("oneTaskCase").create();
    }

    @After
    public void tearDown() {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Override
    protected CaseExecutionQueryImpl createQuery() {
        return (CaseExecutionQueryImpl)this.caseService.createCaseExecutionQuery();
    }

    @Override
    protected void assertThatTwoInstancesAreEqual(CaseExecution one, CaseExecution two) {
        Assertions.assertThat((String)one.getId()).isEqualTo((Object)two.getId());
    }

    public void assertThatListContainsOnlyExpectedElements(List<CaseExecution> instances, CaseExecution instance) {
        Assertions.assertThat((int)instances.size()).isEqualTo(2);
        Assertions.assertThat((String)instances.get(0).getCaseInstanceId()).isEqualTo((Object)instance.getCaseInstanceId());
        Assertions.assertThat((String)instances.get(1).getCaseInstanceId()).isEqualTo((Object)instance.getCaseInstanceId());
    }

    @Test
    public void testCaseInstanceVariableNameEqualsIgnoreCase() {
        List eq = ((CaseExecutionQueryImpl)this.queryNameIgnoreCase()).caseInstanceVariableValueEquals("variableName", (Object)"variableValue").list();
        List eqNameLC = ((CaseExecutionQueryImpl)this.queryNameIgnoreCase()).caseInstanceVariableValueEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List eqValueLC = ((CaseExecutionQueryImpl)this.queryNameIgnoreCase()).caseInstanceVariableValueEquals("variableName", (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = ((CaseExecutionQueryImpl)this.queryNameIgnoreCase()).caseInstanceVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElements(eq, (CaseExecution)this.instance);
        this.assertThatListContainsOnlyExpectedElements(eqNameLC, (CaseExecution)this.instance);
        Assertions.assertThat((List)eqValueLC).isEmpty();
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    public void testCaseInstanceVariableNameNotEqualsIgnoreCase() {
        List neq = ((CaseExecutionQueryImpl)this.queryNameIgnoreCase()).caseInstanceVariableValueNotEquals("variableName", (Object)"variableValue").list();
        List neqNameLC = ((CaseExecutionQueryImpl)this.queryNameIgnoreCase()).caseInstanceVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List neqValueNE = ((CaseExecutionQueryImpl)this.queryNameIgnoreCase()).caseInstanceVariableValueNotEquals("variableName", (Object)"nonExistent").list();
        List neqNameLCValueNE = ((CaseExecutionQueryImpl)this.queryNameIgnoreCase()).caseInstanceVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"nonExistent").list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElements(neqValueNE, (CaseExecution)this.instance);
        this.assertThatListContainsOnlyExpectedElements(neqNameLCValueNE, (CaseExecution)this.instance);
    }

    @Test
    public void testCaseInstanceVariableValueEqualsIgnoreCase() {
        List eq = ((CaseExecutionQueryImpl)this.queryValueIgnoreCase()).caseInstanceVariableValueEquals("variableName", (Object)"variableValue").list();
        List eqNameLC = ((CaseExecutionQueryImpl)this.queryValueIgnoreCase()).caseInstanceVariableValueEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List eqValueLC = ((CaseExecutionQueryImpl)this.queryValueIgnoreCase()).caseInstanceVariableValueEquals("variableName", (Object)VARIABLE_VALUE_LC).list();
        List eqNameValueLC = ((CaseExecutionQueryImpl)this.queryValueIgnoreCase()).caseInstanceVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        this.assertThatListContainsOnlyExpectedElements(eq, (CaseExecution)this.instance);
        Assertions.assertThat((List)eqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElements(eqValueLC, (CaseExecution)this.instance);
        Assertions.assertThat((List)eqNameValueLC).isEmpty();
    }

    @Test
    public void testCaseInstanceVariableValueNotEqualsIgnoreCase() {
        List neq = ((CaseExecutionQueryImpl)this.queryValueIgnoreCase()).caseInstanceVariableValueNotEquals("variableName", (Object)"variableValue").list();
        List neqNameLC = ((CaseExecutionQueryImpl)this.queryValueIgnoreCase()).caseInstanceVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List neqValueNE = ((CaseExecutionQueryImpl)this.queryValueIgnoreCase()).caseInstanceVariableValueNotEquals("variableName", (Object)"nonExistent").list();
        List neqNameLCValueNE = ((CaseExecutionQueryImpl)this.queryValueIgnoreCase()).caseInstanceVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"nonExistent").list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElements(neqValueNE, (CaseExecution)this.instance);
        Assertions.assertThat((List)neqNameLCValueNE).isEmpty();
    }

    @Test
    public void testCaseInstanceVariableNameAndValueEqualsIgnoreCase() {
        List eq = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueEquals("variableName", (Object)"variableValue").list();
        List eqNameLC = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List eqValueLC = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueEquals("variableName", (Object)VARIABLE_VALUE_LC).list();
        List eqValueNE = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueEquals("variableName", (Object)"nonExistent").list();
        List eqNameValueLC = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List eqNameLCValueNE = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueEquals(VARIABLE_NAME_LC, (Object)"nonExistent").list();
        this.assertThatListContainsOnlyExpectedElements(eq, (CaseExecution)this.instance);
        this.assertThatListContainsOnlyExpectedElements(eqNameLC, (CaseExecution)this.instance);
        this.assertThatListContainsOnlyExpectedElements(eqValueLC, (CaseExecution)this.instance);
        Assertions.assertThat((List)eqValueNE).isEmpty();
        this.assertThatListContainsOnlyExpectedElements(eqNameValueLC, (CaseExecution)this.instance);
        Assertions.assertThat((List)eqNameLCValueNE).isEmpty();
    }

    @Test
    public void testCaseInstanceVariableNameAndValueNotEqualsIgnoreCase() {
        List neq = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueNotEquals("variableName", (Object)"variableValue").list();
        List neqNameLC = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"variableValue").list();
        List neqValueLC = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueNotEquals("variableName", (Object)VARIABLE_VALUE_LC).list();
        List neqValueNE = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueNotEquals("variableName", (Object)"nonExistent").list();
        List neqNameValueLC = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueNotEquals(VARIABLE_NAME_LC, (Object)VARIABLE_VALUE_LC).list();
        List neqNameLCValueNE = ((CaseExecutionQueryImpl)this.queryNameValueIgnoreCase()).caseInstanceVariableValueNotEquals(VARIABLE_NAME_LC, (Object)"nonExistent").list();
        Assertions.assertThat((List)neq).isEmpty();
        Assertions.assertThat((List)neqNameLC).isEmpty();
        Assertions.assertThat((List)neqValueLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElements(neqValueNE, (CaseExecution)this.instance);
        Assertions.assertThat((List)neqNameValueLC).isEmpty();
        this.assertThatListContainsOnlyExpectedElements(neqNameLCValueNE, (CaseExecution)this.instance);
    }
}

