/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.el;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.bpmn.el.ExecutionTestVariable;
import org.camunda.bpm.engine.test.bpmn.el.ExpressionTestParameter;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ExclusiveGatewayBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionManagerTest
extends PluggableProcessEngineTest {
    protected String deploymentId;

    @After
    public void clear() {
        Mocks.reset();
        if (this.deploymentId != null) {
            this.repositoryService.deleteDeployment(this.deploymentId, true);
            this.deploymentId = null;
        }
    }

    @Deployment
    @Test
    public void testMethodExpressions() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("aString", "abcdefgh");
        this.runtimeService.startProcessInstanceByKey("methodExpressionProcess", vars);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("methodExpressionProcess").count());
    }

    @Deployment
    @Test
    public void testExecutionAvailable() {
        HashMap<String, ExecutionTestVariable> vars = new HashMap<String, ExecutionTestVariable>();
        vars.put("myVar", new ExecutionTestVariable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testExecutionAvailableProcess", vars);
        String value = (String)this.runtimeService.getVariable(processInstance.getId(), "testVar");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"myValue", (Object)value);
    }

    @Deployment
    @Test
    public void testAuthenticatedUserIdAvailable() {
        try {
            this.identityService.setAuthenticatedUserId("frederik");
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testAuthenticatedUserIdAvailableProcess");
            String value = (String)this.runtimeService.getVariable(processInstance.getId(), "theUser");
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)"frederik", (Object)value);
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Deployment
    @Test
    public void testResolvesVariablesFromDifferentScopes() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("assignee", "michael");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"michael", (Object)task.getAssignee());
        variables.put("assignee", "johnny");
        ProcessInstance secondInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(secondInstance.getId()).singleResult();
        Assert.assertEquals((Object)"johnny", (Object)task.getAssignee());
    }

    @Deployment
    @RequiredHistoryLevel(value="full")
    @Test
    public void testSetVariableByExpressionFromListener() {
        this.runtimeService.startProcessInstanceByKey("fieldInjectionTest", (Map)Variables.putValue((String)"myCounter", (Object)5));
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myCounter", (Object)6).count());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testJuelExpressionWithNonPublicClass() {
        BpmnModelInstance process = ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().exclusiveGateway().condition("true", "${list.contains('foo')}")).userTask("userTask").moveToLastGateway().condition("false", "${!list.contains('foo')}").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("list", Arrays.asList("foo", "bar")));
        HistoricActivityInstance userTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldCompareWithBigDecimal() {
        BpmnModelInstance process = ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().exclusiveGateway().condition("true", "${total.compareTo(myValue) >= 0}")).userTask("userTask").moveToLastGateway().condition("false", "${total.compareTo(myValue) < 0}").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("total", (Object)new BigDecimal(123)).putValue("myValue", (Object)new BigDecimal(0)));
        HistoricActivityInstance userTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
    }

    @Deployment
    @Test
    public void shouldResolveMethodExpressionTwoParametersSameType() {
        HashMap<String, ExpressionTestParameter> vars = new HashMap<String, ExpressionTestParameter>();
        vars.put("myVar", new ExpressionTestParameter());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", vars);
        boolean task1Var = (Boolean)this.runtimeService.getVariable(processInstance.getId(), "task1Var");
        Assertions.assertThat((boolean)task1Var).isTrue();
        String task2Var = (String)this.runtimeService.getVariable(processInstance.getId(), "task2Var");
        Assert.assertEquals((Object)"lastParam", (Object)task2Var);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldResolveMethodExpressionWithOneNullParameter() {
        BpmnModelInstance process = ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().exclusiveGateway().condition("true", "${myBean.myMethod(execution.getVariable('v'), execution.getVariable('w'), execution.getVariable('x'), execution.getVariable('y'), execution.getVariable('z'))}")).userTask("userTask").moveToLastGateway().condition("false", "${false}").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy().getId();
        Mocks.register((String)"myBean", (Object)new MyBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("v", (Object)"a").putValue("w", null).putValue("x", (Object)"b").putValue("y", (Object)"c").putValue("z", (Object)"d"));
        HistoricActivityInstance userTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldResolveMethodExpressionWithTwoNullParameter() {
        BpmnModelInstance process = ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().exclusiveGateway().condition("true", "${myBean.myMethod(execution.getVariable('v'), execution.getVariable('w'), execution.getVariable('x'), execution.getVariable('y'), execution.getVariable('z'))}")).userTask("userTask").moveToLastGateway().condition("false", "${false}").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy().getId();
        Mocks.register((String)"myBean", (Object)new MyBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("v", (Object)"a").putValue("w", null).putValue("x", (Object)"b").putValue("y", null).putValue("z", (Object)"d"));
        HistoricActivityInstance userTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldResolveMethodExpressionWithNoNullParameter() {
        BpmnModelInstance process = ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().exclusiveGateway().condition("true", "${myBean.myMethod(execution.getVariable('v'), execution.getVariable('w'), execution.getVariable('x'), execution.getVariable('y'), execution.getVariable('z'))}")).userTask("userTask").moveToLastGateway().condition("false", "${false}").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy().getId();
        Mocks.register((String)"myBean", (Object)new MyBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("v", (Object)"a").putValue("w", (Object)"b").putValue("x", (Object)"c").putValue("y", (Object)"d").putValue("z", (Object)"e"));
        HistoricActivityInstance userTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
    }

    @Test
    public void shouldInvokeMethodWithStringArg() {
        String expression = "myBean.myStringMethod('foo')";
        String expectedOutput = "foo";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldInvokeMethodWithNullStringArg() {
        String expression = "myBean.myStringMethod(execution.getVariable('foo'))";
        String expectedOutput = "";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldInvokeMethodWithNullPrimitiveArg() {
        String expression = "myBean.myIntMethod(execution.getVariable('foo'))";
        int expectedOutput = 0;
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldInvokeMethodWithNullObjectArg() {
        String expression = "myBean.myObjectMethod(execution.getVariable('foo'))";
        Object expectedOutput = null;
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithNoArg() {
        String expression = "myBean.methodWithNoArg()";
        String expectedOutput = "methodWithNoArg";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldFailResolveMethodExpressionNonExistingMethod() {
        String expression = "myBean.methodNotExisted()";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertMethodExpressionResult(expression, null)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Unknown method");
    }

    @Test
    public void shouldResolveMethodExpressionWithOverloadedSingleArg_1() {
        String expression = "myBean.methodWithSingleArg(i1)";
        String expectedOutput = "I1";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithOverloadedSingleArg_2() {
        String expression = "myBean.methodWithSingleArg(i2)";
        String expectedOutput = "I2Impl";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithOverloadedSingleArg_3() {
        String expression = "myBean.methodWithSingleArg(i12)";
        String expectedOutput = "I1AndI2Impl";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithOverloadedDoubleArgs_1() {
        String expression = "myBean.methodWithDoubleArgs(i1, i2)";
        String expectedOutput = "I1Impl, I2";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithOverloadedDoubleArgs_2() {
        String expression = "myBean.methodWithDoubleArgs(i12, i2)";
        String expectedOutput = "I1, I2";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithOverloadedDoubleArgs_3() {
        String expression = "myBean.methodWithDoubleArgs(i12, i12)";
        String expectedOutput = "I1AndI2Impl, I1AndI2Impl";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithOverloadedDoubleArgs_4() {
        String expression = "myBean.methodWithDoubleArgs(i12s, i12)";
        String expectedOutput = "I1AndI2Impl, I1AndI2Impl";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithOverloadedDoubleArgs_5() {
        String expression = "myBean.methodWithDoubleArgs(i12s, i12s)";
        String expectedOutput = "I1AndI2Impl, I1AndI2Impl";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithAmbiguousArgs_1() {
        String expression = "myBean.methodWithAmbiguousArgs(i12, i2)";
        String expectedOutput = "I1AndI2Impl, I2";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithAmbiguousArgs_2() {
        String expression = "myBean.methodWithAmbiguousArgs(i1, i12)";
        String expectedOutput = "I1, I1AndI2Impl";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldFailResolveMethodExpressionWithAmbiguousArgs() {
        String expression = "myBean.methodWithAmbiguousArgs(i12, i12)";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertMethodExpressionResult(expression, null)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Unknown method");
    }

    @Test
    public void shouldResolveMethodExpressionWithCoercibleArgs_1() {
        String expression = "myBean.methodWithCoercibleArgs('foo', 'bar')";
        String expectedOutput = "String, String";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithCoercibleArgs_2() {
        String expression = "myBean.methodWithCoercibleArgs(i1, i12)";
        String expectedOutput = "String, String";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithCoercibleArgs_3() {
        String expression = "myBean.methodWithCoercibleArgs2(i1, 12345678)";
        String expectedOutput = "String, String";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithCoercibleArgs_4() {
        String expression = "myBean.methodWithCoercibleArgs2(i1, intVal)";
        String expectedOutput = "String, String";
        Mocks.register((String)"intVal", (Object)12345678);
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithCoercibleArgs_5() {
        String expression = "myBean.methodWithCoercibleArgs2(12345678, 12345678)";
        String expectedOutput = "Integer, Integer";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithCoercibleArgs_6() {
        String expression = "myBean.methodWithCoercibleArgs2(intVal, intVal)";
        String expectedOutput = "Integer, Integer";
        Mocks.register((String)"intVal", (Object)12345678);
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithVarArgs_1() {
        String expression = "myBean.methodWithVarArgs(i1)";
        String expectedOutput = "I1, I1...";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithVarArgs_2() {
        String expression = "myBean.methodWithVarArgs(i1, i1)";
        String expectedOutput = "I1, I1...";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithVarArgs_3() {
        String expression = "myBean.methodWithVarArgs(i12, i1, i12)";
        String expectedOutput = "I1, I1...";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithVarArgs_4() {
        String expression = "myBean.methodWithVarArgs2(i1)";
        String expectedOutput = "I1, I1AndI2Impl...";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithVarArgs_5() {
        String expression = "myBean.methodWithVarArgs2(i12)";
        String expectedOutput = "I1, I1AndI2Impl...";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithVarArgs_6() {
        String expression = "myBean.methodWithVarArgs2(i1, i1)";
        String expectedOutput = "I1, I1...";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    @Test
    public void shouldResolveMethodExpressionWithVarArgs_7() {
        String expression = "myBean.methodWithVarArgs2(i1, i12)";
        String expectedOutput = "I1, I1AndI2Impl...";
        this.assertMethodExpressionResult(expression, expectedOutput);
    }

    protected void assertMethodExpressionResult(String expression, Object result) {
        BpmnModelInstance process = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().serviceTask().camundaExpression("${" + expression + "}")).camundaResultVariable("output")).userTask().endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy().getId();
        Mocks.register((String)"myBean", (Object)new MyBean());
        Mocks.register((String)"i1", (Object)new I1Impl());
        Mocks.register((String)"i2", (Object)new I2Impl());
        Mocks.register((String)"i12", (Object)new I1AndI2Impl());
        Mocks.register((String)"i12s", (Object)new I1AndI2ImplSub());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance output = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("output").singleResult();
        Assertions.assertThat((Object)output.getValue()).isEqualTo(result);
    }

    public static class MyBean {
        public String methodWithNoArg() {
            return "methodWithNoArg";
        }

        public String methodWithSingleArg(I1 i1) {
            return "I1";
        }

        public String methodWithSingleArg(I2 i2) {
            return "I2";
        }

        public String methodWithSingleArg(I2Impl i2) {
            return "I2Impl";
        }

        public String methodWithSingleArg(I1AndI2Impl i1) {
            return "I1AndI2Impl";
        }

        public String methodWithDoubleArgs(I1 i1, I2 i2) {
            return "I1, I2";
        }

        public String methodWithDoubleArgs(I1Impl i1, I2 i2) {
            return "I1Impl, I2";
        }

        public String methodWithDoubleArgs(I1AndI2Impl i1, I1AndI2Impl i2) {
            return "I1AndI2Impl, I1AndI2Impl";
        }

        public String methodWithAmbiguousArgs(I1AndI2Impl i1, I2 i2) {
            return "I1AndI2Impl, I2";
        }

        public String methodWithAmbiguousArgs(I1 i1, I1AndI2Impl i2) {
            return "I1, I1AndI2Impl";
        }

        public String methodWithCoercibleArgs(String s1, String s2) {
            return "String, String";
        }

        public String methodWithCoercibleArgs2(String s1, String s2) {
            return "String, String";
        }

        public String methodWithCoercibleArgs2(Integer s1, Integer s2) {
            return "Integer, Integer";
        }

        public String methodWithVarArgs(I1 i1, I1 ... i2) {
            return "I1, I1...";
        }

        public String methodWithVarArgs2(I1 i1, I1 ... i2) {
            return "I1, I1...";
        }

        public String methodWithVarArgs2(I1 i1, I1AndI2Impl ... i2) {
            return "I1, I1AndI2Impl...";
        }

        public boolean myMethod(String v, String w, String x, String y, String z) {
            return true;
        }

        public String myStringMethod(String v) {
            return v;
        }

        public int myIntMethod(int v) {
            return v;
        }

        public I1 myObjectMethod(I1 v) {
            return v;
        }
    }

    public static class I1Impl
    implements I1 {
    }

    public static class I2Impl
    implements I2 {
    }

    public static class I1AndI2Impl
    implements I1,
    I2 {
    }

    public static class I1AndI2ImplSub
    extends I1AndI2Impl {
    }

    public static interface I2 {
    }

    public static interface I1 {
    }
}

