/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.compensate;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.compensate.ReadLocalVariableListener;
import org.camunda.bpm.engine.test.bpmn.event.compensate.SetLocalVariableListener;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.BookFlightService;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.CancelFlightService;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.GetVariablesDelegate;
import org.camunda.bpm.engine.test.bpmn.event.compensate.helper.SetVariablesDelegate;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CompensateEventTest
extends PluggableProcessEngineTest {
    @Test
    public void testCompensateOrder() {
        String PROCESS_MODEL_WITH_REF_BEFORE = "org/camunda/bpm/engine/test/bpmn/event/compensate/compensation_reference-before.bpmn";
        String PROCESS_MODEL_WITH_REF_AFTER = "org/camunda/bpm/engine/test/bpmn/event/compensate/compensation_reference-after.bpmn";
        org.camunda.bpm.engine.repository.Deployment deployment1 = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/compensate/compensation_reference-before.bpmn").deploy();
        org.camunda.bpm.engine.repository.Deployment deployment2 = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/compensate/compensation_reference-after.bpmn").deploy();
        this.repositoryService.deleteDeployment(deployment1.getId());
        this.repositoryService.deleteDeployment(deployment2.getId());
    }

    @Deployment
    @Test
    public void testCompensateSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testCompensateSubprocessInsideSubprocess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("throw compensation");
        this.completeTask("Cancel Hotel");
        this.completeTask("Cancel Flight");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensateParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Task singleResult = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(singleResult.getId());
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testCompensateParallelSubprocessCompHandlerWaitstate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        List compensationHandlerTasks = this.taskService.createTaskQuery().taskDefinitionKey("undoBookHotel").list();
        Assert.assertEquals((long)5L, (long)compensationHandlerTasks.size());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        List<ActivityInstance> compensationHandlerInstances = this.getInstancesForActivityId(rootActivityInstance, "undoBookHotel");
        Assert.assertEquals((long)5L, (long)compensationHandlerInstances.size());
        for (Task task : compensationHandlerTasks) {
            this.taskService.complete(task.getId());
        }
        Task singleResult = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(singleResult.getId());
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensateParallelSubprocessCompHandlerWaitstate.bpmn20.xml"})
    @Test
    public void testDeleteParallelSubprocessCompHandlerWaitstate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        List compensationHandlerTasks = this.taskService.createTaskQuery().taskDefinitionKey("undoBookHotel").list();
        Assert.assertEquals((long)5L, (long)compensationHandlerTasks.size());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "");
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testCompensateMiSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testCompensateScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testCompensateActivityRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Assert.assertEquals((Object)5, (Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookHotel"));
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "undoBookFlight"));
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testCompensateSubprocessWithBoundaryEvent() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)compensationTask);
        Assert.assertEquals((Object)"undoSubprocess", (Object)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        this.runtimeService.signal(instance.getId());
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment
    @Test
    public void testCompensateActivityInSubprocess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Task scopeTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(scopeTask.getId());
        this.runtimeService.signal(instance.getId());
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)compensationTask);
        Assert.assertEquals((Object)"undoScopeTask", (Object)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        this.runtimeService.signal(instance.getId());
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment
    @Test
    public void testCompensateActivityInConcurrentSubprocess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        Task scopeTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("scopeTask").singleResult();
        this.taskService.complete(scopeTask.getId());
        Task outerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("outerTask").singleResult();
        this.taskService.complete(outerTask.getId());
        this.runtimeService.signal(instance.getId());
        Task compensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)compensationTask);
        Assert.assertEquals((Object)"undoScopeTask", (Object)compensationTask.getTaskDefinitionKey());
        this.taskService.complete(compensationTask.getId());
        this.runtimeService.signal(instance.getId());
        this.testRule.assertProcessEnded(instance.getId());
    }

    @Deployment
    @Test
    public void testCompensateConcurrentMiActivity() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTasks("Book Hotel", 4);
        this.completeTaskWithVariable("Request Vacation", "accept", false);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskName("Cancel Hotel").count());
        this.completeTask("Book Hotel");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensateConcurrentMiSubprocess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTasks("Book Hotel", 4);
        this.completeTaskWithVariable("Request Vacation", "accept", false);
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskName("Cancel Hotel").count());
        this.completeTask("Book Hotel");
        this.runtimeService.signal(processInstanceId);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensateActivityRefMiActivity() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTasks("Book Hotel", 5);
        this.completeTaskWithVariable("Request Vacation", "accept", false);
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        this.completeTasks("Cancel Hotel", 5);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensateActivityRefMiSubprocess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTasks("Book Hotel", 5);
        this.completeTaskWithVariable("Request Vacation", "accept", false);
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        this.completeTasks("Cancel Hotel", 5);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCallActivityCompensationHandler.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/compensate/CompensationHandler.bpmn20.xml"})
    @Test
    public void testCallActivityCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)6L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        }
    }

    @Deployment
    @Test
    public void testCompensateMiSubprocessVariableSnapshots() {
        List<String> hotels = Arrays.asList("Rupert", "Vogsphere", "Milliways", "Taunton", "Ysolldins");
        SetVariablesDelegate.setValues(hotels);
        this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        Assert.assertTrue((boolean)GetVariablesDelegate.values.containsAll(hotels));
    }

    @Deployment
    @Test
    public void testCompensateMiSubprocessWithCompensationEventSubprocessVariableSnapshots() {
        List<String> hotels = Arrays.asList("Rupert", "Vogsphere", "Milliways", "Taunton", "Ysolldins");
        SetVariablesDelegate.setValues(hotels);
        this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
        }
        Assert.assertTrue((boolean)GetVariablesDelegate.values.containsAll(hotels));
    }

    @Deployment
    @Ignore(value="Fix CAM-4268")
    @Test
    public void testCompensateMiSubprocessVariableSnapshotOfElementVariable() {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        List<String> flights = Arrays.asList("STS-14", "STS-28");
        variables.put("flights", flights);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess", variables);
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)flights.size(), (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
        }
        Assert.assertEquals(flights, BookFlightService.bookedFlights);
        Assert.assertEquals(flights, CancelFlightService.canceledFlights);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationTriggeredByEventSubProcessActivityRef.bpmn20.xml"})
    @Test
    public void testCompensateActivityRefTriggeredByEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            Assert.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            Assert.assertEquals((Object)"undoBookHotel", (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            Assert.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationTriggeredByEventSubProcessInSubProcessActivityRef.bpmn20.xml"})
    @Test
    public void testCompensateActivityRefTriggeredByEventSubprocessInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            Assert.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            Assert.assertEquals((Object)"undoBookHotel", (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            Assert.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationInEventSubProcessActivityRef.bpmn20.xml"})
    @Test
    public void testCompensateActivityRefInEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookSecondHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            Assert.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            Assert.assertEquals((Object)"undoBookSecondHotel", (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            Assert.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookFlight").count());
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableName("undoBookHotel").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationInEventSubProcess.bpmn20.xml"})
    @Test
    public void testCompensateInEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.testRule.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookSecondHotel");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            Assert.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            Assert.assertEquals((Object)"undoBookSecondHotel", (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getVariableName());
            Assert.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookFlight");
            Assert.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            Assert.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("undoBookHotel");
            Assert.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            Assert.assertEquals((Object)5, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
        }
    }

    @Deployment
    @Test
    public void testExecutionListeners() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("start", 0);
        variables.put("end", 0);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        int started = (Integer)this.runtimeService.getVariable(processInstance.getId(), "start");
        Assert.assertEquals((long)5L, (long)started);
        int ended = (Integer)this.runtimeService.getVariable(processInstance.getId(), "end");
        Assert.assertEquals((long)5L, (long)ended);
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            long finishedCount = this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").finished().count();
            Assert.assertEquals((long)5L, (long)finishedCount);
        }
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeWithoutEventScope() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task").done());
    }

    @Deployment
    @Test
    public void testConcurrentExecutionsAndPendingCompensation() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult()).getId();
        this.taskService.complete(taskId);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().up().child("subProcess").eventScope().scope().up().done());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult()).getId();
        this.taskService.complete(taskId);
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().child("subProcess").eventScope().scope().up().done());
        tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).activity("task2").done());
        taskId = ((Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult()).getId();
        this.taskService.complete(taskId);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensationEndEventWithScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
        }
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testCompensationEndEventWithActivityRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        if (!this.processEngineConfiguration.getHistory().equals("none")) {
            Assert.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookHotel").count());
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("undoBookFlight").count());
        }
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.activityWithCompensationEndEvent.bpmn20.xml"})
    @Test
    public void testActivityInstanceTreeForCompensationEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("end").activity("undoBookHotel").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.compensationMiActivity.bpmn20.xml"})
    @Test
    public void testActivityInstanceTreeForMiActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("end").beginMiBody("bookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensateParallelSubprocessCompHandlerWaitstate.bpmn20.xml"})
    @Test
    public void testActivityInstanceTreeForParallelMiActivityInSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("parallelTask").activity("throwCompensate").beginScope("scope").beginMiBody("bookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.compensationMiSubprocess.bpmn20.xml"})
    @Test
    public void testActivityInstanceTreeForMiSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.completeTasks("Book Hotel", 5);
        this.completeTask("throwCompensation");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwingCompensation").beginMiBody("scope").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").activity("undoBookHotel").done());
    }

    @Deployment
    @Ignore(value="CAM-4903")
    @Test
    public void testActivityInstanceTreeForMiSubProcessDefaultHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.completeTasks("Book Hotel", 5);
        this.completeTask("throwCompensation");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwingCompensation").beginMiBody("scope").beginScope("scope").activity("undoBookHotel").endScope().beginScope("scope").activity("undoBookHotel").endScope().beginScope("scope").activity("undoBookHotel").endScope().beginScope("scope").activity("undoBookHotel").endScope().beginScope("scope").activity("undoBookHotel").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.activityWithCompensationEndEvent.bpmn20.xml"})
    @Test
    public void testCancelProcessInstanceWithActiveCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("compensateProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationEventSubProcess.bpmn20.xml"})
    @Test
    public void testCompensationEventSubProcessWithScope() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("bookingProcess").getId();
        this.completeTask("Book Flight");
        this.completeTask("Book Hotel");
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.completeTask("Cancel Flight");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.completeTask("Cancel Hotel");
        this.completeTask("Update Customer Record");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensationEventSubProcessWithActivityRef() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("bookingProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.completeTask("Cancel Hotel");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testCompensationEventSubProcess.bpmn20.xml"})
    @Test
    public void testActivityInstanceTreeForCompensationEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("bookingProcess");
        this.completeTask("Book Flight");
        this.completeTask("Book Hotel");
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwCompensation").beginScope("booking-subprocess").activity("cancelFlight").beginScope("compensationSubProcess").activity("compensateFlight").done());
    }

    @Deployment
    @Test
    public void testCompensateMiSubprocessWithCompensationEventSubProcess() {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        variables.put("flights", Arrays.asList("STS-14", "STS-28"));
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("bookingProcess", variables).getId();
        this.completeTask("Book Flight");
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("Book Hotel");
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        this.completeTasks("Cancel Flight", 2);
        this.completeTasks("Cancel Hotel", 2);
        this.completeTasks("Update Customer Record", 2);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensateParallelMiSubprocessWithCompensationEventSubProcess() {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        variables.put("flights", Arrays.asList("STS-14", "STS-28"));
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("bookingProcess", variables).getId();
        this.completeTasks("Book Flight", 2);
        this.completeTasks("Book Hotel", 2);
        this.completeTaskWithVariable("Validate Booking", "valid", false);
        this.completeTasks("Cancel Flight", 2);
        this.completeTasks("Cancel Hotel", 2);
        this.completeTasks("Update Customer Record", 2);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensationEventSubprocessWithoutBoundaryEvents() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("throw compensation");
        this.completeTask("Cancel Flight");
        this.completeTask("Cancel Hotel");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensationEventSubprocessReThrowCompensationEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("throw compensation");
        this.completeTask("Cancel Hotel");
        this.completeTask("Cancel Flight");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testCompensationEventSubprocessConsumeCompensationEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("compensateProcess").getId();
        this.completeTask("Book Hotel");
        this.completeTask("Book Flight");
        this.completeTask("throw compensation");
        this.completeTask("Cancel Hotel");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testSubprocessCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandler");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        Task subProcessTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)subProcessTask);
        Assert.assertEquals((Object)"subProcessTask", (Object)subProcessTask.getTaskDefinitionKey());
        this.taskService.complete(subProcessTask.getId());
        Task afterCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterCompensationTask);
        Assert.assertEquals((Object)"beforeEnd", (Object)afterCompensationTask.getTaskDefinitionKey());
        this.taskService.complete(afterCompensationTask.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testSubprocessCompensationHandler.bpmn20.xml"})
    @Test
    public void testSubprocessCompensationHandlerActivityInstanceTree() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandler");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwCompensate").beginScope("compensationHandler").activity("subProcessTask").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testSubprocessCompensationHandler.bpmn20.xml"})
    @Test
    public void testSubprocessCompensationHandlerDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandler");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Ignore(value="CAM-4387")
    @Test
    public void testSubprocessCompensationHandlerWithEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandlerWithEventSubprocess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        this.runtimeService.correlateMessage("Message");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"eventSubProcessTask", (Object)task.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.testSubprocessCompensationHandlerWithEventSubprocess.bpmn20.xml"})
    @Ignore(value="CAM-4387")
    @Test
    public void testSubprocessCompensationHandlerWithEventSubprocessActivityInstanceTree() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessCompensationHandlerWithEventSubprocess");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        this.runtimeService.correlateMessage("Message");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("throwCompensate").beginScope("compensationHandler").beginScope("eventSubProcess").activity("eventSubProcessTask").done());
    }

    @Deployment
    @Ignore(value="CAM-4387")
    @Test
    public void testReceiveTaskCompensationHandler() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveTaskCompensationHandler");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)eventSubscription);
        Assert.assertEquals((Object)EventType.MESSAGE, (Object)eventSubscription.getEventType());
        this.runtimeService.correlateMessage("Message");
        Task afterCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterCompensationTask);
        Assert.assertEquals((Object)"beforeEnd", (Object)afterCompensationTask.getTaskDefinitionKey());
        this.taskService.complete(afterCompensationTask.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testConcurrentScopeCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentScopeCompensation");
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("beforeCompensationTask").singleResult();
        Task concurrentTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("concurrentTask").singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("compensateScope1Task");
            Assert.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            Assert.assertEquals((Object)1, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
            historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().variableName("compensateScope2Task");
            Assert.assertEquals((long)1L, (long)historicVariableInstanceQuery.count());
            Assert.assertEquals((Object)1, (Object)((HistoricVariableInstance)historicVariableInstanceQuery.list().get(0)).getValue());
        }
        this.taskService.complete(concurrentTask.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testLocalVariablesInEndExecutionListener() {
        SetLocalVariableListener setListener = new SetLocalVariableListener("foo", "bar");
        ReadLocalVariableListener readListener = new ReadLocalVariableListener("foo");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("setListener", (Object)setListener).putValue("readListener", (Object)readListener));
        Task beforeCompensationTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCompensationTask.getId());
        readListener = (ReadLocalVariableListener)this.runtimeService.getVariable(processInstance.getId(), "readListener");
        Assert.assertEquals((long)1L, (long)readListener.getVariableEvents().size());
        ReadLocalVariableListener.VariableEvent event = readListener.getVariableEvents().get(0);
        Assert.assertEquals((Object)"foo", (Object)event.getVariableName());
        Assert.assertEquals((Object)"bar", (Object)event.getVariableValue());
    }

    @RequiredHistoryLevel(value="activity")
    @Ignore
    @Test
    public void testDeleteInstanceWithEventScopeExecution() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"foo").startEvent("start").subProcess("subProcess").embeddedSubProcess().startEvent("subProcessStart").endEvent("subProcessEnd").subProcessDone().userTask("userTask").done();
        modelInstance = ((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("subProcess").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent().compensateEventDefinition().compensateEventDefinitionDone().endEvent().done();
        this.testRule.deploy(modelInstance);
        long dayInMillis = 86400000L;
        Date date1 = new Date(10L * dayInMillis);
        ClockUtil.setCurrentTime((Date)date1);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("foo");
        Date date2 = new Date(date1.getTime() + dayInMillis);
        ClockUtil.setCurrentTime((Date)date2);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        List historicActivityInstance = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByActivityId().asc()).list();
        Assert.assertEquals((long)5L, (long)historicActivityInstance.size());
        Assert.assertEquals((Object)"start", (Object)((HistoricActivityInstance)historicActivityInstance.get(0)).getActivityId());
        Assert.assertEquals((Object)date1, (Object)((HistoricActivityInstance)historicActivityInstance.get(0)).getEndTime());
        Assert.assertEquals((Object)"subProcess", (Object)((HistoricActivityInstance)historicActivityInstance.get(1)).getActivityId());
        Assert.assertEquals((Object)date1, (Object)((HistoricActivityInstance)historicActivityInstance.get(1)).getEndTime());
        Assert.assertEquals((Object)"subProcessEnd", (Object)((HistoricActivityInstance)historicActivityInstance.get(2)).getActivityId());
        Assert.assertEquals((Object)date1, (Object)((HistoricActivityInstance)historicActivityInstance.get(2)).getEndTime());
        Assert.assertEquals((Object)"subProcessStart", (Object)((HistoricActivityInstance)historicActivityInstance.get(3)).getActivityId());
        Assert.assertEquals((Object)date1, (Object)((HistoricActivityInstance)historicActivityInstance.get(3)).getEndTime());
        Assert.assertEquals((Object)"userTask", (Object)((HistoricActivityInstance)historicActivityInstance.get(4)).getActivityId());
        Assert.assertEquals((Object)date2, (Object)((HistoricActivityInstance)historicActivityInstance.get(4)).getEndTime());
    }

    private void completeTask(String taskName) {
        this.completeTasks(taskName, 1);
    }

    private void completeTasks(String taskName, int times) {
        List tasks = this.taskService.createTaskQuery().taskName(taskName).list();
        Assert.assertTrue((String)("Actual there are " + tasks.size() + " open tasks with name '" + taskName + "'. Expected at least " + times), (times <= tasks.size() ? 1 : 0) != 0);
        Iterator taskIterator = tasks.iterator();
        for (int i = 0; i < times; ++i) {
            Task task = (Task)taskIterator.next();
            this.taskService.complete(task.getId());
        }
    }

    private void completeTaskWithVariable(String taskName, String variable, Object value) {
        Task task = (Task)this.taskService.createTaskQuery().taskName(taskName).singleResult();
        Assert.assertNotNull((String)("No open task with name '" + taskName + "'"), (Object)task);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (variable != null) {
            variables.put(variable, value);
        }
        this.taskService.complete(task.getId(), variables);
    }
}

