/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.escalation;

import java.util.HashMap;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class EscalationEventSubprocessTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testCatchEscalationEventInsideSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @RequiredHistoryLevel(value="full")
    @Test
    public void testThrowEscalationEventFromEventSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("embeddedEventSubprocess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskName("task in subprocess").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).taskName("task in process").count());
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNull((Object)job);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("EscalationCatchBoundaryEvent").finished().count());
    }

    @Deployment
    @Test
    public void testCatchEscalationEventFromEmbeddedSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testCatchEscalationEventFromCallActivity.bpmn20.xml"})
    @Test
    public void testCatchEscalationEventFromCallActivity() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after thrown escalation").count());
    }

    @Deployment
    @Test
    public void testCatchEscalationEventFromTopLevelProcess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after thrown escalation").count());
    }

    @Deployment
    @Test
    public void testCatchEscalationEventFromMultiInstanceSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)10L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testPreferEscalationEventSubprocessToBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testEscalationEventSubprocessWithEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation 1").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testEscalationEventSubprocessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testInterruptionEscalationEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testInterruptingEscalationEventSubprocessWithCallActivity.bpmn20.xml"})
    @Test
    public void testInterruptingEscalationEventSubprocessWithCallActivity() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment
    @Test
    public void testInterruptionEscalationEventSubprocessWithMultiInstanceSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment
    @Test
    public void testReThrowEscalationEventToBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation on boundary event").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testReThrowEscalationEventToBoundaryEventWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation on boundary event").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testReThrowEscalationEventToEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation on process level").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testReThrowEscalationEventIsNotCatched() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testThrowEscalationEventToEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess1").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
        String taskId = ((Task)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess1").singleResult()).getId();
        this.taskService.complete(taskId);
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess2").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testPropagateOutputVariablesWhileCatchEscalationOnCallActivity.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileCatchEscalationOnCallActivity() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testPropagateOutputVariablesWhileCatchEscalationOnCallActivity.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesTwoTimes() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Task taskInSuperProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)taskInSuperProcess);
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
        Task taskInSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "input", (Object)999);
        this.taskService.complete(taskInSubProcess.getId());
        Assert.assertEquals((Object)999, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testPropagateOutputVariablesWhileCatchInterruptingEscalationOnCallActivity.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileCatchInterruptingEscalationOnCallActivity() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment
    @Test
    public void testRetrieveEscalationCodeVariableOnEventSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment
    @Test
    public void testRetrieveEscalationCodeVariableOnEventSubprocessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testInterruptingRetrieveEscalationCodeInSuperProcess.bpmn20.xml"})
    @Test
    public void testInterruptingRetrieveEscalationCodeInSuperProcess() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode.bpmn20.xml"})
    @Test
    public void testInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingRetrieveEscalationCodeInSuperProcess.bpmn20.xml"})
    @Test
    public void testNonInterruptingRetrieveEscalationCodeInSuperProcess() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode.bpmn20.xml"})
    @Test
    public void testNonInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingEscalationTriggeredTwice.bpmn20.xml"})
    @Test
    public void testNonInterruptingEscalationTriggeredTwiceWithMainTaskCompletedFirst() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task taskInMainprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("TaskInMainprocess").singleResult();
        this.taskService.complete(taskInMainprocess.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingEscalationTriggeredTwice.bpmn20.xml"})
    @Test
    public void testNonInterruptingEscalationTriggeredTwiceWithSubprocessTaskCompletedFirst() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task taskInMainprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("TaskInMainprocess").singleResult();
        Task taskInSubprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").singleResult();
        this.taskService.complete(taskInSubprocess.getId());
        this.taskService.complete(taskInMainprocess.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingEscalationTriggeredTwiceByIntermediateEvent.bpmn20.xml"})
    @Test
    public void testNonInterruptingEscalationTriggeredTwiceByIntermediateEventWithMainTaskCompletedFirst() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task taskInMainprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("FirstTaskInMainprocess").singleResult();
        this.taskService.complete(taskInMainprocess.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("SecondTaskInMainprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testNonInterruptingEscalationTriggeredTwiceByIntermediateEvent.bpmn20.xml"})
    @Test
    public void testNonInterruptingEscalationTriggeredTwiceByIntermediateEventWithSubprocessTaskCompletedFirst() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task taskInMainprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("FirstTaskInMainprocess").singleResult();
        Task taskInSubprocess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").singleResult();
        this.taskService.complete(taskInSubprocess.getId());
        this.taskService.complete(taskInMainprocess.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("TaskInSubprocess").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("SecondTaskInMainprocess").count());
    }
}

