/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.variables.FailingJavaSerializable;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MessageIntermediateEventTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJavaSerializationFormatEnabled(true));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Deployment
    @Test
    public void testSingleIntermediateMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        Assert.assertNotNull((Object)activeActivityIds);
        Assert.assertEquals((long)1L, (long)activeActivityIds.size());
        Assert.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        String messageName = "newInvoiceMessage";
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName(messageName).singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived(messageName, execution.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    @Deployment
    @Test
    public void testConcurrentIntermediateMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        Assert.assertNotNull((Object)activeActivityIds);
        Assert.assertEquals((long)2L, (long)activeActivityIds.size());
        Assert.assertTrue((boolean)activeActivityIds.contains("messageCatch1"));
        Assert.assertTrue((boolean)activeActivityIds.contains("messageCatch2"));
        String messageName = "newInvoiceMessage";
        List executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName(messageName).list();
        Assert.assertNotNull((Object)executions);
        Assert.assertEquals((long)2L, (long)executions.size());
        this.runtimeService.messageEventReceived(messageName, ((Execution)executions.get(0)).getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((Object)task);
        this.runtimeService.messageEventReceived(messageName, ((Execution)executions.get(1)).getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    @Test
    public void testIntermediateMessageEventRedeployment() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testSingleIntermediateMessageEvent.bpmn20.xml").deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        Assert.assertNotNull((Object)activeActivityIds);
        Assert.assertEquals((long)1L, (long)activeActivityIds.size());
        Assert.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testSingleIntermediateMessageEvent.bpmn20.xml").deploy();
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        Assert.assertNotNull((Object)activeActivityIds);
        Assert.assertEquals((long)1L, (long)activeActivityIds.size());
        Assert.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testEmptyMessageNameFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testEmptyMessageNameFails.bpmn20.xml").deploy();
            Assert.fail((String)"exception expected");
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot have a message event subscription with an empty or missing name"));
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"messageCatch");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testSingleIntermediateMessageEvent.bpmn20.xml"})
    @Test
    public void testSetSerializedVariableValues() throws IOException, ClassNotFoundException {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        EventSubscription messageEventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        FailingJavaSerializable javaSerializable = new FailingJavaSerializable("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(javaSerializable);
        String serializedObject = StringUtil.fromBytes((byte[])Base64.encodeBase64((byte[])baos.toByteArray()), (ProcessEngine)this.engineRule.getProcessEngine());
        try {
            new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        }
        catch (RuntimeException e) {
            this.testRule.assertTextPresent("Exception while deserializing object.", e.getMessage());
        }
        this.runtimeService.messageEventReceived("newInvoiceMessage", messageEventSubscription.getExecutionId(), (Map)Variables.createVariables().putValueTyped("var", Variables.serializedObjectValue((String)serializedObject).objectTypeName(FailingJavaSerializable.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()));
        ObjectValue variableTyped = (ObjectValue)this.runtimeService.getVariableTyped(processInstance.getId(), "var", false);
        Assert.assertNotNull((Object)variableTyped);
        Assert.assertFalse((boolean)variableTyped.isDeserialized());
        Assert.assertEquals((Object)serializedObject, (Object)variableTyped.getValueSerialized());
        Assert.assertEquals((Object)FailingJavaSerializable.class.getName(), (Object)variableTyped.getObjectTypeName());
        Assert.assertEquals((Object)Variables.SerializationDataFormats.JAVA.getName(), (Object)variableTyped.getSerializationDataFormat());
    }

    @Deployment
    @Test
    public void testExpressionInSingleIntermediateMessageEvent() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process", variables);
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        Assert.assertNotNull((Object)activeActivityIds);
        Assert.assertEquals((long)1L, (long)activeActivityIds.size());
        Assert.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        String messageName = "newInvoiceMessage-bar";
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName(messageName).singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived(messageName, execution.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }
}

