/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public class SignalEventConcurrencyTest
extends ConcurrencyTestHelper {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected EventHandler signalEventHandler;
    protected EventHandler evSpy;

    @Override
    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        super.init();
        this.signalEventHandler = this.processEngineConfiguration.getEventHandler("signal");
        this.evSpy = (EventHandler)Mockito.spy((Object)this.signalEventHandler);
        this.processEngineConfiguration.getEventHandlers().put("signal", this.evSpy);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.getEventHandlers().put("signal", this.signalEventHandler);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventConcurrencyTest.testSignalWithCompletedExecution.bpmn20.xml"})
    public void shouldThrowExceptionWhenSignallingWithCompletedExecution() {
        this.runtimeService.startProcessInstanceByKey("mainProcess");
        ConcurrencyTestHelper.ControllableCommand<Object> sendSignalCommand = new ConcurrencyTestHelper.ControllableCommand<Object>(){

            public Object execute(CommandContext commandContext) {
                Execution execution = (Execution)SignalEventConcurrencyTest.this.runtimeService.createExecutionQuery().activityId("IdActAlex").singleResult();
                SignalEventConcurrencyTest.this.runtimeService.createSignalEvent("effectCreatedSignal").executionId(execution.getId()).send();
                return null;
            }
        };
        ((EventHandler)Mockito.doAnswer(invocation -> {
            sendSignalCommand.getMonitor().sync();
            return invocation.callRealMethod();
        }).when((Object)this.evSpy)).handleEvent((EventSubscriptionEntity)Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), (String)Mockito.any(), (CommandContext)Mockito.any());
        ConcurrencyTestHelper.ThreadControl signalThread = this.executeControllableCommand(sendSignalCommand);
        signalThread.reportInterrupts();
        signalThread.waitForSync();
        Task mainTask = (Task)this.taskService.createTaskQuery().active().singleResult();
        this.taskService.complete(mainTask.getId());
        signalThread.waitUntilDone(true);
        Throwable exception = signalThread.getException();
        Assertions.assertThat((Throwable)exception).isInstanceOf(NullValueException.class);
        Assertions.assertThat((Throwable)exception).hasMessage(String.format("Cannot restore state of process instance %s: list of executions is empty", mainTask.getProcessInstanceId()));
    }
}

